package com.sonicsw.mf.framework.agent;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;

import com.sonicsw.mf.common.url.SonicRNStreamHandler;

public class SonicURLStreamHandlerFactoryImpl
implements URLStreamHandlerFactory
{
    private ContainerImpl m_container;
    private URLStreamHandler m_sonicfsHandler;
    private URLStreamHandler m_sonichomeHandler;
    private URLStreamHandler m_dsdataHandler;
    private URLStreamHandler m_nullHandler;
    private URLStreamHandler m_sonicrnHandler;

    SonicURLStreamHandlerFactoryImpl(ContainerImpl container)
    {
        m_container = container;
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol)
    {
        if (protocol.equalsIgnoreCase("sonicfs"))
        {
            if (m_sonicfsHandler == null)
            {
                m_sonicfsHandler = new SonicfsURLStreamHandler(m_container,  com.sonicsw.mf.common.util.Container.SONICFS_PROTOCOL);
            }

            return m_sonicfsHandler;
        }
        else if (protocol.equalsIgnoreCase("sonichome"))
        {
            if (m_sonichomeHandler == null)
            {
                m_sonichomeHandler = new SonicfsURLStreamHandler(m_container,  com.sonicsw.mf.common.util.Container.SONICHOME_PROTOCOL);
            }

            return m_sonichomeHandler;
        }
        else if (protocol.equalsIgnoreCase("dsdata")) // for legacy purposes
        {
            if (m_dsdataHandler == null)
            {
                m_dsdataHandler = new DsdataURLStreamHandler(m_container);
            }

            return m_dsdataHandler;
        }// To allow url's to be parsed as a destination for invocations.
        else if (protocol.equalsIgnoreCase("sonic") || protocol.equalsIgnoreCase("jndi")) {
            if (m_nullHandler ==null)
            {
                m_nullHandler = new NullStreamHandler("sonic");
            }
            return m_nullHandler;
        }
        if (protocol.equalsIgnoreCase("sonicrn"))  // the handler is defined only when we have a DS in the container
        {
            if (m_sonicrnHandler == null && m_container.getDS().isLocalDS())
            {
                m_sonicrnHandler = new SonicRNStreamHandler(m_container.getDS().getLocalDS(), true);
            }
            //TODO: We might want ContainerDS to be a URL resolver TBD..
            return m_sonicrnHandler;
        }
            
        return null;
    }
    
    void resetSonicRNHandlerDS()
    {
        if(m_sonicrnHandler != null)
        {
            ((SonicRNStreamHandler)m_sonicrnHandler).setDirectoryService(m_container.getDS().getLocalDS());
        }
    }
    
    private class NullStreamHandler
        extends URLStreamHandler
    {

        private String protocol;

        public NullStreamHandler(String protocolName)
        {
            this.protocol = protocolName;
        }
        
        @Override
        protected URLConnection openConnection(URL u)
            throws IOException
        {
            throw new IOException("Can not open URL's of protocol:" + protocol);
        }

        /* (non-Javadoc)
         * @see java.net.URLStreamHandler#toExternalForm(java.net.URL)
         */
        @Override
        protected String toExternalForm(URL u)
        {
            String ret = "";
                
            if (u.getProtocol().equals("sonic")) {
                ret = "sonic:///" + u.getHost()  + u.getPath();
            }
            else if (u.getProtocol().equals("jndi")) {
                ret = "jndi:" + u.getHost()  + u.getPath();
            }
            else
            {
                ret = super.toExternalForm(u);
            }
                
            return ret;
        }        
    }    
}
