package com.sonicsw.mf.framework.agent;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

import com.sonicsw.mf.common.MFException;
import com.sonicsw.mf.common.MFRuntimeException;
import com.sonicsw.mf.framework.util.URLUtility;

public class SonicfsURLStreamHandler
extends URLStreamHandler
{
    private ContainerImpl m_container;
    private String m_protocolPrefix;

    SonicfsURLStreamHandler(ContainerImpl container, String protocolPrefix)
    {
        m_container = container;
        m_protocolPrefix = protocolPrefix;
    }

    @Override
    protected URLConnection openConnection(URL url)
    throws IOException
    {
        return new Connection(url);
    }

    public class Connection
    extends URLConnection
    {
        private Connection(URL url)
        {
            super(url);
        }

        @Override
        public void connect() throws IOException { }

        @Override
        public InputStream getInputStream()
        throws IOException
        {
            try
            {
                String path = url.getFile();
                if (path != null)
                {
                    path = URLUtility.decode(path);
                }
                String filePath = m_protocolPrefix + (path != null ? path.substring(1) : "");
                File file = SonicfsURLStreamHandler.this.m_container.getLocalFile(filePath);
                if (file == null)
                {
                    throw new FileNotFoundException("Could not read " + filePath);
                }
                return new BufferedInputStream(new FileInputStream(file));
            }
            catch (MFException e)
            {
                IOException ioe = new IOException("Failed to get input stream for " + super.getURL().toExternalForm());
                ioe.initCause(e);
                throw ioe;
            }
            catch (MFRuntimeException e)
            {
                IOException ioe = new IOException("Failed to get input stream for " + super.getURL().toExternalForm());
                ioe.initCause(e);
                throw ioe;
            }
        }

        @Override
        public String getContentType()
        {
            return "application/octet-stream";
        }
        
        // override the default of URLConnection to use the cached jar files. The class
        // sun.net.www.protocol.jar.JarFileFactory keeps a cache of jar files which gets
        // used from under the URLClassLoaders if the connections don't turn caching off.
        @Override
        public boolean getUseCaches()
        {
            return false;
        }
    }
}
