package com.sonicsw.mf.framework.agent.cache.impl;

final class Lock
{
    private boolean m_isLocked;
    Lock()
    {
        m_isLocked = false;
    }
    synchronized void lock()
    {
        m_isLocked = true;
    }
    synchronized void unlock()
    {
        m_isLocked = false;
        notifyAll();
    }
    synchronized void waitUntilUnlocked()
    {
        while (m_isLocked)
        {
            try
            {
                wait();
            }
                catch (InterruptedException e){}
        }
    }
}
