package com.sonicsw.mf.framework.agent.cache.impl;

import java.io.File;

import com.sonicsw.mf.common.config.impl.EntityName;
import com.sonicsw.mf.framework.agent.cache.PersistentCacheException;
import com.sonicsw.mf.framework.directory.storage.StorageException;
import com.sonicsw.mf.framework.directory.storage.fs.FSStorage;

/**
 * <p>Title: </p>
 * <p>Description: Adds a synchronized wrapper around FSStorage. </p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: Sonic Software Corporation</p>
 * @author Mari Davila
 * @version 1.0
 */
public class PersistentBlobCache
{
    private FSStorage m_storage;
    private boolean DEBUG = false;


    PersistentBlobCache(String hostDirName, String domainName, String dataDirName, String password, boolean doSync)
        throws StorageException, PersistentCacheException
    {
        m_storage = new FSStorage(hostDirName, domainName, dataDirName, password, false);
    }

    public synchronized File blobToFile(EntityName elementName)
    {
        return m_storage.blobToFile(elementName);
    }

    public synchronized void appendBlob(EntityName blobName, byte[] blob, int blobOff, int blobLen, int src)
        throws StorageException, PersistentCacheException
    {
        if (DEBUG)
        {
            System.out.println("PersistentBlobCache.appendBlob " + blobName.getName());
        }
        m_storage.appendBlob(blobName, blob, blobOff, blobLen, src);
    }

    public synchronized void deleteBlob(EntityName blobName) throws StorageException, PersistentCacheException
    {
        if (DEBUG)
        {
            System.out.println("PersistentBlobCache.deleteBlob " + blobName.getName());
        }
        m_storage.deleteBlob(blobName);
    }
}
