package com.sonicsw.mf.framework.agent.ci;

import java.io.File;
import java.util.ArrayList;

import com.sonicsw.mf.common.ILogger;

abstract public class AbstractContainerProcess
{
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final int STANDARD_OUTPUT = 1;
    public static final int STANDARD_ERROR = 2;

    protected ArrayList m_execCommand;
    protected File m_workDir;
    protected Process m_containerProcess;
    private boolean m_isRunning;
    protected String m_containerName;
    protected ILogger m_logger;
    protected String m_outputString;
    protected String m_errorString;


    String getOutput()
    {
        return m_outputString;
    }

    String getError()
    {
        return m_errorString;
    }

    abstract protected void exec() throws Exception;

    public int waitFor()
    {
        while (true)
        {
            try
            {
                int exitCode = m_containerProcess.waitFor();
                setRunning(false);
                return exitCode;
            }
            catch (InterruptedException e)
            {
                m_containerProcess.destroy();
                continue;
            }
        }
    }

    protected synchronized void setRunning(boolean running)
    {
        m_isRunning = running;
    }

    protected synchronized boolean isRunning()
    {
        return m_isRunning;
    }

    protected void logMessage(String message, Throwable t, int severityLevel)
    {
        if (m_logger != null)
        {
            m_logger.logMessage(message, t, severityLevel);
        }
    }
}
