package com.sonicsw.mf.framework.agent.ci;

import java.io.File;
import java.net.URL;

import com.sonicsw.mf.framework.agent.ExpandedSonicArchive;

final public class CARClasspath
{
    String[] m_launchClasspathItems;
    String[] m_bootClasspathItems;
    String[] m_bootAppendClasspathItems;
    String[] m_bootPrependClasspathItems;

    public CARClasspath(File archiveFile) throws Exception
    {
        ExpandedSonicArchive expandedArchive = new ExpandedSonicArchive(archiveFile);
        m_launchClasspathItems = getFileNames(expandedArchive.getLaunchClasspath());
        m_bootClasspathItems = getFileNames(expandedArchive.getBootClasspath());
        m_bootAppendClasspathItems = getFileNames(expandedArchive.getBootAppendClasspath());
        m_bootPrependClasspathItems = getFileNames(expandedArchive.getBootPrependClasspath());
    }

    public String[] getLaunchClasspath()
    {
        return m_launchClasspathItems;
    }

    String[] getBootClasspath()
    {
        return m_bootClasspathItems;
    }

    String[] getBootAppendClasspath()
    {
        return m_bootAppendClasspathItems;
    }

    String[] getBootPrependClasspath()
    {
        return m_bootPrependClasspathItems;
    }

    private static String[] getFileNames(URL[] classpath)
    {
        String[] fileNames = new String[classpath.length];

        for (int i = 0; i < classpath.length; i++)
        {
            String path =  classpath[i].getPath();
            if ( File.separatorChar == '\\') //Windows?
            {
                char leadingChar = path.charAt(0);
                if (leadingChar == '/')
                {
                    path = path.substring(1);
                }
            }
            fileNames[i] = path;
        }

        return fileNames;
    }
}
