package com.sonicsw.mf.framework.agent.ci;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;

import com.sonicsw.mf.framework.agent.ContainerUtil;
import com.sonicsw.mf.framework.util.RollingFileLogger;

final class CILogger implements com.sonicsw.mf.common.ILogger
{
    private RollingFileLogger m_fileLogger;
    public static final PrintStream m_stdout = System.out;
    private String m_id;
    private ArrayList m_pendingMessages = new ArrayList();

    CILogger(String id)
    {
        m_id = id;
    }

    synchronized void initLog(String logFilePath, String containerName) throws Exception
    {
        m_fileLogger = new RollingFileLogger(logFilePath, containerName);

        // redirect stdout/stderr to this logger
        if (!System.getProperty("sonicsw.mf.devSingleJVM", "false").equals("true"))
        {
            OutputStream os = new OutputStream()
            {
                @Override
                public synchronized void write(int b)
                throws IOException
                {
                    CILogger.this.m_stdout.write(b);
                    CILogger.this.m_fileLogger.write(b);
                }

                @Override
                public synchronized void write(byte[] b, int off, int len)
                throws IOException
                {
                    CILogger.this.m_stdout.write(b, off, len);
                    CILogger.this.m_fileLogger.write(b, off, len);
                }
            };
            PrintStream ps = new PrintStream(os);
            System.setOut(ps);
            System.setErr(ps);
        }
        
        if (!m_pendingMessages.isEmpty())
        {
            Iterator pendingMessages = m_pendingMessages.iterator();
            while (pendingMessages.hasNext())
            {
                m_fileLogger.logMessage((String)pendingMessages.next());
            }
            m_pendingMessages = null;
        }
    }

    @Override
    public synchronized void logMessage(String message, Throwable exception, int severityLevel)
    {
        if (exception != null)
        {
            message = ContainerUtil.appendThrowableToMessage(message, exception);
        }
        
        logMessage(message, severityLevel);
    }

    @Override
    public synchronized void logMessage(String message, int severityLevel)
    {
        String timestampedMessage = ContainerUtil.createLogMessage(null, message, severityLevel);
        if (m_fileLogger == null)
        {
            m_pendingMessages.add(timestampedMessage);
        }
        else
        {
            m_fileLogger.logMessage(timestampedMessage);
        }

        m_stdout.println(timestampedMessage);
    }

    void close()
    {
        if (m_fileLogger != null)
        {
            try
            {
                m_fileLogger.close();
            }
            catch (IOException e)
            {
                e.printStackTrace();
            }
            m_fileLogger = null;
       }
    }
}
