package com.sonicsw.mf.framework.agent.ci;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

import com.sonicsw.mf.common.ILogger;
import com.sonicsw.mf.common.runtime.Level;
import com.sonicsw.mf.framework.IContainer;

final class ContainerProcess extends AbstractContainerProcess
{
    ContainerProcess(ArrayList execCommand, String containerName, String workingDir, ILogger logger) throws Exception
    {
        m_logger = logger;
        m_outputString = "";
        m_errorString = "";
        setRunning(false);
        m_containerName = containerName;
        m_execCommand = execCommand;
        m_workDir = new File(workingDir);
        if (!m_workDir.exists())
        {
            throw new Exception("Working directory \"" + m_workDir.getAbsolutePath() + "\" does not exist.");
        }
    }

    @Override
    protected void exec() throws Exception
    {
        m_containerProcess = Runtime.getRuntime().exec((String[])m_execCommand.toArray(EMPTY_STRING_ARRAY), null, m_workDir);
        setRunning(true);
        new OutputReader(STANDARD_OUTPUT, "Standard Output", m_containerProcess.getInputStream()).start();
        new OutputReader(STANDARD_ERROR, "Standard Error", m_containerProcess.getErrorStream()).start();
    }

    private final class OutputReader extends Thread
    {
        InputStream m_stream;
        String m_threadName;
        int m_outputType;

        private OutputReader(int outputType, String threadName, InputStream stream)
        {
            super(threadName);
            m_outputType = outputType;
            setDaemon(true);
            m_threadName = threadName;
            m_stream = stream;
        }
        @Override
        public void run()
        {
            BufferedReader reader = new BufferedReader(new InputStreamReader(m_stream));
            while (isRunning())
            {
                try
                {
                    String input = reader.readLine();
                    // sometimes we get null so filter out
                    if (input == null)
                    {
                        try { Thread.sleep(250); } catch(Exception e) { }
                        continue;
                    }
                    else
                    {
                        if (m_outputType == STANDARD_OUTPUT)
                        {
                            m_outputString += input + IContainer.NEWLINE;
                        }
                        else
                        {
                            m_errorString += input + IContainer.NEWLINE;
                        }
                    }
                }
                catch(IOException e)
                {
                    ContainerProcess.this.logMessage(m_containerName + ": Failed to record " + m_threadName + ", trace follows...", e, Level.WARNING);
                    break;
                }

            }
        }

    }
}
