package com.sonicsw.mf.framework.agent.ci;

import java.util.ArrayList;
import java.util.StringTokenizer;

import com.sonicsw.mf.common.ILogger;
import com.sonicsw.mf.common.runtime.Level;
import com.sonicsw.mf.framework.IContainer;
import com.sonicsw.mf.framework.agent.LocalFileManager;


// Maintains a DS stored class path, bookeeping the class path sonicfs items and their local cache substitutes
final class DSClasspath 
{
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private String[] m_resources;
    private String[] m_substitutedResources;
    private String[] m_sonicfsResources;
    private int[] m_sonicfsMarkes;
    private ILogger m_logger;

    DSClasspath (String classpath, ILogger logger) throws Exception
    {
        m_logger = logger;
        ArrayList resources = new ArrayList();
        ArrayList sonicfsResources = new ArrayList();
        ArrayList markers = new ArrayList();

        if (classpath == null)
        {
            m_resources = EMPTY_STRING_ARRAY; 
            m_sonicfsMarkes = EMPTY_INT_ARRAY;
            m_sonicfsResources = EMPTY_STRING_ARRAY;
            return;
        }

        StringTokenizer st = new StringTokenizer(classpath, IContainer.DS_CLASSPATH_DELIMITER);
        int count = 0;
        while (st.hasMoreTokens())
        {
            String cpItem = LocalFileManager.substituteSonicHome(st.nextToken());
            String path = getSonicfsPath(cpItem);
            if (path == null)
            {
                resources.add(cpItem);
            }
            else
            {
                resources.add(path);
                sonicfsResources.add(path);
                markers.add(new Integer(count));
            }
            count++;
        }

        m_resources = (String[])resources.toArray(EMPTY_STRING_ARRAY);
        m_sonicfsResources = (String[])sonicfsResources.toArray(EMPTY_STRING_ARRAY);
        m_sonicfsMarkes = new int[markers.size()];
        for (int i = 0; i < m_sonicfsMarkes.length; i++)
        {
            m_sonicfsMarkes[i] = ((Integer)markers.get(i)).intValue();
        }
    }

    String[] getResources()
    {
        return m_resources;
    }

    String[] getSonicfsResources()
    {
        return m_sonicfsResources;
    }

    String[] getSubstitutedResources()
    {
        return m_substitutedResources;
    }

    void substituteSonicfsResources(String[] substitutes)
    {
        m_substitutedResources = new String[m_resources.length];
        int indx = 0;
        for (int i = 0; i < m_resources.length; i++)
        {
            if (indx < m_sonicfsMarkes.length && m_sonicfsMarkes[indx] == i)
            {
                m_substitutedResources[i] = substitutes[indx++];
            }
            else
            {
                m_substitutedResources[i] = m_resources[i];
            }
        }

    }

    private String getSonicfsPath(String sonicfsPath) throws Exception
    {
        // First see whether sonicfs:// is in the prefix. It's a common mistake to have sonicfs://xxx rather than
        // sonicfs:///xxx - and we would like to identify this case and log an error.
        String dsClasspathPrefix = IContainer.DS_CLASSPATH_PROTOCOL.substring(0, IContainer.DS_CLASSPATH_PROTOCOL.length() - 1);

        if (sonicfsPath.length() > dsClasspathPrefix.length() &&
            sonicfsPath.substring(0, dsClasspathPrefix.length()).equalsIgnoreCase(dsClasspathPrefix))
        {
            if (sonicfsPath.charAt(dsClasspathPrefix.length()) != '/')
            {
                logMessage("Classpath contains an invalid URL: " + sonicfsPath, Level.SEVERE);
                return null;
            }

            return sonicfsPath.substring(IContainer.DS_CLASSPATH_PROTOCOL.length() - 1);
        }
        else
        {
            return null;
        }
    }

    void logMessage(String message, int severityLevel)
    {
        m_logger.logMessage(message, severityLevel);
    }

    void logMessage(String message, Throwable t, int severityLevel)
    {
        m_logger.logMessage(message, t, severityLevel);
    }

}

