package com.sonicsw.mf.framework.agent.ci;

import java.io.File;
import java.io.IOException;
import java.util.Properties;

/**
 * Public interface to install launchers, setup containers and generate container drivers
 */
public interface ILauncherDriver
{

  /**
    * Install a launcher in Sonic Home. If, for instance, the archive version is 7.7-125, the launcher will be installed under <SONIC-HOME>/launcher7.7-125
    *
    * @param archivePath the path to the MFcontainer.car archive
    */
    public void install(String archivePath) throws IOException;

  /**
    * Intializes this LauncherDriver from an existing installed launcher
    *
    * @param version the launcher version; e.g. 7.7-125
    */
    public void initFromExistingInstall(String version);


  /**
    * Returns the launcher version of this LauncherDriver
    *
    * @return  launcher version
    */
    public String getLauncherVersion();


  /**
    * Returns the launcher directory e.g. C:/test/launcher7.7-125
    *
    * @return  launcher directory
    */
    public File getLauncherDir();

  /**
    * Generate container launch scripts, Windows Service scripts and the container.ini file
    *
    * @param containerProperties the container and Directory Service connection properties. Example:
    *    Properties props = new Properties();
    *    props.put("WINDOWS_SERVICE_NAME", "SonicRemote");
    *    props.put("CREATE_IF_DOES_NOT_EXIST", "true");
    *    props.put("DOMAIN_NAME", "Domain1");
    *    props.put("CONTAINER_PATH", "/Containers/RemoteContainer");
    *    props.put("ConnectionURLs", "tcp://localhost:2506");
    *    props.put("DefaultPassword", "Administrator");
    *    props.put("DefaultUser", "Administrator");
    *
    * @return  ILauncherContainerDriver An object used to driver the container: Start, Stop and install as WIndows Service
    */
    public ILauncherContainerDriver setupContainer(Properties containerProperties) throws Exception;


  /**
    * Generate Return an ILauncherContainerDriver for a container that was already set up
    *
    * @param containerFolderPath the container's directory
    *
    * @return  ILauncherContainerDriver An object used to driver the container: Start, Stop and install as WIndows Service
    */
    public ILauncherContainerDriver getContainer(String containerFolderPath) throws IOException;

}