package com.sonicsw.mf.framework.agent.ci;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

import com.sonicsw.mf.framework.IContainer;
import com.sonicsw.mf.framework.agent.ContainerSetup;
import com.sonicsw.mf.mgmtapi.config.constants.IContainerConstants;

/**
 * Use this class to programmatically install a launcher, setup containers and launch containers
 */
final public class LauncherDriver implements ILauncherDriver
{
    String m_sonicHome;
    String m_version;
    File m_launcherDir;

    //Unit test
    public static void mainInstallTest(final String[] args) throws Exception
    {
        ILauncherDriver launcher = new LauncherDriver("C:/test");
        launcher.install("C:/Sonic8.0/Archives/MF/8.0/MFcontainer.car");
    }

    //Unit test
    public static void main(final String[] args) throws Exception
    {
        ILauncherDriver launcher = new LauncherDriver("C:/test");
        launcher.install("C:/Sonic8.0/Archives/MF/8.0/MFcontainer.car");

        Properties props = new Properties();

        props.put("WINDOWS_SERVICE_NAME", "AutoTestContainer");
        props.put("DOMAIN_NAME", "Domain1");
        props.put("CREATE_IF_DOES_NOT_EXIST", "true");
        props.put("CONTAINER_PATH", "/Containers/AutoTestContainer");
        props.put("ConnectionURLs", "tcp://localhost:2506");
        props.put("DefaultPassword", "Administrator");
        props.put("DefaultUser", "Administrator");

        ILauncherContainerDriver containerDriver = launcher.setupContainer(props);
        //containerDriver.launchContainerWithSH();
        //containerDriver.installAsWindowsServiceAndStart();
        containerDriver.launchContainerWithBAT();
        Thread.sleep(10000);


        java.util.Hashtable env = new java.util.Hashtable();
        env.put(IContainerConstants.CONNECTIONURLS_ATTR, "tcp://localhost:2506");
        com.sonicsw.mf.jmx.client.JMSConnectorAddress address = new com.sonicsw.mf.jmx.client.JMSConnectorAddress(env);
        com.sonicsw.mf.jmx.client.JMSConnectorClient connector = new com.sonicsw.mf.jmx.client.JMSConnectorClient();
        connector.connect(address);

        containerDriver.shutdown(connector);
    }


    public LauncherDriver(String sonicHome)
    {
        m_sonicHome = sonicHome;
    }


    @Override
    public void install(String archivePath) throws IOException
    {
        m_version = new LauncherFilesInstaller().installLauncherFiles(archivePath, m_sonicHome, true);
        setlauncherDir();
    }


    @Override
    public void initFromExistingInstall(String version)
    {
        m_version = version;
        setlauncherDir();
    }


    @Override
    public String getLauncherVersion()
    {
        return m_version;
    }


    @Override
    public File getLauncherDir()
    {
        return m_launcherDir;
    }


    @Override
    public ILauncherContainerDriver setupContainer(Properties containerProperties) throws Exception
    {
        File containerDir = ContainerSetup.setupContainer(m_launcherDir.getAbsolutePath(), containerProperties);
        return new LauncherContainerDriver(containerDir, containerProperties.getProperty(IContainerConstants.DOMAIN_NAME_ATTR), containerProperties.getProperty(IContainer.CONTAINER_PATH_ATTR)) ;
    }


    @Override
    public ILauncherContainerDriver getContainer(String containerFolderPath) throws IOException
    {
        return new LauncherContainerDriver(new File(containerFolderPath));
    }

    private void setlauncherDir()
    {
        File homeDir = new File(m_sonicHome);
        m_launcherDir = new File(homeDir, IContainer.LAUNCHERS_ROOT_DIR + m_version);
    }

}