package com.sonicsw.mf.framework.agent.ci;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;

// Writes a properties file with platform specific arguments and properties
final class PlatformDependentArguments
{
    public static void main(String[] args) throws Exception
    {
        String outFileName = args[0];
        File outFile = new File(outFileName);
        outFile.delete();
        if (outFile.exists())
        {
            throw new Exception("Could not delete obsolete file " + outFileName);
        }

        PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(outFileName, false)), false);

        writeArguments(false, getJvmArguments(), writer);
        writeArguments(true, getSystemProperties(), writer);

        writer.close();
    }

    private static void writeArguments(boolean sysProp, HashMap map, PrintWriter writer)
    {
         Iterator iterator = map.keySet().iterator();
         while (iterator.hasNext())
         {
             String argKey = (String)iterator.next();
             String argValue = (String)map.get(argKey);
             if (argValue == null)
            {
                argValue = "";
            }
             String propRefix = sysProp ? "-D" : "";
             writer.println(propRefix + argKey + "=" + argValue);
         }
    }

    private static HashMap getJvmArguments()
    {
        String vendor = System.getProperty("java.vm.vendor");
        String vmName = System.getProperty("java.vm.name");
        String osName = System.getProperty("os.name");

        HashMap jvmArguments = new HashMap();

        if (vmName.toLowerCase().indexOf("hotspot") != -1)
        {
            jvmArguments.put("-server", null);
        }

        return jvmArguments;
    }

    private static HashMap getSystemProperties()
    {
        HashMap systemProperties = new HashMap();
        return systemProperties;
    }
}
