package com.sonicsw.mf.framework.agent.ci;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;

import com.sonicsw.mf.framework.IContainer;
import com.sonicsw.mf.framework.agent.ContainerUtil;


/**
 * This class can be used as the main() to stop, remove, re-install and re-start the container's Windows Service
 */
public final class WinServiceUpdate
{
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String WORKING_DIR = System.getProperty("user.dir");
    private static final String REINSTALL_BAT = WORKING_DIR + FILE_SEPARATOR + "winservice_reinstall.bat";
    private static final String REINSTALL_EROR_LOG = WORKING_DIR + FILE_SEPARATOR + "winservice_reinstall.log";

    static void startWinserviceUpdateProcess(String containerName)
    {
        try
        {
            ArrayList execCommand = new ArrayList();
            execCommand.add("cmd.exe");
            execCommand.add("/C");
            execCommand.add("start");
            execCommand.add("Sonic WS Update"); // title arg to start
            execCommand.add("\"" + REINSTALL_BAT + "\"");
            ContainerProcess wsUpdate = new ContainerProcess(execCommand, containerName, ".", null);
            wsUpdate.exec();
            int exitCode = wsUpdate.waitFor();
            if (exitCode != 0)
            {
                StringBuffer sb = new StringBuffer();
                sb.append("Failed to start the Windows Service update process: Exit error ").append(new Integer(exitCode).toString()).append(IContainer.NEWLINE);
                String outMsg = wsUpdate.getOutput();
                if (outMsg != null && outMsg.length() > 0)
                {
                    sb.append(outMsg).append(IContainer.NEWLINE);
                }
                outMsg = wsUpdate.getError();
                if (outMsg != null && outMsg.length() > 0)
                {
                    sb.append(outMsg);
                }
                log(sb.toString(), REINSTALL_EROR_LOG);
            }
        }
        catch (Throwable t)
        {
            try
            {
                log(ContainerUtil.printStackTrace(t, t.getMessage()), REINSTALL_EROR_LOG);
            }
            catch (Exception e1)
            {
            }
        }
    }

    static void log(String msg, String fileName) throws Exception
    {

        PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(fileName, false)), true);
        writer.println(msg);
        writer.close();
    }


}
