package com.sonicsw.mf.framework.daemon;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

class ScheduleInfo
{
    public static final int STOP_TYPE = 0;
    public static final int START_TYPE = 1;

    private int  m_type;
    private long m_occursType;

    //reoccurance values
    int m_schHOD = 0;
    int m_schMin = 0;
    int m_schDOW = 1;
    int m_schDOM = 0;
    int m_schMOY = 1;

    private Date m_performActionAt; //next to be scheduled start/stop time

    //Reocurrance values are:
    //indx 0 -> hh :  indx 1 -> mm ; indx 2 -> dow / dom ; indx 3 -> moy

    ScheduleInfo(String schType, String occursType, ArrayList values)
    {
        setScheduleType(schType);
        setOccursType(occursType);
        setOccursValues(values);
        setScheduledDate(new GregorianCalendar());
        
    }

    private void setOccursValues(ArrayList values)
    {
        m_schHOD = ((Integer)values.get(0)).intValue();
        m_schMin = ((Integer)values.get(1)).intValue();

        if (m_occursType == Scheduler.WEEKLY)
        {
            m_schDOW = ((Integer)values.get(2)).intValue();
        }
        else if (m_occursType == Scheduler.MONTHLY)
        {
            m_schDOM = ((Integer)values.get(2)).intValue();
        }
        else if (m_occursType == Scheduler.YEARLY)
        {
            m_schDOM = ((Integer)values.get(2)).intValue();
            m_schMOY = ((Integer)values.get(3)).intValue();
        }
    }

    private void setDateForDailyInterval(Calendar cal)
    {
        long currMS = cal.getTimeInMillis();
        
        cal.set(Calendar.HOUR_OF_DAY, m_schHOD);
        cal.set(Calendar.MINUTE, m_schMin);
        long newMS = cal.getTimeInMillis();
        
        if (newMS < currMS) {
            cal.add(Calendar.DAY_OF_YEAR, 1);
        }
        m_performActionAt = cal.getTime();        
    }

    private void setDateForWeeklyInterval(Calendar cal)
    {
        long currMS = cal.getTimeInMillis();

        cal.set(Calendar.HOUR_OF_DAY, m_schHOD);
        cal.set(Calendar.MINUTE, m_schMin );
        cal.set(Calendar.DAY_OF_WEEK, m_schDOW);
        long newMS = cal.getTimeInMillis();
        
        if (newMS < currMS) {
            cal.add(Calendar.WEEK_OF_YEAR, 1);
        }
        m_performActionAt = cal.getTime();
    }

    private void setDateForMonthlyInterval(Calendar cal)
    {
        long currMS = cal.getTimeInMillis();
        
        int maxDate = cal.getActualMaximum(Calendar.DAY_OF_MONTH);
        if(m_schDOM > maxDate) {
            cal.set(Calendar.DAY_OF_MONTH, maxDate);    
        } else {
            cal.set(Calendar.DAY_OF_MONTH, m_schDOM);
        }
        cal.set(Calendar.HOUR_OF_DAY, m_schHOD);
        cal.set(Calendar.MINUTE,m_schMin);
        long newMS = cal.getTimeInMillis();
        
        if (newMS < currMS) {
            cal.add(Calendar.MONTH, 1);
            maxDate = cal.getActualMaximum(Calendar.DAY_OF_MONTH);
            if(m_schDOM > maxDate) {
                cal.set(Calendar.DAY_OF_MONTH, maxDate);    
            } else {
                cal.set(Calendar.DAY_OF_MONTH, m_schDOM);
            }
        }
        m_performActionAt = cal.getTime();
    }

    private void setDateForYearlyInterval(Calendar cal)
    {
        long currMS = cal.getTimeInMillis();
        
        cal.set(Calendar.MONTH, m_schMOY);
        cal.set(Calendar.DAY_OF_MONTH, m_schDOM);
        cal.set(Calendar.HOUR_OF_DAY, m_schHOD);
        cal.set(Calendar.MINUTE,m_schMin);
        long newMS = cal.getTimeInMillis();
        
        if (newMS < currMS) {
            cal.add(Calendar.YEAR, 1);
        }
        m_performActionAt = cal.getTime();
    }

    //sets first scheduled day (called on ActivationDaemon.start() / ActivationDaemon.activate())
    //uses java.util.Calendar functionality to calculate day based on
    //occurs_value and occurs_type obtained from configuration.

    final void setScheduledDate(Calendar date)
    {
        date.set(Calendar.MILLISECOND, 0);
        date.set(Calendar.SECOND, 0);

        if (m_occursType == Scheduler.DAILY)
        {
            setDateForDailyInterval(date);
        }
        else 
        if (m_occursType == Scheduler.WEEKLY)
        {
            setDateForWeeklyInterval(date);
        }
        else 
        if (m_occursType == Scheduler.MONTHLY)
        {
            setDateForMonthlyInterval(date);
        }
        else 
        if (m_occursType == Scheduler.YEARLY)
        {
            setDateForYearlyInterval(date);
        }
        getBackToDesiredHour(); 
    }

   ////////////////////////////
   ////Called by Scheduler
   ///////////////////////////

    // CR 51757 The code below works to fix the edge case when a schedule falls on the "lost" hour 
    // when DST starts
    // and Calendar has reset the hour of the schedule. We get back on track. This code works
    // assuming Calendar has stayed on the same day when it picked a different hour, 
    // which is the case from testing with DST "lost" hours in the first and third hour of the day. 
    // I have found no country where DST starts on the 23rd hour of the day, and, if Calendar adjusted
    // to a different day (the next day), the following might need to be adjusted. Again, this is
    // only in the case when a schedule has been setup such that it will fall on that "lost"
    // hour.
    
    void getBackToDesiredHour()
    {
        long nextTime = m_performActionAt.getTime();
        GregorianCalendar nextCal = new GregorianCalendar();
        nextCal.setTimeInMillis(nextTime);
        int hour = nextCal.get(Calendar.HOUR_OF_DAY);
        if (hour != m_schHOD)
        {
            nextCal.set(Calendar.HOUR_OF_DAY, m_schHOD);
            setPerformActionAtDate(new Date(nextCal.getTimeInMillis()));
        }
    }


    //returns last day of the next month

    int getMaxForNextMonth()
    {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(m_performActionAt);
        //always reset to first day of month
        cal.set(Calendar.DAY_OF_MONTH,1);
        cal.add(Calendar.MONTH, 1);
        return (cal.getActualMaximum(Calendar.DAY_OF_MONTH));
    }


    //only to handle Calendar.MONTH interval

    int getOriginalSchDate()
    {
        return m_schDOM;
    }

    Date getPerformActionAtDate()
    {
        return m_performActionAt;
    }

    void setPerformActionAtDate(Date date)
    {
        m_performActionAt = date;
    }
    /////////////////////////////////////

    private void setScheduleType(String schType)
    {
        if (schType.compareToIgnoreCase("start") == 0)
        {
            m_type = START_TYPE;
        }
        else if (schType.compareToIgnoreCase("stop") == 0)
        {
            m_type = STOP_TYPE;
        }

    }

    public int getScheduleType()
    {
        return m_type;
    }

    public long getOccursType()
    {
        return m_occursType;
    }

    public final void setOccursType(String reoccurType)
    {
        if (reoccurType.equalsIgnoreCase("DAILY"))
        {
            m_occursType = Scheduler.DAILY;
        }
        else if (reoccurType.equalsIgnoreCase("WEEKLY"))
        {
            m_occursType = Scheduler.WEEKLY;
        }
        else if(reoccurType.equalsIgnoreCase("MONTHLY"))
        {
            m_occursType = Scheduler.MONTHLY;
        }
        else if(reoccurType.equalsIgnoreCase("YEARLY"))
        {
            m_occursType = Scheduler.YEARLY;
        }
        else {
            m_occursType = Scheduler.DAILY; //default
        }
    }

}