/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.framework.directory;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

import javax.jms.JMSException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

import com.odi.ReplicationController;
import com.odi.ReplicationStateHandler;

import com.sonicsw.mx.config.ConfigServerUtility;
import com.sonicsw.mx.config.IConfigServer;
import com.sonicsw.mx.config.impl.Util;
import com.sonicsw.mx.config.util.SonicFSFile;
import com.sonicsw.mx.util.IEmptyArray;
import com.sonicsw.util.debug.Debug;

import com.sonicsw.mf.comm.IGlobalComponentListener;
import com.sonicsw.mf.common.DSNotStartedException;
import com.sonicsw.mf.common.IComponent;
import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.IDSTransaction;
import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.ILogger;
import com.sonicsw.mf.common.MFException;
import com.sonicsw.mf.common.MFRuntimeException;
import com.sonicsw.mf.common.MFServiceNotActiveException;
import com.sonicsw.mf.common.Version;
import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.IBlob;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementChange;
import com.sonicsw.mf.common.config.IElementDeleteNotification;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.IEnvelope;
import com.sonicsw.mf.common.config.IFolderDeleteNotification;
import com.sonicsw.mf.common.config.IHandlerConstants;
import com.sonicsw.mf.common.config.IMFDirectories;
import com.sonicsw.mf.common.config.INamingNotification;
import com.sonicsw.mf.common.config.INextVersionToken;
import com.sonicsw.mf.common.config.IRenameNotification;
import com.sonicsw.mf.common.config.IValidationConstants;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.config.impl.Blob;
import com.sonicsw.mf.common.config.impl.Element;
import com.sonicsw.mf.common.config.impl.EntityName;
import com.sonicsw.mf.common.config.query.AttributeName;
import com.sonicsw.mf.common.config.query.FromElementList;
import com.sonicsw.mf.common.config.query.QueryBatch;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.ElementFactory;
import com.sonicsw.mf.common.dirconfig.IDeltaDirElement;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.IDirIdentity;
import com.sonicsw.mf.common.runtime.IBackupStatus;
import com.sonicsw.mf.common.runtime.IComponentIdentity;
import com.sonicsw.mf.common.runtime.IComponentState;
import com.sonicsw.mf.common.runtime.IContainerExitCodes;
import com.sonicsw.mf.common.runtime.IFaultTolerantState;
import com.sonicsw.mf.common.runtime.INotification;
import com.sonicsw.mf.common.runtime.IStateController;
import com.sonicsw.mf.common.runtime.IStateListener;
import com.sonicsw.mf.common.runtime.IStateManager;
import com.sonicsw.mf.common.runtime.Level;
import com.sonicsw.mf.common.runtime.NonRecoverableStateChangeException;
import com.sonicsw.mf.common.runtime.RecoverableStateChangeException;
import com.sonicsw.mf.common.runtime.impl.CanonicalName;
import com.sonicsw.mf.common.security.ConfigurePermissionDeniedException;
import com.sonicsw.mf.common.security.IConfigurePermissionBits;
import com.sonicsw.mf.common.security.IManagementPermission;
import com.sonicsw.mf.common.util.Container;
import com.sonicsw.mf.common.util.MFLogger;
import com.sonicsw.mf.common.util.ZipUtils;
import com.sonicsw.mf.common.view.IDeltaView;
import com.sonicsw.mf.common.view.ILogicalNameSpace;
import com.sonicsw.mf.common.view.INamingListener;
import com.sonicsw.mf.common.view.IView;
import com.sonicsw.mf.framework.AbstractFrameworkComponent;
import com.sonicsw.mf.framework.IContainer;
import com.sonicsw.mf.framework.IFrameworkComponentContext;
import com.sonicsw.mf.framework.IGlobalFrameworkComponent;
import com.sonicsw.mf.framework.agent.ClassLoaderFactory;
import com.sonicsw.mf.framework.agent.ContainerImpl;
import com.sonicsw.mf.framework.agent.JMSConnectorServer;
import com.sonicsw.mf.framework.directory.impl.DirectoryService;
import com.sonicsw.mf.framework.directory.impl.DiskFileDSHandler;
import com.sonicsw.mf.framework.directory.impl.ExtendedSonicFSFileSystem;
import com.sonicsw.mf.framework.elementversion.IArrayElementNotificationListener;
import com.sonicsw.mf.framework.elementversion.INotificationConsumer;
import com.sonicsw.mf.framework.util.ContainerCompatibility;
import com.sonicsw.mf.framework.util.StateManager;
import com.sonicsw.mf.framework.util.URLUtility;
import com.sonicsw.mf.mgmtapi.config.IActivationDaemonBean;
import com.sonicsw.mf.mgmtapi.config.IContainerBean;
import com.sonicsw.mf.mgmtapi.config.IHostManagerBean;
import com.sonicsw.mf.mgmtapi.config.MFMgmtBeanFactory;
import com.sonicsw.mf.mgmtapi.config.constants.IBackupDirectoryServiceConstants;
import com.sonicsw.mf.mgmtapi.config.constants.IContainerConstants;
import com.sonicsw.mf.mgmtapi.config.constants.IDirectoryServiceConstants;
import com.sonicsw.mf.mgmtapi.config.constants.IReplicationConnectionConstants;
import com.sonicsw.mf.mgmtapi.runtime.IAgentProxy;

import progress.message.client.EUserAlreadyConnected;


/**
 * DSComponent exposes the methods of IDirectoryAdminService and IDirectoryMFService through a MF container.
 *
 * The DS configuration element must have three attributes:
 * DOMAIN_NAME: String
 * FILE_SYSTEM_STORAGE: Attribute Set
 * HOST_DIRECTORY: String
 *
 * @see com.sonicsw.mf.common.IDirectoryAdminService
 * @see com.sonicsw.mf.framework.directory.IDirectoryMFService
 */

public class DSComponent
extends AbstractFrameworkComponent
implements IGlobalFrameworkComponent, ILogger, IClassLoaderUtility, IValidationConstants, IHandlerConstants,
           IDebuggingMasks, IFaultTolerantDS, IGlobalComponentListener
{

    public static final String GLOBAL_ID = "DIRECTORY SERVICE";
    public static final String READER_ROLE = "READER";
    public static final long SUBSCRIPTION_DURATION = 10800000; // 3 hours

    private static final String DOMAIN_DESC_TYPE  = "MF_AUTHENTICATION_DOMAIN";

    private static final IBasicElement[] EMPTY_ELEMENT_ARRAY = new IBasicElement[0];
    public static final String DS_STARTUP_ELEMENT = IMFDirectories.MF_DIR_SEPARATOR + IMFDirectories.MF_SYSTEM_DIR + IMFDirectories.MF_DIR_SEPARATOR + "dsStartup";
    public static final String DS_RENAMING_ELEMENT = IMFDirectories.MF_DIR_SEPARATOR + IMFDirectories.MF_SYSTEM_DIR + IMFDirectories.MF_DIR_SEPARATOR + "dsRenaming";
    private static IDirElement m_dsStartupElement = null;

    private static String methodsWithErrors = "";

    private static final String[] LEASE_LOCK_SIGNATURE = new String[] { String.class.getName(), String.class.getName(), Integer.class.getName() };
    private static final String[] RELEASE_LOCK_SIGNATURE = new String[] { String.class.getName(), String.class.getName() };

    // change notifications
    public static final String CHANGE_NOTIFICATION_TYPE = "Change";

    public static final String FSCHANGE_NOTIFICATION_TYPE = "FSChange";

    public static final String NAMING_NOTIFICATION_TYPE = "Naming";

    public static final String FAILOVER_NOTIFICATION_TYPE = "Failover";

    public static final String REVERT_TO_STANDBY_NOTIFICATION_TYPE = "RevertToStandby";

    public static final String CONFIGURE_PERMISSION_DENIED_NOTIFICATION_TYPE = "ConfigurePermissionDenied";

    public static final String FAULT_TOLERANCE_ROLE_DEFAULT = "";

    public static final String FAULT_TOLERANCE_ROLE_PRIMARY = "PRIMARY";

    public static final String FAULT_TOLERANCE_ROLE_BACKUP = "BACKUP";

    public static final String MF_DIR_SEPARATOR_STRING = new String(new char[] {IMFDirectories.MF_DIR_SEPARATOR});

    public static final String MFCONTEXT_ROOT_DIR = IMFDirectories.MF_DIR_SEPARATOR + IMFDirectories.MF_JNDI_DIR;

    public static final String HIERARCHICAL_TYPES_PATH = IMFDirectories.MF_DIR_SEPARATOR + "mx" + IMFDirectories.MF_DIR_SEPARATOR + "hierarchicalTypes" + IMFDirectories.MF_DIR_SEPARATOR;

    // start states
    private short m_startState;
    private static final short STARTUP_STATE_STARTING = 0;
    private static final short STARTUP_STATE_STARTED = 1;
    private static final short STARTUP_STATE_RESTARTED = 2;
    private static final short STARTUP_STATE_FAILED = 3;

    public static final boolean AUTOMATIC_DUAL_ACTIVE_RESOLUTION_DEFAULT = false;
    public static final boolean BACKUP_FAILOVER_READ_ONLY_DEFAULT = false;

    private static boolean m_startActive;

    private ContainerImpl m_containerImpl;

    // DS configuration attributes
    private String m_id;
    private String m_hostDir;
    private String m_domainName;
    private String m_encryptionPassword;
    private String m_hostDirDepricated;
    private DSStateHandler m_replicationStateHandler;
    private String m_faultToleranceRole = FAULT_TOLERANCE_ROLE_DEFAULT;
    private String m_partnerRole = FAULT_TOLERANCE_ROLE_DEFAULT;
    private String m_FTpartnerAddress;
    private int m_replicationRetryInterval;
    private int m_replicationPingInterval;
    private int m_replicationFailureDetectionTimeout;
    private int m_maxReplicationLogSize;
    private int m_replicationTimeout;
    private boolean m_dualActiveResolution;
    private boolean m_backupFailoverReadOnly;
    private HashMap[] m_replConnections;
    private HashMap m_replSSLParams;

    // DS state variables
    private String m_uniqunessCallID;
    private boolean m_dsStarted;
    private boolean m_dsStartedAtLeasetOnce = false;
    private IDirectoryService m_ds;
    private com.odi.Storage m_dsStorage;
    private Thread m_uniquenessCheckThread;
    private boolean m_uniquenessCallReceived;
    private boolean m_responseSent;
    private SubscriptionRegistry m_registry;
    private INotificationConsumer m_consumer;
    private URLClassLoader m_sharedLoader = (URLClassLoader)DSComponent.class.getClassLoader().getParent();
    private DistributedLockManager m_lockManager;
    private IStateManager m_faultToleranceStateManager;
    private boolean m_isNotFaultTolerant;
    private boolean m_isPrimary;
    private boolean m_isBackup;
    private boolean m_allowFailover = true;
    private Object m_shutdownLock = new Object();
    private SdfMFTracingIntegration m_SdfMFTracingIntegration;
    private MFLogger m_pseLogger;
    private Object m_uniquenessCheckLockObj = new Object();
    
    private static final ArrayList ATTRIBUTE_INFOS = new ArrayList();
    private static final ArrayList OPERATION_INFOS = new ArrayList();
    private static final ArrayList NOTIFICATION_INFOS = new ArrayList();

    static
    {
        m_startActive = System.getProperty(IContainer.DS_START_ACTIVE_PROPERTY, "false").equalsIgnoreCase("true");

        Method method = null;

        //
        // Attributes
        //

        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("FaultToleranceRole", String.class.getName(), "The fault tolerant role of the DS (primary or backup) or null if not fault tolerant.", true, false, false));

        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("FaultTolerantState", Short.class.getName(), "The current fault tolerant state of this Directory Service.", true, false, false));

        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("FaultTolerantStateString", String.class.getName(), "The description of the current fault tolerant state of this Directory Service.", true, false, false));

        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("AllowFailover", Boolean.class.getName(), "When this Directory Service is in a standby state and this attribute is set to 'false', fault tolerant failover to active will not occur.", true, true, false));


        //
        // Operations
        //
        MBeanParameterInfo[] mbParamInfos = null;

        OPERATION_INFOS.add(new MBeanOperationInfo("getDomain", "Gets the domain name for the configuration domain the Directory Service maintains.",
                                                   IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, String.class.getName(), MBeanOperationInfo.INFO));

        try { method = DSComponent.class.getMethod("getView", IEmptyArray.EMPTY_CLASS_ARRAY); } catch(Exception e) {e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("getView", method));

        OPERATION_INFOS.add(new MBeanOperationInfo("getDirectoryServiceVersion", "Gets the Directory Service version.",
                                                   IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, Integer.class.getName(), MBeanOperationInfo.INFO));

        OPERATION_INFOS.add(new MBeanOperationInfo("getDirectoryServiceReleaseVersion", "Gets the Directory Service release version.",
                                                   IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, String.class.getName(), MBeanOperationInfo.INFO));

        try { method = DSComponent.class.getMethod("setView", new Class[]{ IDeltaView.class }); } catch(Exception e) {e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("setView", method));

        try { method = DSComponent.class.getMethod("setViewGetToken", new Class[]{ IDeltaView.class }); } catch(Exception e) {e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("setViewGetToken", method));

        try { method = DSComponent.class.getMethod("getBlob", new Class[]{ String.class, Boolean.class }); } catch(Exception e) {e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("getBlob", method));

        try { method = DSComponent.class.getMethod("getBlob", new Class[]{ String.class, Boolean.class, Integer.class }); } catch(Exception e) {e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("getBlob", method));

        try { method = DSComponent.class.getMethod("getBlobByLogicalName",
                                                   new Class[] {String.class}); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", getBlobByLogicalName";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("getBlobByLogicalName", method));

        try { method = DSComponent.class.getMethod("getElement", new Class[]{ String.class, Boolean.class }); } catch(Exception e) {e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("getElement", method));

        try { method = DSComponent.class.getMethod("logicalToStorage", new Class[]{ String.class }); } catch(Exception e) {e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("logicalToStorage", method));

        try { method = DSComponent.class.getMethod("storageToLogical", new Class[]{ String.class }); } catch(Exception e) {e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("storageToLogical", method));

        try { method = DSComponent.class.getMethod("getElement", new Class[]{ String.class, Boolean.class, Boolean.class }); } catch(Exception e) {e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("getElement", method));

        try { method = DSComponent.class.getMethod("getElementIfUpdated", new Class[]{ Long.class, String.class, IElementIdentity.class }); } catch(Exception e) {e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("getElementIfUpdated", method));

        try { method = DSComponent.class.getMethod("getElements", new Class[]{ com.sonicsw.mf.common.config.query.Query.class, Boolean.class }); } catch(Exception e) {e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("getElements", method));

        try { method = DSComponent.class.getMethod("getElements", new Class[]{ com.sonicsw.mf.common.config.query.Query.class, Boolean.class, Boolean.class}); } catch(Exception e) {e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("getElements", method));

        try { method = DSComponent.class.getMethod("getIdentity", new Class[]{ String.class }); } catch(Exception e) {e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("getIdentity", method));

        try { method = DSComponent.class.getMethod("getAllElements", new Class[]{ String.class, Boolean.class }); } catch(Exception e) {e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("getAllElements", method));

        try { method = DSComponent.class.getMethod("getAllElementsCompressed", new Class[]{ String.class, Boolean.class }); } catch(Exception e) {e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("getAllElementsCompressed", method));

        try { method = DSComponent.class.getMethod("listAll", new Class[] { String.class }); } catch(Exception e) {e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("listAll", method));

        try { method = DSComponent.class.getMethod("listDirectories", new Class[] { String.class }); } catch(Exception e) {e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("listDirectories", method));

        try { method = DSComponent.class.getMethod("listElements", new Class[] { String.class }); } catch(Exception e) {e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("listElements", method));

        try { method = DSComponent.class.getMethod("detachBlob", new Class[]{IDeltaDirElement.class, IDeltaView.class }); }
            catch(Exception e) {e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("detachBlob", method));

        try { method = DSComponent.class.getMethod("deleteElement", new Class[]{ String.class, IDeltaView.class }); }
            catch(Exception e) {e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("deleteElement", method));

        try { method = DSComponent.class.getMethod("unSubclassElement", new Class[]{ String.class, IDeltaView.class }); }
            catch(Exception e) {e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("unSubclassElement", method));

        try { method = DSComponent.class.getMethod("createDirectory", new Class[] { String.class }); } catch(Exception e) {e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("createDirectory", method));

        try { method = DSComponent.class.getMethod("deleteDirectory", new Class[] { String.class }); } catch(Exception e) {e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("deleteDirectory", method));

        try { method = DSComponent.class.getMethod("deleteDirectory", new Class[] { String.class, IDeltaView.class}); }
            catch(Exception e) {e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("deleteDirectory", method));

        try { method = DSComponent.class.getMethod("attachBlob", new Class[] { IBasicElement.class, byte[].class, IDeltaView.class }); }
            catch(Exception e) {e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("attachBlob", method));

        try { method = DSComponent.class.getMethod("appendBlob", new Class[] { IBasicElement.class, byte[].class, Integer.class, Boolean.class, IDeltaView.class }); }
            catch(Exception e) {e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("appendBlob", method));

        try { method = DSComponent.class.getMethod("setElement", new Class[] { IBasicElement.class, IDeltaView.class }); }
            catch(Exception e) {e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("setElement", method));

        try { method = DSComponent.class.getMethod("upgrade5to6", new Class[] { String.class, String.class }); }
            catch(Exception e) {e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("upgrade5to6", method));

        try { method = DSComponent.class.getMethod("setElementReleaseVersion", new Class[] { String.class, String.class }); }
            catch(Exception e) {e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("setElementReleaseVersion", method));

        try { method = DSComponent.class.getMethod("setElements", new Class[] { IBasicElement[].class, java.lang.String[].class,
                                                                                IDeltaView.class }); }
            catch(Exception e) {e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("setElements", method));

        try { method = DSComponent.class.getMethod("cloneElement", new Class[] { String.class, String.class, IDeltaView.class }); }
            catch(Exception e) {e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("cloneElement", method));

        try { method = DSComponent.class.getMethod("cloneElement", new Class[] { IBasicElement.class, String.class, IDeltaView.class }); }
            catch(Exception e) {e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("cloneElement", method));

        try { method = DSComponent.class.getMethod("cloneElement",
                                                   new Class[] { String.class, String.class, Boolean.class, IDeltaView.class }); }
            catch(Exception e) {e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("cloneElement", method));

        try { method = DSComponent.class.getMethod("cloneElement",
                                                   new Class[] { IBasicElement.class, String.class, Boolean.class, IDeltaView.class }); }
            catch(Exception e) {e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("cloneElement", method));

        try { method = DSComponent.class.getMethod("subclassElement", new Class[] { IBasicElement.class, String.class, IDeltaView.class }); }
            catch(Exception e) {e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("subclassElement", method));

        try { method = DSComponent.class.getMethod("exportElementToXML", new Class[] { String.class }); }
            catch(Exception e) {e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("exportElementToXML", method));

        try { method = DSComponent.class.getMethod("exportDSBootFileString", new Class[] { String.class }); }
        catch(Exception e) {e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("exportDSBootFileString", method));

        mbParamInfos = new MBeanParameterInfo[]
        {
            new MBeanParameterInfo("dirName", String.class.getName(), "The Directory Service directory to export.")
        };
        OPERATION_INFOS.add(new MBeanOperationInfo("exportDirectoryToXML", "Exports (returns) the given Directory Service directory as an single XML document. Warning: The returned string may be very large.", mbParamInfos,
                                                   String.class.getName(), MBeanOperationInfo.ACTION));

        OPERATION_INFOS.add(new MBeanOperationInfo("dumpContentsToXML", "Dumps an entire directory into an XML document in the current working directory of the container hosting the DS. The dump file will be named \"dump.<domain name>.<n>.xml\" where <n> is a version number one greater than existing dump files (starting at 0).", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY,
                                                   Void.class.getName(), MBeanOperationInfo.ACTION));

        mbParamInfos = new MBeanParameterInfo[]
        {
            new MBeanParameterInfo("XMLDocument", String.class.getName(), "The XML formatted content to be imported.")
        };
        OPERATION_INFOS.add(new MBeanOperationInfo("importFromXML", "Import a directory or an element from an XML document.", mbParamInfos,
                                                   Void.class.getName(), MBeanOperationInfo.ACTION));

        // This method is used by PASS
        // This method return list of External Domain descriptor that have been configured with Management SPI.

        OPERATION_INFOS.add(new MBeanOperationInfo("listExternalDomainWithManagementSPI", "Return list of external domain descriptors that have been configured with Management SPI.",
                                                   IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, String[].class.getName(), MBeanOperationInfo.INFO));

        // This method is used by PASS.
        // This method reloads the External Domain that matches the descriptor passed in.

        mbParamInfos = new MBeanParameterInfo[]
        {
            new MBeanParameterInfo("mfDomainDescriptor", String.class.getName(), "The name of the external domain")
        };
        OPERATION_INFOS.add(new MBeanOperationInfo("reloadExternalAuthenticationDomain", "Reloads the external domain that matches the descriptor passed in.", mbParamInfos,
                                                   Boolean.class.getName(), MBeanOperationInfo.ACTION));

        // online backup supported by PSE_STORAGE

        mbParamInfos = new MBeanParameterInfo[]
        {
        	new MBeanParameterInfo("backupDir", String.class.getName(), "The directory to use for the backup"),
        	new MBeanParameterInfo("overwrite", Boolean.class.getName(), "Overwrite the existing DS if there is one in the backup directory")
        };

        OPERATION_INFOS.add(new MBeanOperationInfo("startBackup", "Start the backup process asynchronously", mbParamInfos,
        		Void.class.getName(), MBeanOperationInfo.ACTION));


        OPERATION_INFOS.add(new MBeanOperationInfo("getBackupStatus", "Return a BackupStatus object with information about the last backup",
        		IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, IBackupStatus.class.getName(), MBeanOperationInfo.INFO));


        mbParamInfos = new MBeanParameterInfo[]
        {
            new MBeanParameterInfo("lockName", String.class.getName(), "The name of the lock to be acquired."),
            new MBeanParameterInfo("key", String.class.getName(), "The key under which the lock (if acquired) should be held."),
            new MBeanParameterInfo("leaseDuration", Integer.class.getName(), "The duration the lock lease will remain in effect (cannot be (re)acquired using a different key). After the duration has expired the lock can be acquired under a different key.")
        };
        OPERATION_INFOS.add(new MBeanOperationInfo("leaseLock", "Leases the named lock against the given key for the given period. Returns true if the the lock was successfully acquired, false if not.",
                                                   mbParamInfos, Boolean.class.getName(), MBeanOperationInfo.ACTION));

        mbParamInfos = new MBeanParameterInfo[]
        {
            new MBeanParameterInfo("lockName", String.class.getName(), "The name of the acquired lock."),
            new MBeanParameterInfo("key", String.class.getName(), "The key under which the lock was acquired.")
        };
        OPERATION_INFOS.add(new MBeanOperationInfo("releaseLock", "Releases a previously acquired lock (if that lock is still held against the given key).",
                                                   mbParamInfos, Void.class.getName(), MBeanOperationInfo.ACTION));

        /***************************************************************************************************
         *****************************register IDirectoryFileservice operations*****************************
         ***************************************************************************************************/

        try { method = DSComponent.class.getMethod("attachFSBlob",
                                                   new Class[] { IBasicElement.class, byte[].class }); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", attachFSBlob2"; e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("attachFSBlob", method));

        try { method = DSComponent.class.getMethod("appendFSBlob", new Class[] { IBasicElement.class, byte[].class, Integer.class, Boolean.class}); }
            catch(Exception e) {e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("appendFSBlob", method));

        try { method = DSComponent.class.getMethod("cloneFSBlob",
                                                   new Class[] { String.class, String.class }); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", cloneFSBlob"; e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("cloneFSBlob", method));

        try { method = DSComponent.class.getMethod("cloneFSElement",
                                                   new Class[] { IBasicElement.class, String.class }); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", cloneFSElement1"; e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("cloneFSElement", method));

        try { method = DSComponent.class.getMethod("cloneFSElement",
                                                   new Class[] { IBasicElement.class, String.class, Boolean.class }); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", cloneFSElement2";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("cloneFSElement", method));

        try { method = DSComponent.class.getMethod("cloneFSElement",
                                                   new Class[] { String.class, String.class }); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", cloneFSElement3";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("cloneFSElement", method));

        try { method = DSComponent.class.getMethod("cloneFSElement",
                                                   new Class[] { String.class, String.class, Boolean.class}); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", cloneFSElement4";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("cloneFSElement", method));

        try { method = DSComponent.class.getMethod("createFolder",
                                                   new Class[] { String.class }); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", createFolder";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("createFolder", method));

        try { method = DSComponent.class.getMethod("createFolder",
                                                   new Class[] { String.class, Boolean.class }); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", createFolder";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("createFolder", method));

        try { method = DSComponent.class.getMethod("copyFiles",
                                                   new Class[] { String.class, String.class }); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", copyFiles";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("copyFiles", method));

        try { method = DSComponent.class.getMethod("createFSElement",
                                                   new Class[] { IDirElement.class }); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", createFSElement";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("createFSElement", method));

        try { method = DSComponent.class.getMethod("defineElementMetaAttributes",
                                                   new Class[] { String[].class }); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", defineElementMetaAttributes";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("defineElementMetaAttributes", method));

        try { method = DSComponent.class.getMethod("defineFolderMetaAttributes",
                                                   new Class[] { String[].class }); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", defineFolderMetaAttributes";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("defineFolderMetaAttributes", method));

        try { method = DSComponent.class.getMethod("deleteFolder",
                                                   new Class[] { String.class }); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", deleteFolder";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("deleteFolder", method));

        try { method = DSComponent.class.getMethod("deleteFSElement",
                                                   new Class[] { String.class }); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", deleteFSElement";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("deleteFSElement", method));

        try { method = DSComponent.class.getMethod("detachFSBlob",
                                                   new Class[] { IDeltaDirElement.class }); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", detachFSBlob";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("detachFSBlob", method));

        try { method = DSComponent.class.getMethod("executeTransaction",
                                                   new Class[] { IDSTransaction.class}); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", executeTransaction";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("executeTransaction", method));

        try { method = DSComponent.class.getMethod("getBackReferenceTypes",
                                                   IEmptyArray.EMPTY_CLASS_ARRAY ); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", getBackReferenceTypes";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("getBackReferenceTypes", method));

        try { method = DSComponent.class.getMethod("getCreateContainerConfiguration",
                                                   new Class[] { String.class, String.class, String.class, Hashtable.class, Hashtable.class}); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", getCreateContainerConfiguration";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("getCreateContainerConfiguration", method));

        try { method = DSComponent.class.getMethod("getReferences",
                                                   new Class[] {String.class} ); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", getReferences";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("getReferences", method));

        try { method = DSComponent.class.getMethod("getDefinedElementMetaAttributes",
                                                   IEmptyArray.EMPTY_CLASS_ARRAY ); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", getDefinedElementMetaAttributes";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("getDefinedElementMetaAttributes", method));

        try { method = DSComponent.class.getMethod("getDefinedFolderMetaAttributes",
                                                   IEmptyArray.EMPTY_CLASS_ARRAY ); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", getDefinedFolderMetaAttributes";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("getDefinedFolderMetaAttributes", method));

        try { method = DSComponent.class.getMethod("getElementsByLogicalNames",
                                                   new Class[] {String[].class}); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", getElementsByLogicalNames ";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("getElementsByLogicalNames", method));

        try { method = DSComponent.class.getMethod("getFSBlob",
                                                   new Class[] { String.class, Boolean.class }); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", getFSBlob";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("getFSBlob", method));

        try { method = DSComponent.class.getMethod("getFSBlob",
                                                   new Class[] { String.class, Boolean.class, Integer.class }); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", getFSBlob";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("getFSBlob", method));

        try { method = DSComponent.class.getMethod("getFiles",
                                                   new Class[] { String[].class}); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", getFiles";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("getFiles", method));

        try { method = DSComponent.class.getMethod("getFiles",
                                                   new Class[] { String.class, Boolean.class, String.class}); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", getFiles";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("getFiles", method));

        try { method = DSComponent.class.getMethod("getFSElement",
                                                   new Class[] { String.class, Boolean.class }); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", getFSElement1";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("getFSElement", method));

        try { method = DSComponent.class.getMethod("getFSElement",
                                                   new Class[] { String.class, Boolean.class, Boolean.class }); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", getFSElement2";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("getFSElement", method));

        try { method = DSComponent.class.getMethod("getFSElement",
                                                   new Class[] { String.class, Boolean.class, Boolean.class }); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", getFSElement3";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("getFSElement", method));

        try { method = DSComponent.class.getMethod("getFSElements",
                                                   new Class[] { com.sonicsw.mf.common.config.query.Query.class, Boolean.class}); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", getFSElements1";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("getFSElements", method));

        try { method = DSComponent.class.getMethod("getFSElements",
                                                   new Class[] { com.sonicsw.mf.common.config.query.Query.class, Boolean.class, Boolean.class }); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", getFSElements2";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("getFSElements", method));

        try { method = DSComponent.class.getMethod("getFSElements",
                new Class[] { com.sonicsw.mf.common.config.query.Query.class, Boolean.class, Boolean.class,
        		com.sonicsw.mf.common.config.query.QueryBatch.class}); }
             catch(Exception e) {methodsWithErrors = methodsWithErrors + ", getFSElements3";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("getFSElements", method));

        try { method = DSComponent.class.getMethod("getFSElements",
                                                   new Class[] { String.class, Boolean.class }); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", getFSElements4";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("getFSElements", method));

        try { method = DSComponent.class.getMethod("getFSIdentity",
                                                   new Class[] { String.class }); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", getFSIdentity";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("getFSIdentity", method));

        try { method = DSComponent.class.getMethod("getMetaAttributes",
                                                   new Class[] { String.class }); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", getMetaAttributes";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("getMetaAttributes", method));

        try { method = DSComponent.class.getMethod("listFolders",
                                                   new Class[] { String.class }); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", listFolders";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("listFolders", method));

        try { method = DSComponent.class.getMethod("listAllFolders",  IEmptyArray.EMPTY_CLASS_ARRAY ); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", listAllFolders";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("listAllFolders", method));

        try { method = DSComponent.class.getMethod("listFSAll",
                                                   new Class[] { String.class }); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", listFSAll";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("listFSAll", method));

        try { method = DSComponent.class.getMethod("listFSAll",
                                                   new Class[] { String.class, Boolean.class, String.class }); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", listFSAll";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("listFSAll", method));

        try { method = DSComponent.class.getMethod("recursiveList",
                                                   new Class[] { String.class, Boolean.class, Boolean.class, String.class }); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", recursiveList";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("recursiveList", method));

        try { method = DSComponent.class.getMethod("listFSElements",
                                                   new Class[] { String.class }); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", listFSElements";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("listFSElements", method));

        try { method = DSComponent.class.getMethod("rebuildBackReferences",
                                                   IEmptyArray.EMPTY_CLASS_ARRAY); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", rebuildBackReferences";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("rebuildBackReferences", method));

        try { method = DSComponent.class.getMethod("repairReferences",
                                                   new Class[] { String[].class }); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", repairReferences";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("repairReferences", method));

        try { method = DSComponent.class.getMethod("rename",
                                                   new Class[] { String.class, String.class }); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", rename";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("rename", method));

        try { method = DSComponent.class.getMethod("renameFolder",
                                                   new Class[] { String.class, String.class }); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", renameFolder";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("renameFolder", method));

        try { method = DSComponent.class.getMethod("renameFile",
                                                   new Class[] { String.class, String.class }); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", renameFile";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("renameFile", method));

        try { method = DSComponent.class.getMethod("resetBackReferences",
                                                   IEmptyArray.EMPTY_CLASS_ARRAY); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", resetBackReferences";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("resetBackReferences", method));

        try { method = DSComponent.class.getMethod("revertToTemplate",
                                                   new Class[] { String.class, AttributeName[].class}); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", revertToTemplate";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("revertToTemplate", method));

        try { method = DSComponent.class.getMethod("setBackReferenceTypes",
                                                   new Class[] { String[].class}); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", setBackReferenceTypes";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("setBackReferenceTypes", method));

        try { method = DSComponent.class.getMethod("setComplexStorageHint",
                                                   new Class[] { String.class, String.class }); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", setComplexStorageHint";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("setComplexStorageHint", method));

        try { method = DSComponent.class.getMethod("setMetaAttributes",
                                                   new Class[] { String.class, HashMap.class}); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", setMetaAttributes";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("setMetaAttributes", method));

        try { method = DSComponent.class.getMethod("getStorageToLogicalMap", IEmptyArray.EMPTY_CLASS_ARRAY); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", setMetaAttributes";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("getStorageToLogicalMap", method));

        try { method = DSComponent.class.getMethod("setStorageHint",
                                                   new Class[] { String.class, String.class }); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", setStorageHint1";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("setStorageHint", method));

        try { method = DSComponent.class.getMethod("setStorageHint",
                                                   new Class[] { String.class, String.class, String.class }); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", setStorageHint2";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("setStorageHint", method));

        try { method = DSComponent.class.getMethod("subclassFSElement",
                                                   new Class[] { IBasicElement.class, String.class }); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", subclassFSElement";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("subclassFSElement", method));

        try { method = DSComponent.class.getMethod("unSubclassFSElement",
                                                   new Class[] { String.class }); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", unSubclassFSElement";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("unSubclassFSElement", method));

        try { method = DSComponent.class.getMethod("updateFSElement",
                                                   new Class[] { IDeltaDirElement.class}); }
            catch(Exception e) {methodsWithErrors = methodsWithErrors + ", updateFSElement";e.printStackTrace();}
        OPERATION_INFOS.add(new MBeanOperationInfo("updateFSElement", method));

        //permissions API

        mbParamInfos = new MBeanParameterInfo[]
	    {
	      	new MBeanParameterInfo("paths", String[][].class.getName(), "Logical paths of folders, components and elements to set permissions on"),
	      	new MBeanParameterInfo("type", String.class.getName(), "Type of permissions, manage or configure"),
	      	new MBeanParameterInfo("permissions", IManagementPermission[][].class.getName(), "Permissions to set on the paths")
	    };

        OPERATION_INFOS.add(new MBeanOperationInfo("setManagementPermissions", "Set manage or configure permissions to the paths indicated", mbParamInfos,
            Void.class.getName(), MBeanOperationInfo.ACTION));
        mbParamInfos = new MBeanParameterInfo[]
  	    {
  	      	new MBeanParameterInfo("paths", String[][].class.getName(), "Logical paths of folders, components and elements to get permissions for"),
  	      	new MBeanParameterInfo("type", String.class.getName(), "Type of permissions, manage or configure"),
  	    };
        OPERATION_INFOS.add(new MBeanOperationInfo("getManagementPermissions", "Return the manage or configure permissions for the paths indicated", mbParamInfos,
    		IManagementPermission[][].class.getName(), MBeanOperationInfo.INFO));

        mbParamInfos = new MBeanParameterInfo[]
  	    {
  	      	new MBeanParameterInfo("paths", String[][].class.getName(), "Logical paths of folders, components and elements to remove permissions from"),
  	      	new MBeanParameterInfo("type", String.class.getName(), "Type of permissions, manage or configure"),
  	      	new MBeanParameterInfo("principals", String[][].class.getName(), "Principals with permissions to be removed")
  	    };
        OPERATION_INFOS.add(new MBeanOperationInfo("removeManagementPermissions", "Remove manage or configure permissions from the paths indicated", mbParamInfos,
    		Void.class.getName(), MBeanOperationInfo.ACTION));

        mbParamInfos = new MBeanParameterInfo[]
        {
            new MBeanParameterInfo("paths", String[][].class.getName(), "Logical paths of folders, components and elements to remove permissions from"),
            new MBeanParameterInfo("type", String.class.getName(), "Type of permissions, manage or configure")
        };
        OPERATION_INFOS.add(new MBeanOperationInfo("removeManagementPermissions", "Remove manage or configure permissions from the paths indicated", mbParamInfos,
                                                   Void.class.getName(), MBeanOperationInfo.ACTION));

        OPERATION_INFOS.add(new MBeanOperationInfo("removeAllManagementPermissions", "Remove all management permissions", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY,
        		Void.class.getName(), MBeanOperationInfo.ACTION));

        OPERATION_INFOS.add(new MBeanOperationInfo("setDefaultManagementPermissions", "Set default permissions for the Administrators group", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY,
        		Void.class.getName(), MBeanOperationInfo.ACTION));

        mbParamInfos = new MBeanParameterInfo[]
        {
            new MBeanParameterInfo("forUpdate", Boolean.class.getName(), "Whether the returned element should allow updates to it")
        };
        OPERATION_INFOS.add(new MBeanOperationInfo("getDomainElement", "Return the element containing the domain-wide management security and auditing settings", mbParamInfos,
                                                   IDirElement.class.getName(), MBeanOperationInfo.INFO));

        mbParamInfos = new MBeanParameterInfo[]
        {
            new MBeanParameterInfo("element", IDeltaDirElement.class.getName(), "The element modifications")
        };
        OPERATION_INFOS.add(new MBeanOperationInfo("setDomainElement", "Sets the domain-wide security and audit settings", mbParamInfos,
                                                   IDeltaDirElement.class.getName(), MBeanOperationInfo.INFO));

        mbParamInfos = new MBeanParameterInfo[]
        {
            new MBeanParameterInfo("containerID", String.class.getName(), "Name of the container to which we halt notifications"),
            new MBeanParameterInfo("allowTypes", String[].class.getName(), "The container will continue to receive notifications for changes of this type")
        };
        OPERATION_INFOS.add(new MBeanOperationInfo("suspendChangeNotifications", "Stops sending change notifications to a container, optionally lets notifications through for element types in allowTypes", mbParamInfos,
                                                                                         Void.class.getName(), MBeanOperationInfo.INFO));

        mbParamInfos = new MBeanParameterInfo[]
        {
           new MBeanParameterInfo("containerID", String.class.getName(), "Name of the container to which the DS will resume notifications"),
        };
        OPERATION_INFOS.add(new MBeanOperationInfo("resumeChangeNotifications", "Resumes sending change notifications to a container, used in testing", mbParamInfos,
                                                                                     Void.class.getName(), MBeanOperationInfo.INFO));

        OPERATION_INFOS.add(new MBeanOperationInfo("resumeAllChangeNotifications", "Resumes sending change notifications to all containers, used in testing", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY,
                Void.class.getName(), MBeanOperationInfo.ACTION));

        mbParamInfos = new MBeanParameterInfo[]
        {
            new MBeanParameterInfo("subscriber", String.class.getName(), "Runtime ID of the container registering notifications"),
            new MBeanParameterInfo("logicalName", String.class.getName(), "Logical name of the configuration which the container is interested in")
        };
        OPERATION_INFOS.add(new MBeanOperationInfo("registerInterestInChanges", "Register the interest of the container in changes to the configuration named by the logical name", mbParamInfos,
        		Void.class.getName(), MBeanOperationInfo.ACTION));
        
        //
        // In support of location transparency
        //
        mbParamInfos = new MBeanParameterInfo[]
        {
            new MBeanParameterInfo("url", String.class.getName(), "\"sonicrn:///\" URL to be resolved"),
        };
        OPERATION_INFOS.add(new MBeanOperationInfo("resolveURL", "Resolve the given \"sonicrn:///\" URL to its full substituted form. For internal (Sonic) use.", mbParamInfos,
                String.class.getName(), MBeanOperationInfo.INFO));

        //
        // Notifications
        //
        String[] notifTypes = null;

        // configuration change
        notifTypes = new String[]
        {
            INotification.CATEGORY_TEXT[INotification.CONFIGURATION_CATEGORY],
            INotification.SUBCATEGORY_TEXT[INotification.STORAGE_SUBCATEGORY],
            CHANGE_NOTIFICATION_TYPE
        };
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, INotification.CLASSNAME, "Configuration change(s) propagated by the Directory Services."));

        // configuration change
        notifTypes = new String[]
        {
            INotification.CATEGORY_TEXT[INotification.SYSTEM_CATEGORY],
            INotification.SUBCATEGORY_TEXT[INotification.STATE_SUBCATEGORY],
            FAILOVER_NOTIFICATION_TYPE
        };
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, INotification.CLASSNAME, "Standby service has failed over to become the active service."));

        // permission denied notification
        notifTypes = new String[]
        {
            INotification.CATEGORY_TEXT[INotification.SYSTEM_CATEGORY],
            INotification.SUBCATEGORY_TEXT[INotification.SECURITY_SUBCATEGORY],
            CONFIGURE_PERMISSION_DENIED_NOTIFICATION_TYPE
        };
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, INotification.CLASSNAME, "User has been denied permission to perform a configuration task."));

        m_dsStartupElement =  ElementFactory.createElement(DS_STARTUP_ELEMENT, "startup", "2.0");

        if (methodsWithErrors.length() > 0)
        {
            System.out.println("Methods with errors == " + methodsWithErrors);
        }
    }

    public void setContainer(ContainerImpl container)
    {
        m_containerImpl = container;
    }

    public DSComponent()
    {
        super();
        clearDSState();
        clearDSAccessParameters();
        m_SdfMFTracingIntegration = new SdfMFTracingIntegration();
        m_SdfMFTracingIntegration.register();

        if (!m_startActive)
        {
            m_startActive = testStartActive(true);
        }
    }

    private void clearDSAccessParameters()
    {
        m_id = null;
        m_hostDir = null;
        m_domainName = null;
        m_encryptionPassword = null;
        m_hostDirDepricated = null;
        m_dsStorage = null;
        m_replicationStateHandler = null;
    }

    private void clearDSState()
    {
        m_uniquenessCheckThread = null;
        m_uniqunessCallID = null;
        m_consumer = null;
        m_ds = null;
        m_uniquenessCallReceived = false;
        m_responseSent = false;
        m_dsStarted = false;
        m_registry = null;
    }

    @Override
    public String getTraceMaskValues()
    {
        return (super.getTraceMaskValues() + "," + DS_TRACE_MASK_VALUES);
    }

    public void setTraceMask(IAttributeSet dsAtts)
    {
        Integer traceMaskObject = (Integer)dsAtts.getAttribute(IContainerConstants.TRACE_MASK_ATTR);

        if (traceMaskObject == null)
        {
            traceMaskObject = new Integer(0);
        }

        setTraceMask(traceMaskObject);
    }

    @Override
    public void setTraceMask(Integer traceMask)
    {
        setTraceMask(traceMask, false);
    }

    private void setTraceMask(Integer traceMask, boolean fromSDF)
    {
        // If SDF is used then ignore trace setup from other sources
        // If SDF is not used - update it from other sources
        if (!fromSDF)
        {
            if (m_SdfMFTracingIntegration.wasUpdated())
            {
                return;
            }
            else
            {
                m_SdfMFTracingIntegration.setTraceMask(traceMask);
            }
        }

        super.setTraceMask(traceMask);

        if (m_ds != null)
        {
            m_ds.setTraceMask(traceMask.intValue());
        }
        setReplicationTracing(traceMask.intValue());
    }

    IStateManager getFaultToleranceStateManager() { return m_faultToleranceStateManager; }

    IFrameworkComponentContext getContext() { return super.m_frameworkContext; }

    void sendFTStateChange(boolean failover)
    {
        if (m_context == null)
        {
            return;
        }

        INotification notification =
            m_context.createNotification(INotification.SYSTEM_CATEGORY, INotification.SUBCATEGORY_TEXT[INotification.STATE_SUBCATEGORY],
                                         failover ? FAILOVER_NOTIFICATION_TYPE : REVERT_TO_STANDBY_NOTIFICATION_TYPE , Level.WARNING);
        notification.setLogType(INotification.WARNING_TYPE);
        notification.setAttribute("FaultToleranceRole", m_faultToleranceRole);
        super.m_context.sendNotification(notification);
    }


    //
    // Attribute methods
    //

    public String getFaultToleranceRole()
    {
        return this.m_faultToleranceRole;
    }

    @Override
    public Short getFaultTolerantState()
    {
        return new Short(m_faultToleranceStateManager.getState(null));
    }

    public String getFaultTolerantStateString()
    {
        String storageState = null;
        if (m_replicationStateHandler != null)
        {
            storageState = m_replicationStateHandler.getStandbyStorageState();
        }
        storageState = (storageState != null) ? ("; " + storageState) : "";
        return IFaultTolerantState.STATE_TEXT[m_faultToleranceStateManager.getState(null)] + storageState;
    }

    public Boolean getAllowFailover()
    {
        return m_isNotFaultTolerant ? null : new Boolean(m_allowFailover);
    }

    public void setAllowFailover(Boolean allowFailover)
    {
        if (m_isNotFaultTolerant)
        {
            throw new IllegalStateException("Setting of this attribute is not supported for a non-fault tolerant Directory Service");
        }

        boolean allow = allowFailover.booleanValue();
        if (allow != m_allowFailover)
        {
            if (m_faultToleranceStateManager.getState(null) != IFaultTolerantState.STATE_ACTIVE)
            {
                super.m_context.logMessage("Failover " + (allow ? "reenabled" : "disabled"), allow ? Level.INFO : Level.WARNING);
            }
            m_allowFailover = allow;
        }
    }

    //
    // IGlobalFrameworkComponent specific implementation
    //

    @Override
    public String getGlobalID() { return GLOBAL_ID; }

    //
    // IComponent overloads
    //

    @Override
    public MBeanAttributeInfo[] getAttributeInfos() { return (MBeanAttributeInfo[])ATTRIBUTE_INFOS.toArray(IEmptyArray.EMPTY_ATTRIBUTE_INFO_ARRAY); }

    @Override
    public MBeanOperationInfo[] getOperationInfos() { return (MBeanOperationInfo[])OPERATION_INFOS.toArray(IEmptyArray.EMPTY_OPERATION_INFO_ARRAY); }

    @Override
    public MBeanNotificationInfo[] getNotificationInfos() { return (MBeanNotificationInfo[])NOTIFICATION_INFOS.toArray(IEmptyArray.EMPTY_NOTIFICATION_INFO_ARRAY); }

    @Override
    public void init(IComponentContext context)
    {
        super.init(context);
        
        // PSE does not have access to the component context so use java.util.logging
        // to support container logging by PSE code
        m_pseLogger = new MFLogger(context, "pse");

        readConfiguration(context);
        m_FTpartnerAddress = getPartnerAddress();

        try
        {
            if (m_isNotFaultTolerant)
            {
                super.m_container.addGlobalComponentSupport(GLOBAL_ID, null, this);
                super.m_container.addGlobalComponentSupport(GLOBAL_ID, FAULT_TOLERANCE_ROLE_PRIMARY, this);
            }
            else
            {
                StringBuffer sb = new StringBuffer();
                sb.append(IContainer.NEWLINE);
                sb.append(IContainer.NEWLINE);
                sb.append('\t');
                sb.append("Fault tolerant role \"").append(this.m_faultToleranceRole).append("\".");
                if (m_isBackup)
                {
                    sb.append(IContainer.NEWLINE);
                    sb.append('\t');
                    sb.append("Start active is ").append(m_startActive ? "enabled." : "disabled.");
                }
                sb.append(IContainer.NEWLINE);
                super.m_context.logMessage(sb.toString(), Level.CONFIG);

                super.m_container.addGlobalComponentSupport(GLOBAL_ID, m_faultToleranceRole, this);
            }
        }
        catch (Exception e)
        {
            Exception linkedException = null;
            if (e instanceof JMSException)
            {
                linkedException = ((JMSException)e).getLinkedException();
            }

            String msgPrefix = m_isNotFaultTolerant ? "" : '[' + m_faultToleranceRole + "] ";
            if (linkedException != null && linkedException instanceof EUserAlreadyConnected)
            {
                m_context.logMessage(msgPrefix + "Failed communications initialization (probably already running)", Level.SEVERE);
                super.m_container.shutdown(IContainerExitCodes.DS_ALREADY_RUNNING_EXIT_CODE);
            }
            else
            {
                m_context.logMessage(msgPrefix + "Failed communications initialization, trace follows...", e, Level.SEVERE);
                super.m_container.shutdown(IContainerExitCodes.COMMS_FAILURE_EXIT_CODE);
            }
        }

        if (m_isNotFaultTolerant)
        {
            super.m_container.setLocalDS(this);
            m_faultToleranceStateManager = new StateManager(IFaultTolerantState.STATE_VALUES, IFaultTolerantState.STATE_NOT_FAULT_TOLERANT);
        }
        else
        {
            // configure the state manager
            super.m_context.logMessage("Initial state: \"" + IFaultTolerantState.STATE_TEXT[IFaultTolerantState.STATE_WAITING] + '"', Level.INFO);
            m_faultToleranceStateManager = new StateManager(IFaultTolerantState.STATE_VALUES, IFaultTolerantState.STATE_WAITING);
            IStateController controller = null;

            controller = new ToStandbyStateController();
            m_faultToleranceStateManager.registerStateController(controller, IFaultTolerantState.STATE_WAITING, IFaultTolerantState.STATE_STANDBY, null);
            m_faultToleranceStateManager.registerStateController(controller, IFaultTolerantState.STATE_ACTIVE, IFaultTolerantState.STATE_STANDBY, null);

            controller = new ToActiveStateController();
            m_faultToleranceStateManager.registerStateController(controller, IFaultTolerantState.STATE_WAITING, IFaultTolerantState.STATE_ACTIVE, null);
            m_faultToleranceStateManager.registerStateController(controller, IFaultTolerantState.STATE_STANDBY, IFaultTolerantState.STATE_ACTIVE, null);

            m_faultToleranceStateManager.registerStateListener(new StateListener(),null);
        }

        m_lockManager = new DistributedLockManager(this, super.m_frameworkContext);

        // get this kicked off after asap, but hopefully ahead of announcing that the DS is available
        makeGlobalComponentUniquenessCall();
    }

    private String getPartnerAddress()
    {
        StringBuffer partner = new StringBuffer();
        partner.append(getContext().getComponentName().getDomainName());
        partner.append('.');
        partner.append(JMSConnectorServer.getPseudoContainerID(DSComponent.GLOBAL_ID, m_partnerRole));
        partner.append(':').append(IComponentIdentity.ID_PREFIX);
        partner.append(DSComponent.GLOBAL_ID);
        return partner.toString();

    }

    @Override
    public synchronized void start()
    {
        if (super.m_state == IComponentState.STATE_ONLINE)
        {
            return;
        }

        if (m_isNotFaultTolerant)
        {
            if (startDirectoryService(super.m_context) == STARTUP_STATE_FAILED)
            {
                shutdown(null, new Integer(IContainerExitCodes.DS_FAILURE_EXIT_CODE));
            }
            announceDirectoryServiceIsAvailable(m_startState == DSComponent.STARTUP_STATE_RESTARTED, false);

            super.start();

            makeConfigChangeSubscriptions();
        }
        else
        {
            try
            {
                openStorageForReplication();
            }
            catch (Throwable t)
            {
                m_startState = STARTUP_STATE_FAILED;
                shutdown(t.getMessage(), new Integer(IContainerExitCodes.DS_FAILURE_EXIT_CODE));
            }

            super.start();

            synchronized(m_faultToleranceStateManager)
            {
                while (m_faultToleranceStateManager.getState(null) == IFaultTolerantState.STATE_WAITING)
                {
                    try { m_faultToleranceStateManager.wait(1000); } catch(InterruptedException e) { }
                    if (super.m_container.isClosing())
                    {
                        return;
                    }
                    if (m_startState == STARTUP_STATE_FAILED)
                    {
                        shutdown(null, new Integer(IContainerExitCodes.DS_FAILURE_EXIT_CODE));
                    }
                }
            }

        }
    }

    @Override
    public synchronized void stop()
    {
        if (super.m_state == IComponentState.STATE_OFFLINE)
        {
            return;
        }

        if (m_isNotFaultTolerant)
        {
            stopDirectoryService(false);
        }
        else
        {
            if (m_replicationStateHandler != null)
            {
                m_replicationStateHandler.close();
            }
            if (m_faultToleranceStateManager.getState(null) == IFaultTolerantState.STATE_ACTIVE)
            {
                DSComponent.super.m_container.removeGlobalComponentSupport(GLOBAL_ID, null);
                stopDirectoryService(false);
                if (m_dsStorage != null)
                {
                    m_dsStorage.close();
                }
                m_dsStorage = null;
            }
        }

        super.stop();
    }

    @Override
    public void destroy()
    {
        super.m_container.removeGlobalComponentSupport(GLOBAL_ID, null);

        if (m_isNotFaultTolerant)
        {
            super.m_container.removeGlobalComponentSupport(GLOBAL_ID, FAULT_TOLERANCE_ROLE_PRIMARY);
        }
        else
        {
            super.m_container.removeGlobalComponentSupport(GLOBAL_ID, m_faultToleranceRole);
            if (m_replicationStateHandler != null)
            {
                m_replicationStateHandler.close();
            }
        }

        stopDirectoryService(false);
        if (m_dsStorage != null)
        {
            m_dsStorage.close();
        }
        m_dsStorage = null;
        m_lockManager.cleanup();

        super.destroy();
    }

    public class ToActiveStateController implements IStateController
    {
        @Override
        public boolean changeState() throws NonRecoverableStateChangeException, RecoverableStateChangeException
        {
            if (startDirectoryService(DSComponent.super.m_context) == STARTUP_STATE_FAILED)
            {
                throw new NonRecoverableStateChangeException("Directory Service startup failure");
            }

            try
            {
                DSComponent.super.m_container.addGlobalComponentSupport(GLOBAL_ID, null, DSComponent.this);
            }
            catch (Exception e)
            {
                DSComponent.super.m_container.removeGlobalComponentSupport(GLOBAL_ID, null);

                m_context.logMessage("Failed communications initialization, trace follows...", e, Level.SEVERE);
                DSComponent.super.m_container.shutdown(IContainerExitCodes.COMMS_FAILURE_EXIT_CODE);
            }

            DSComponent.super.m_container.setLocalDS(DSComponent.this);

            announceDirectoryServiceIsAvailable(m_startState == STARTUP_STATE_RESTARTED, true);

            return true;
        }
    }

    public class ToStandbyStateController implements IStateController
    {
        @Override
        public boolean changeState() throws NonRecoverableStateChangeException
        {
            DSComponent.super.m_container.removeGlobalComponentSupport(GLOBAL_ID, null);
            DSComponent.super.m_container.setLocalDS(null);
            stopDirectoryService(true);
            return true;
        }
    }

    public class StateListener
    implements IStateListener
    {
        @Override
        public void stateChanging(short currentState, short intendedState) { }

        @Override
        public void stateChanged(short previousState, short currentState)
        {
            switch (previousState)
            {
                case IFaultTolerantState.STATE_WAITING:
                {
                    switch (currentState)
                    {
                        case IFaultTolerantState.STATE_ACTIVE:
                        case IFaultTolerantState.STATE_STANDBY:
                        {
                            DSComponent.super.m_context.logMessage("Transition to state: \"" + IFaultTolerantState.STATE_TEXT[currentState] + '"', Level.INFO);
                            break;
                        }
                    }
                    break;
                }
                case IFaultTolerantState.STATE_STANDBY:
                {
                    if (currentState == IFaultTolerantState.STATE_ACTIVE)
                    {
                        String stateString = IFaultTolerantState.STATE_TEXT[currentState];
                        if (m_backupFailoverReadOnly && m_isBackup)
                        {
                            stateString += " (Read Only)";
                        }
                        DSComponent.super.m_context.logMessage("Failover to state: \"" + stateString + '"', Level.WARNING);
                        DSComponent.this.sendFTStateChange(true);
                    }
                    break;
                }
                case IFaultTolerantState.STATE_ACTIVE:
                {
                    if (currentState == IFaultTolerantState.STATE_STANDBY)
                    {
                        DSComponent.super.m_context.logMessage("Reverting to state: \"" + IFaultTolerantState.STATE_TEXT[currentState] + '"', Level.WARNING);
                        DSComponent.this.sendFTStateChange(false);
                    }
                    break;
                }
            }

            if (currentState == IFaultTolerantState.STATE_ACTIVE)
            {
                makeConfigChangeSubscriptions();
            }
        }

        @Override
        public void stateChangeFailed(short currentState, short intendedState) { }
    }

    private short startDirectoryService(IComponentContext contex)
    {
        m_startState = STARTUP_STATE_STARTING;
        boolean restarted = m_dsStartedAtLeasetOnce;

        try
        {
            // Creates the directory service object
            Hashtable directoryEnv = new Hashtable();
            directoryEnv.put(IDirectoryService.STORAGE_TYPE_ATTRIBUTE, IDirectoryService.PSE_STORAGE);
            if (m_hostDirDepricated != null)
            {
                directoryEnv.put(IFSStorage.FS_HOST_DIRECTORY_ATTRIBUTE, m_hostDirDepricated);
            }
            if (m_hostDir != null)
            {
                directoryEnv.put(IFSStorage.HOST_DIRECTORY_ATTRIBUTE, m_hostDir);
            }
            if ((m_encryptionPassword != null) && (m_encryptionPassword.length() != 0))
            {
                directoryEnv.put(IFSStorage.PASSWORD_ATTRIBUTE, m_encryptionPassword);
            }
            if (m_isBackup && m_backupFailoverReadOnly)
            {
                directoryEnv.put(IDirectoryMFService.IS_RESTRICTED_BACKUP, Boolean.TRUE);
            }

            DirectoryServiceFactory factory = new DirectoryServiceFactory(directoryEnv);
            IFrameworkComponentContext context = (IFrameworkComponentContext)super.m_context;
            m_ds = factory.createDirectoryServiceInContainer(m_domainName, context, this, context);

            m_registry = new SubscriptionRegistry(SUBSCRIPTION_DURATION, (IPersistSubscribers)m_ds);
            m_consumer = m_ds.subscribeAll(new DSListener());
            m_ds.subscribeNaming(new DSNamingListener());
            
            readHierarchicalTypes();
        }
        catch (Exception e)
        {
            m_context.logMessage("Directory Service failure, trace follows...", e, Level.SEVERE);
            m_startState = STARTUP_STATE_FAILED;
            return m_startState;
        }

        // needs to be reset, in case it was set prior to initializations
        setTraceMask(super.getTraceMask());

        m_dsStarted = true;
        m_dsStartedAtLeasetOnce = true;

        m_startState = restarted ? STARTUP_STATE_RESTARTED : STARTUP_STATE_STARTED;

        return m_startState;
    }


    private void readHierarchicalTypes() throws DirectoryServiceException
    {
        HashMap hierarchicalTypes = new HashMap();
        //get the hierarchical types, with interest in modifications to the
        // directory

        IDirIdentity[] dirs = m_ds.listDirectories(HIERARCHICAL_TYPES_PATH);
        for (int i=0; i<dirs.length; i++)
        {
            IElement[] types = m_ds.getAllElements(dirs[i].getName(), false);
            for (int j=0; j<types.length; j++)
            {
                IElement type = types[j];
                String elName = type.getIdentity().getName();
                hierarchicalTypes.put(elName, elName);
            }
        }
        m_ds.setHierarchicalTypes(hierarchicalTypes);
    }
    //stopDirectoryService is closed in 'force' mode when the undelying DS is no longer available for updates - it turned STANDBY in FT mode
    private void stopDirectoryService(boolean force)
    {
        if (!m_dsStarted)
        {
            return;
        }

        if (m_uniquenessCheckThread != null)
        {
            m_uniquenessCheckThread.interrupt();
        }

        m_dsStarted = false;
        m_consumer.close();
        try
        {
            m_registry.close();
            if (force)
            {
                m_ds.close(false);
            }
            else
            {
                m_ds.close();
            }
        }
        catch (Exception e)
        {
            throw createMFRuntimeException(e);
        }
        clearDSState();
    }


    private void readConfiguration(IComponentContext context)
    {
        // Get the configuration from the configuration element
        IElement dsElement = context.getConfiguration(true);
        m_id = dsElement.getIdentity().getName();
        IAttributeSet dsAttributes = dsElement.getAttributes();

        // HOST_DIRECTORY is not shared between primary and backup
        m_hostDir = (String)dsAttributes.getAttribute(IDirectoryServiceConstants.HOST_DIRECTORY_ATTR);
        // if this is a backup DS, other attributes come from the primary
        if (dsElement.getIdentity().getType().equals(IBackupDirectoryServiceConstants.DS_TYPE))
        {
        	m_faultToleranceRole = FAULT_TOLERANCE_ROLE_BACKUP;
        	IAttributeSet references = (IAttributeSet)dsAttributes.getAttribute(IDirectoryServiceConstants.CONFIG_ELEMENT_REFERENCES_ATTR);
        	if (references == null)
            {
                throw new MFRuntimeException("Backup DS configuration " + m_id + " does not reference a primary configuration");
            }
            else
        	{
        		Reference primaryRef = (Reference)references.getAttribute(IBackupDirectoryServiceConstants.PRIMARY_CONFIG_ELEMENT_REF_ATTR);
        		if (primaryRef == null)
                {
                    throw new MFRuntimeException("Backup DS configuration " + m_id + " does not reference a primary configuration");
                }
                else
        		{
        			IElement primaryEl = context.getConfiguration(primaryRef.getElementName(), true);
        			dsAttributes = primaryEl.getAttributes();
        		}
        	}
        }

        m_domainName = (String)dsAttributes.getAttribute(IDirectoryServiceConstants.DOMAIN_NAME_ATTR);
        if (m_domainName == null)
        {
            m_domainName = IDirectoryServiceConstants.DOMAIN_NAME_DEFAULT;
        }

        IAttributeSet fsStorage = (IAttributeSet)dsAttributes.getAttribute(IDirectoryServiceConstants.FILE_SYSTEM_STORAGE_ATTR);
        if (fsStorage != null)
        {
            m_hostDirDepricated = (String)fsStorage.getAttribute(IDirectoryServiceConstants.HOST_DIRECTORY_ATTR);

            m_encryptionPassword = (String)fsStorage.getAttribute(IDirectoryServiceConstants.PASSWORD_ATTR);
        }
        if (m_hostDir == null && m_hostDirDepricated == null)
        {
            m_hostDir = IDirectoryServiceConstants.HOST_DIRECTORY_DEFAULT;
        }

        readReplicationParameters(dsAttributes, context);

        m_isNotFaultTolerant = m_faultToleranceRole.equals(FAULT_TOLERANCE_ROLE_DEFAULT);
        m_isPrimary = m_faultToleranceRole.equals(FAULT_TOLERANCE_ROLE_PRIMARY);
        m_isBackup = m_faultToleranceRole.equals(FAULT_TOLERANCE_ROLE_BACKUP);
        m_partnerRole =  m_isPrimary ? FAULT_TOLERANCE_ROLE_BACKUP : FAULT_TOLERANCE_ROLE_PRIMARY;
        if (!m_isNotFaultTolerant)
        {
            boolean bacupAccordingBootFile = System.getProperty(IContainer.SANITY_DS_FT_ROLE_BACKUP) != null;
            boolean primaryAccordingBootFile = System.getProperty(IContainer.SANITY_DS_FT_ROLE_PRIMARY) != null;
            if (!bacupAccordingBootFile  && !primaryAccordingBootFile)
            {
                String errorMsg = "Mismatch between the boot files and the configuration: According to the boot files this container does not host the Directory Service or the Directory Service is not Fault Tolerant.";
                shutdown(errorMsg, new Integer(IContainerExitCodes.DS_FAILURE_EXIT_CODE));
            }
            else if (bacupAccordingBootFile != m_isBackup)
            {
                String errorMsg = "Mismatch between the Directory Service boot file and the configuration: The fault tolerance role of the Directory Service according to the boot file is " +
                                           (bacupAccordingBootFile ? "BACKUP" : "PRIMARY");
                shutdown(errorMsg, new Integer(IContainerExitCodes.DS_FAILURE_EXIT_CODE));
            }
        }

    }

    private void readReplicationParameters(IAttributeSet dsAttributes, IComponentContext context)
    {
    	IAttributeSet replParams = (IAttributeSet)dsAttributes.getAttribute(IDirectoryServiceConstants.REPLICATION_PARAMETERS_ATTR);

        // Create a temporary empty primaryReplAttrs if non exists in the primary config to simplify the code
        if (replParams == null)
        {
            IElement tmpEl = ElementFactory.createElement("/tmp", "tmp", "tmp");
            IAttributeSet tmpPrimaryAtts = tmpEl.getAttributes();
            try
            {
                replParams = tmpPrimaryAtts.createAttributeSet(IDirectoryServiceConstants.REPLICATION_PARAMETERS_ATTR);
            }
            catch (Exception e){} //Could never happen
        }

        Object tmp = null;
        tmp = replParams.getAttribute(IDirectoryServiceConstants.RETRY_INTERVAL_ATTR);
        m_replicationRetryInterval = tmp == null ? IDirectoryServiceConstants.RETRY_INTERVAL_DEFAULT : ((Integer)tmp).intValue();
        tmp = replParams.getAttribute(IDirectoryServiceConstants.PING_INTERVAL_ATTR);
        m_replicationPingInterval = tmp == null ? IDirectoryServiceConstants.PING_INTERVAL_DEFAULT : ((Integer)tmp).intValue();
        tmp = replParams.getAttribute(IDirectoryServiceConstants.FAILURE_DETECTION_TIMEOUT_ATTR);
        m_replicationFailureDetectionTimeout = tmp == null ? IDirectoryServiceConstants.FAILURE_DETECTION_TIMEOUT_DEFAULT : ((Integer)tmp).intValue();
        tmp = replParams.getAttribute(IDirectoryServiceConstants.MAX_REPLICATION_LOG_SIZE_ATTR);
        m_maxReplicationLogSize = tmp == null ? IDirectoryServiceConstants.MAX_REPLICATION_LOG_SIZE_DEFAULT : ((Integer)tmp).intValue();
        tmp = replParams.getAttribute(IDirectoryServiceConstants.REPLICATION_TIMEOUT_ATTR);
        m_replicationTimeout = tmp == null ? IDirectoryServiceConstants.REPLICATION_TIMEOUT_DEFAULT : ((Integer)tmp).intValue();
        tmp = replParams.getAttribute(IDirectoryServiceConstants.DUAL_ACTIVE_RESOLUTION_ATTR);
        m_dualActiveResolution = tmp == null ? AUTOMATIC_DUAL_ACTIVE_RESOLUTION_DEFAULT : ((Boolean)tmp).booleanValue();
        tmp = replParams.getAttribute(IDirectoryServiceConstants.BACKUP_FAILOVER_READ_ONLY_ATTR);
        m_backupFailoverReadOnly = tmp == null ? BACKUP_FAILOVER_READ_ONLY_DEFAULT : ((Boolean)tmp).booleanValue();

            //See functional spec - if the BACKUP is readonly, we can safely prefer the PRIMARY
            if (m_backupFailoverReadOnly)
            {
                m_dualActiveResolution = true;
            }

            IAttributeSet tmpSet = (IAttributeSet)replParams.getAttribute(IDirectoryServiceConstants.SSL_PARAMETERS_ATTR);
            if (tmpSet != null)
            {
                m_replSSLParams = (HashMap)tmpSet.getAttributes().clone();
            }


    	// read the replication connection parameters
    	IAttributeSet references = (IAttributeSet)dsAttributes.getAttribute(IDirectoryServiceConstants.CONFIG_ELEMENT_REFERENCES_ATTR);
    	Reference replConnectionsRef;
    	if (references != null)
    	{
    		replConnectionsRef = (Reference)references.getAttribute(IDirectoryServiceConstants.REPLICATION_CONNECTIONS_ELEMENT_REF_ATTR);
    		if (replConnectionsRef != null)
    		{
    			if (m_faultToleranceRole.equals(FAULT_TOLERANCE_ROLE_DEFAULT))
                {
                    m_faultToleranceRole = FAULT_TOLERANCE_ROLE_PRIMARY;
                }
    			IElement replConnectionsEl = context.getConfiguration(replConnectionsRef.getElementName(), true);
    			if (replConnectionsEl != null)
    			{
    				IAttributeSet connectionsSet = (IAttributeSet)replConnectionsEl.getAttributes().getAttribute(IReplicationConnectionConstants.REPLICATION_CONNECTIONS_ATTR);
    				if (connectionsSet != null)
    				{
    					HashMap connectionsMap = connectionsSet.getAttributes();
    					Collection connCol = connectionsMap.values();
    					Iterator connIt = connCol.iterator();
    					m_replConnections = new HashMap[connCol.size()];
    					int replConnIndex = 0;
    					while (connIt.hasNext())
    					{
    						IAttributeSet connectionInfo = (IAttributeSet)connIt.next();
    						HashMap connectionMap = new HashMap();
    						Object value = connectionInfo.getAttribute(IReplicationConnectionConstants.PROTOCOL_ATTR);
    						if (value == null)
                            {
                                value = IReplicationConnectionConstants.PROTOCOL_DEFAULT;
                            }
    						connectionMap.put(IReplicationConnectionConstants.PROTOCOL_ATTR, value);
    						value = connectionInfo.getAttribute(IReplicationConnectionConstants.PRIMARY_ADDR_ATTR);
    						if (value != null)
                            {
                                connectionMap.put(IReplicationConnectionConstants.PRIMARY_ADDR_ATTR, value);
                            }
    						value = connectionInfo.getAttribute(IReplicationConnectionConstants.PRIMARY_PORT_ATTR);
    						if (value == null)
                            {
                                value = new Integer(IReplicationConnectionConstants.PRIMARY_PORT_DEFAULT);
                            }
    						connectionMap.put(IReplicationConnectionConstants.PRIMARY_PORT_ATTR, value);
    						value = connectionInfo.getAttribute(IReplicationConnectionConstants.BACKUP_ADDR_ATTR);
    						if (value != null)
                            {
                                connectionMap.put(IReplicationConnectionConstants.BACKUP_ADDR_ATTR, value);
                            }
    						value = connectionInfo.getAttribute(IReplicationConnectionConstants.BACKUP_PORT_ATTR);
    						if (value == null)
                            {
                                value = new Integer(IReplicationConnectionConstants.BACKUP_PORT_DEFAULT);
                            }
    						connectionMap.put(IReplicationConnectionConstants.BACKUP_PORT_ATTR, value);
    						value = connectionInfo.getAttribute(IReplicationConnectionConstants.WEIGHT_ATTR);
    						if (value == null)
                            {
                                value = new Integer(IReplicationConnectionConstants.WEIGHT_DEFAULT);
                            }
    						connectionMap.put(IReplicationConnectionConstants.WEIGHT_ATTR, value);
    						m_replConnections[replConnIndex++] = connectionMap;
    					}
    				}
    			}
    		}
    	}
    }

    @Override
    public synchronized void handleElementChange(IElementChange elementChange)
    {
        String elementType = elementChange.getElement().getIdentity().getType();
        String elementName = elementChange.getElement().getIdentity().getName();
        if (elementType.equals(IBackupDirectoryServiceConstants.DS_TYPE) || elementType.equals(IDirectoryServiceConstants.DS_TYPE) || elementType.equals(IReplicationConnectionConstants.DS_TYPE))
        {
            m_containerImpl.generateDSBootFile(m_id);
        }
        // The component wants notifications for the replication connections element as well,
        // when it becomes a FT DS.
        // Because the elementChange doesn't really tell us whether the DS element just went
        // from non FT to FT, we just look for the replication connections, and if they exist, we
        // make sure this component is getting change notifications for the replications connection
        // element so the DS boot file can be updated.
        // This is not an issue with the backup directory service because upon startup,
        // the backup DS has already fetched the replication connections. 
        if (elementType.equals(IDirectoryServiceConstants.DS_TYPE))
        {
            IDirElement DSEl;
            
            try
            {
                DSEl = getElement(elementName, Boolean.FALSE);

                IAttributeSet refs = (IAttributeSet)DSEl.getAttributes().getAttribute(IDirectoryServiceConstants.CONFIG_ELEMENT_REFERENCES_ATTR);
                if (refs != null)
                {
                    Reference replRef = (Reference)refs.getAttribute(IDirectoryServiceConstants.REPLICATION_CONNECTIONS_ELEMENT_REF_ATTR);
                    if (replRef != null)
                    {
                        getContext().getConfiguration(replRef.getElementName(), true);
                    }
                }

            }
            catch (MFException mfE)
            {
                logMessage("Unable to check for the existance of a replication connection element while handling element change, trace follows...", mfE, Level.WARNING);
            }
            
        }
        // This would be very rare since how can the DS be changed if it is stopped?
        // But it could happen a message gets here very late.
        try
        {
            validateStarted();
            validateActive();
        }
        catch (DSNotStartedException e)
        {
            return;
        }
        catch (MFServiceNotActiveException e)
        {
            return;
        }


        if (elementName.equals(m_id))
        {
            IElement dsElement = super.m_context.getConfiguration(elementName, true);
            setTraceMask(dsElement.getAttributes());
            return;
        }

        if (m_ds == null)
        {
            return;
        }

        // We want to update the trigger validation table if any of that info is changed
        if (elementType.equals(MF_VALIDATOR_TYPE))
        {
            super.m_context.logMessage("Load validation information from " + MF_LIBRARY_DIR + ".", Level.INFO);
            m_ds.newTriggerValidator();
        }
        else if (elementType.equals(MF_DS_HANDLER_TYPE))
        {
            super.m_context.logMessage("Load Directory Service handler information from " + MF_HANDLERS_DIR + ".", Level.INFO);
            m_ds.newDSHandlers();
        }
        else if (elementType.equals(DOMAIN_DESC_TYPE))
        {
            if (elementChange.getChangeType() == IElementChange.ELEMENT_DELETED)
            {
                return;
            }

            m_ds.newAuthenticationDescriptor(super.m_context.getConfiguration(elementName, true));
        }

    }


    private void makeGlobalComponentUniquenessCall()
    {
        String localHost = null;
        try
        {
            localHost = java.net.InetAddress.getLocalHost().toString();
        }
        catch (Exception e)
        {
            localHost = e.toString();
        }

        // Create a DS unique ID based on the host and the domain directory. Since we cannot have
        // two DS instances in the same place at the same time (because of the DS lock), that guarantees
        // uniqueness but it also prevent duplication confusion when a DS is started quickly after a crash -
        // Sonic00007505 (since the message from a session might be received by the next session).
        StringBuffer sb = new StringBuffer();
        sb.append(localHost);
        sb.append('|');
        try
        {
            sb.append(new File(m_hostDir == null ? m_hostDirDepricated : m_hostDir, m_context.getComponentName().getDomainName()).getCanonicalPath());
        } catch(IOException e) { }
        if (!m_isNotFaultTolerant)
        {
            sb.append('|');
            sb.append(m_faultToleranceRole);
        }
        m_uniqunessCallID = sb.toString();

        m_uniquenessCheckThread = new Thread(DSComponent.GLOBAL_ID + " - Uniqueness Checker")
        {
            @Override
            public void run()
            {
                // We want to make sure the uniquness call will get through even if the broker is down.
                // So we keep trying until we get our own message (or a message from another, duplicate, DS)
                while (!m_uniquenessCallReceived)
                {
                   // Send a message to any other Directory Service in this domain
                   // to verify that there only one. globalComponentUniquenessCall
                   // invokes the uniquenessCheck() method of all the Directory Service
                   // components in this domain - see uniquenessCheck() bellow.
                   try
                   {
                       DSComponent.super.m_frameworkContext.makeGlobalComponentUniquenessCall(GLOBAL_ID, m_uniqunessCallID);
                       if (!m_isNotFaultTolerant)
                    {
                        DSComponent.super.m_frameworkContext.makeGlobalComponentUniquenessCall(GLOBAL_ID, m_uniqunessCallID, m_faultToleranceRole);
                    }
                   }
                   catch (Exception e)
                   {
                       throw createMFRuntimeException(e);
                   }

                   if (m_uniquenessCallReceived)
                {
                    return;
                }
                else
                   {
                       try
                       {
                           synchronized(m_uniquenessCheckLockObj)
                           {
                               m_uniquenessCheckLockObj.wait(3000);
                           }
                       }
                       catch (InterruptedException e) { }
                   }
                }
            }
        };
        m_uniquenessCheckThread.start();
    }

    @Override
    public void uniquenessCheck(String containerID, String responderID)
    {
        String thisContainerName = super.m_frameworkContext.getContainer().getContainerIdentity().getCanonicalName();
        synchronized(m_uniquenessCheckLockObj)
        {
            m_uniquenessCallReceived = true;
            m_uniquenessCheckLockObj.notifyAll();
        }

        if (m_responseSent)
        {
            return;
        }

        StringTokenizer st = new StringTokenizer(responderID, "|");
        boolean isFaultTolerantResponder = st.countTokens() == 3;

        StringBuffer errorMessage = new StringBuffer();

        if (m_isNotFaultTolerant)
        {
            if (isFaultTolerantResponder)
            {
                errorMessage.append("Domain has both fault tolerant and non-fault tolerant Directory Service instances");
            }
            else
            if (!containerID.equals(thisContainerName))
            {
                errorMessage.append("Domain has two active Directory Service instances");
            }
        }
        else
        {
            if (isFaultTolerantResponder)
            {
                if (!containerID.equals(thisContainerName))
                {
                    st.nextToken();
                    st.nextToken();
                    // strip of the last token of the responder and see if it has the same role
                    String responderRole = st.nextToken();
                    if (responderRole.equals(m_faultToleranceRole))
                    {
                        errorMessage.append("Domain has two " + responderRole + " Directory Service instances");
                    }
                }
            }
            else
            {
                errorMessage.append("Domain has both fault tolerant and non-fault tolerant Directory Service instances");
            }
        }

        if (errorMessage.length() > 0)
        {
            // Makes sure the other container with DS knows about this DS instance
            try
            {
                super.m_frameworkContext.makeGlobalComponentUniquenessCall(GLOBAL_ID, m_uniqunessCallID);
                m_responseSent = true;
                Thread.sleep(3000);
            }
            catch (Exception e)
            {
                throw createMFRuntimeException(e);
            }

            errorMessage.append(" (this container will be shutdown to allow configuration resolution):");
            errorMessage.append(IContainer.NEWLINE).append(IContainer.NEWLINE).append('\t');
            errorMessage.append("One is in container      : ").append(thisContainerName);
            errorMessage.append(IContainer.NEWLINE).append('\t');
            errorMessage.append("The other is in container: ").append(containerID);
            errorMessage.append(IContainer.NEWLINE);

            shutdown(errorMessage.toString(), new Integer(IContainerExitCodes.DS_ALREADY_RUNNING_EXIT_CODE));
        }
    }

    public void shutdown(String errorMessage, Integer exitCode)
    {
        shutdown(errorMessage, null, exitCode);
    }

    @Override
    public void shutdown(String errorMessage, Throwable e, Integer exitCode)
    {
        synchronized(m_shutdownLock)
        {
            if (super.m_container.isClosing())
            {
                return;
            }

            if (errorMessage != null && super.m_context != null)
            {
                if (e == null)
                {
                    super.m_context.logMessage(errorMessage, Level.SEVERE);
                }
                else
                {
                    super.m_context.logMessage(errorMessage, e, Level.SEVERE);
                }
            }

            super.m_container.shutdown(exitCode.intValue());
        }
    }

    private void announceDirectoryServiceIsAvailable(final boolean isRestart, boolean isGlobalAnnouncement)
    {
        String[] tmp = null;

        // if its global then announce to all containers irrespective of whether they have previously
        // subscribed .. otherwise just announce to the list of subscribed containers
        if (isGlobalAnnouncement)
        {
            try
            {
                IDirElement[] elements = m_ds.getAllElements(IContainer.CONTAINERS_DIR, false);
                ArrayList containers = new ArrayList();
                for (int i = 0; i < elements.length; i++)
                {
                    IAttributeSet attrs = elements[i].getAttributes();
                    String containerName = (String)attrs.getAttribute(IContainerConstants.CONTAINER_NAME_ATTR);
                    containers.add(m_domainName + '.' + containerName);
                }
                tmp = (String[])containers.toArray(IEmptyArray.EMPTY_STRING_ARRAY);
            }
            catch (MFException e)
            {
                shutdown(e.getMessage(), new Integer(IContainerExitCodes.DS_FAILURE_EXIT_CODE));
            }
        }
        else
        {
            // by getting the list of subscribers we are effectively getting a list of all known active containers
            try
            {
                tmp = ((IPersistSubscribers)m_ds).getCollectionSubscribers();
            }
            catch (DirectoryServiceException e)
            {
                shutdown(e.getMessage(), new Integer(IContainerExitCodes.DS_FAILURE_EXIT_CODE));
            }
        }

        final String[] subscribers = tmp;

        Runnable announcer = new Runnable()
        {
            @Override
            public void run()
            {
                // we don't want to send startup notifications before we are sure the container is ready since we don't
                // want thse notifications to get lost
                waitForContainerBoot();

                if (m_container.isClosing())
                {
                    return;
                }

                boolean debugNotifications = (DSComponent.super.m_traceMask & IDebuggingMasks.TRACE_CONFIGURATION_NOTIFICATIONS) > 0;

                // notify (asynchronously) all the containers we know about that the DS is now available
                DSComponent.this.sendChangedElement(m_dsStartupElement, subscribers, isRestart, debugNotifications);
            }
        };
        m_frameworkContext.scheduleTask(announcer, new Date(System.currentTimeMillis()));
    }

    private void waitForContainerBoot()
    {
        synchronized(m_container)
        {
            try
            {
                while (!(super.m_container.isBooted() || super.m_container.isClosing()))
                {
                    super.m_container.wait(1000);
                }
            } catch(InterruptedException ie) { return; } // can't think that this would ever occur
        }
    }

    private void makeConfigChangeSubscriptions()
    {
        // We want to know when the information in MF_LIBRARY_DIR and MF_HANDLERS_DIR
        // is modified so we can update the trigger validation and DS handlers tables. We ignore the exception so that
        // nothing brakes if MF_LIBRARY_DIR does not exist
        try
        {
            super.m_context.getConfigurations(MF_LIBRARY_DIR, true);
            super.m_context.getConfigurations(MF_HANDLERS_DIR, true);
        }
        catch (Exception e)
        {
            super.m_context.logMessage(e.toString() + ":  Configuration validation will not be performed.", Level.INFO);
        }

        // We want to know when authentication domain descriptors change so we can reconnect external sources
        // if the connection parameter changed.
        try
        {
            String[] descriptors = m_ds.getExternalDomainsDescriptors();
            boolean[] acceptIndicators = new boolean[descriptors.length];
            for (int i = 0; i < descriptors.length; i++)
            {
                acceptIndicators[i] = true;
            }
            super.m_context.getConfigurations(descriptors, acceptIndicators);
        }
        catch (Exception e)
        {
            super.m_context.logMessage(e.toString() + ":  on-the-fly modifications of external authentication connection parameters is not supported.", Level.INFO);
        }
    }

    // sendChangedElement is used by the DS to send a modified or a new or a deleted element to an interested container
    // Failure is tragic - when communication is restored the container will resync the configuration
    public void sendChangedElement(IBasicElement element, String target, boolean tellThisContainerDSstarted, boolean doDebug)
    {
        try
        {
        	if (m_ds.areNotificationsSuspended(target))
        	{
        		// tracing used in upgrade migtests as proof of no-notifications
        	    trace(IDebuggingMasks.TRACE_CONFIGURATION_NOTIFICATIONS, "Notifications suspended for \"" + target + "\"; will not notify it about \"" + element.getIdentity().getName() + "\" modification");
        	    return;
        	}
            CanonicalName cName = new CanonicalName(target);
            CanonicalName remoteAgentName = new CanonicalName(cName.getDomainName(), cName.getContainerName(), IAgentProxy.ID);
            super.m_frameworkContext.invoke(remoteAgentName.getCanonicalName(),
                                            "receiveChangedElement",
                                            new Object[] { element },
                                            new String[] { IBasicElement.class.getName() },
                                            false, 0);
            if ((m_traceMask & IComponent.TRACE_VERBOSE) > 0)
            {
                trace(IDebuggingMasks.TRACE_CONFIGURATION_NOTIFICATIONS, "Notified \"" + target + "\" about \"" + element.getIdentity().getName() + "\" modification");
            }
        }
        catch (Throwable t)
        {
            if (doDebug)
            {
                super.m_context.logMessage("Failed to send configuration change to container " + target + ", trace follows...", t, Level.TRACE);
            }
        }
    }

    // bulk version of sendChangedElement
    public void sendChangedElements(IBasicElement[] elements, String target, boolean tellThisContainerDSstarted, boolean doDebug)
    {
        try
        {
        	if (m_ds.areNotificationsSuspended(target))
        	{
        		// tracing used in upgrade migtests as proof of no-notifications
        		if ((m_traceMask & IDebuggingMasks.TRACE_CONFIGURATION_NOTIFICATIONS) > 0)
        		{
        		    for (int i=0; i< elements.length; i++)
                    {
                        trace(IDebuggingMasks.TRACE_CONFIGURATION_NOTIFICATIONS, "Notifications suspended for \"" + target + "\"; will not notify it about \"" + elements[i].getIdentity().getName() + "\" modification");
                    }
        		}
        		return;
        	}
            CanonicalName cName = new CanonicalName(target);
            CanonicalName remoteAgentName = new CanonicalName(cName.getDomainName(), cName.getContainerName(), IAgentProxy.ID);
            super.m_frameworkContext.invoke(remoteAgentName.getCanonicalName(),
                                            "receiveChangedElements",
                                            new Object[] { elements },
                                            new String[] { IBasicElement[].class.getName() },
                                            false, 0);
            if ((m_traceMask & IComponent.TRACE_VERBOSE) > 0)
            {
                trace(IDebuggingMasks.TRACE_CONFIGURATION_NOTIFICATIONS, "Notified \"" + target + "\" about \"" + elements.length + "\" modifications");
            }
        }
        catch (Throwable t)
        {
            if (doDebug)
            {
                super.m_context.logMessage("Failed to send configurations change to container " + target + ", trace follows...", t, Level.TRACE);
            }
        }
    }

    // sendChangedElements is used by the DS to send new or deleted elements to an interested container
    public void sendChangedElements(IDirElement[] elements, String target, boolean doDebug)
    {
        try
        {
        	if (m_ds.areNotificationsSuspended(target))
        	{
        		if ((m_traceMask & IDebuggingMasks.TRACE_CONFIGURATION_NOTIFICATIONS) > 0)
        		{
        		    for (int i=0; i< elements.length; i++)
                    {
                        trace(IDebuggingMasks.TRACE_CONFIGURATION_NOTIFICATIONS, "Notifications suspended for \"" + target + "\"; will not notify it about \"" + elements[i].getIdentity().getName() + "\" modification");
                    }
        		}
         	   return;
        	}
            CanonicalName cName = new CanonicalName(target);
            CanonicalName remoteAgentName = new CanonicalName(cName.getDomainName(), cName.getContainerName(), IAgentProxy.ID);
            super.m_frameworkContext.invoke(remoteAgentName.getCanonicalName(),
                                            "receiveChangedElements",
                                            new Object[] {elements},
                                            new String[] {elements.getClass().getName()},
                                            false, 0);
            if ((m_traceMask & IComponent.TRACE_VERBOSE) > 0)
            {
                trace(IDebuggingMasks.TRACE_CONFIGURATION_NOTIFICATIONS, "Notified \"" + target + "\" about \"" + elements.length + "\" modifications");
            }
        }
        catch (Throwable t)
        {
            if (doDebug)
            {
                super.m_context.logMessage("Failed to send configurations change to container " + target + ", trace follows...", t, Level.TRACE);
            }
        }
    }

    // sendChangedElement is used by the DS to send modified or new elements to multiple containers asynchronously
    public void sendChangedElement(final IBasicElement element, final String[] targets, final boolean tellThisContainerDSstarted, final boolean doDebug)
    {

        Runnable invoker = new Runnable()
        {
            @Override
            public void run()
            {
                try
                {
                    for (int i = 0; i < targets.length; i++)
                    {
                        sendChangedElement(element, targets[i], tellThisContainerDSstarted, doDebug);
                    }
                }
                catch (Exception e) { }
            }
        };

        super.m_context.scheduleTask(invoker, new Date());
    }

    /********************************************************************************************************/
    /***************** IDirectoryService Methods ************************************************************/
    /********************************************************************************************************/

    public String getDomain() throws MFException
    {
        validateStarted();
        return m_ds.getDomain();
    }

    public HashMap getStorageToLogicalMap() throws MFException
    {
        validateStarted();
        HashMap map = m_ds.getStorageToLogicalMap();
        // READ check after the action
        configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, null, false);
        return map;
    }

    public IDirElement[] getElements(String subscriber, String[] elementNames) throws MFException
    {
        trace(TRACE_CONTAINER_ACCESS, subscriber + ": getElements - ");
        for (int i = 0; i < elementNames.length; i++)
        {
            trace(TRACE_CONTAINER_ACCESS, elementNames[i]);
        }

        validateStarted();
        validateActive();
        m_registry.subscribe(subscriber, elementNames);
        FromElementList f = new FromElementList(elementNames);
        com.sonicsw.mf.common.config.query.Query q = new com.sonicsw.mf.common.config.query.Query().setFrom(f);
        return m_ds.getElements(q, false);
    }

    // Returns the configuration of the container in IElement[0] and any other configuration of a container activated
    // by this container in IElement[1]..IElement[N]
    public IElement[] getCreateContainerConfiguration(String containerPath, String activationPath, String hostManagerPath, Hashtable defaultContainerParams,
                                                    Hashtable defaultConnectionParams) throws MFException
    {
        validateStarted();
        validateActive();

        IDirElement containerConfig =  (IDirElement)m_ds.getElementByLogicalName(containerPath);
        // check for ALLOW_READ after the operation, to allow other exceptions to happen
        if (containerConfig != null)
        {
            configurePermissionReadCheck(containerPath, containerConfig.getIdentity().getName(), true);
        }
        if (containerConfig == null)
        {
            String activationName = null;
            String hostManagerName = null;

            try
            {
                if (activationPath != null)
                {
                    activationName = new EntityName(activationPath).getBaseName();
                }
                if (hostManagerPath != null)
                {
                    hostManagerName = new EntityName(hostManagerPath).getBaseName();
                }
            }
            catch (Exception e){}

            try
            {
                // check WRITE permissions in createContainerWithADandHM
                createContainerWithADandHM(containerPath, activationPath, activationName, hostManagerPath, hostManagerName);
                String containerStorageName = m_ds.logicalToStorage(containerPath);
                containerConfig = m_ds.getElement(containerStorageName, true);
                IDeltaDirElement delta = Container.initializeNewContainer(containerConfig, defaultContainerParams, defaultConnectionParams);
                m_ds.setElement(delta, null);
            }
            catch (ConfigurePermissionDeniedException denied)
            {
                throw denied;
            }
            catch (Exception e)
            {
                if (e instanceof MFException)
                {
                    throw (MFException)e;
                }
                else
                {
                    throw new MFException(e.toString());
                }
            }

            containerConfig = (IDirElement)m_ds.getElementByLogicalName(containerPath);
        }

        IElement[] retConfigurations = new IElement[]{containerConfig};
        return retConfigurations;
    }


    public IElement getElementByLogicalName(String subscriber, String logicalName) throws MFException
    {
    	trace(TRACE_CONTAINER_ACCESS, subscriber + ": getElementByLogicalName - " + logicalName);
        return getElementByLogicalNameInternal(subscriber, logicalName);
    }

    public IElement[] getElementsByLogicalNames(String subscriber, String[] logicalNames) throws MFException
    {
    	trace(TRACE_CONTAINER_ACCESS, subscriber + ": getElementsByLogicalNames");
        return getElementsByLogicalNamesInternal(subscriber, logicalNames);
    }

    public IDirElement[] getElementIfUpdated(Long callerBackupVersion, String elementName, IElementIdentity id) throws MFException
    {
    	trace(TRACE_CONTAINER_ACCESS,  "getElementIfUpdated");
        try
        {
            IDirElement[] eArray = m_ds.getElementIfUpdated(callerBackupVersion.longValue(), elementName, id);
            String logicalName = m_ds.storageToLogical(elementName);

            if (logicalName != null)
            {
                configurePermissionReadCheck(logicalName, elementName, true);
            }
            else
            {
                configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, elementName, false);
            }


            return eArray;
        }
        catch (NullPointerException e)
        {
            // TODO Auto-generated catch block
            e.printStackTrace();
            System.out.println("m_ds=" + m_ds);
            System.out.println("callerBackupVersion=" + callerBackupVersion);
            System.out.println("elementName=" + elementName);
            System.out.println("id=" + id);
            throw e;
        }
    }

    public IElement[] getElementsByLogicalNames(String[] logicalNames) throws MFException
    {
    	trace(TRACE_CONTAINER_ACCESS,  "getElementsByLogicalNames");
        return getElementsByLogicalNamesInternal(null, logicalNames);
    }

    private  IElement[] getElementsByLogicalNamesInternal(String subscriber, String[] logicalNames)
        throws MFException
    {
        validateStarted();
        validateActive();

        IElement[] elements =  m_ds.getElementsByLogicalNames(logicalNames);
        if (subscriber == null)
        {
            ArrayList returnElements = new ArrayList();
            //now do the ALLOW_READ check
            for (int i=0; i<elements.length; i++)
            {
                try
                {
                    if (elements[i] != null)
                    {
                        String storageName = elements[i].getIdentity().getName();
                        configurePermissionReadCheck(storageName, storageName, true);
                        returnElements.add(elements[i]);
                    }
                }
                catch (ConfigurePermissionDeniedException denied)
                {
                    continue;
                }
            }
            IElement [] prunedArray = new IElement[returnElements.size()];
            returnElements.toArray(prunedArray);
            return prunedArray;
        }

        // Use the storage name to register
        for (int i = 0; i < elements.length; i++)
        {
            if (elements[i] != null)
            {
                m_registry.subscribe(subscriber, elements[i].getIdentity().getName());
                m_registry.addLogicalSubscriber(logicalNames[i], subscriber);
            }
        }

        return elements;
    }

    public void registerInterestInChanges(String subscriber, String logicalName) throws MFException
    {
    	trace(TRACE_CONTAINER_ACCESS, subscriber + ": registerInterestInChanges for " + logicalName);
        getElementByLogicalNameInternal(subscriber, logicalName);
    }

    private IElement getElementByLogicalNameInternal(String subscriber, String logicalName) throws MFException
    {
        validateStarted();
        validateActive();

        IElement element =  m_ds.getElementByLogicalName(logicalName);
        if (element == null)
        {
            return null;
        }
        // Use the storage name to register
        String archiveName = getArchiveName(element);
        m_registry.subscribe(subscriber, element.getIdentity().getName());
        if (archiveName != null)
        {
            m_registry.addLogicalSubscriber(archiveName, subscriber);
        }
        else
        {
            m_registry.addLogicalSubscriber(logicalName, subscriber);
        }
        return element;
    }

    private String getArchiveName(IElement el)
    {
        String archiveName = null;
        IAttributeSet topSet = el.getAttributes();
        IAttributeSet systemAttrs = (IAttributeSet)topSet.getAttribute(IBlob.SYSTEM_ATTRIBUTES);
        if (systemAttrs != null)
        {
            archiveName = (String)systemAttrs.getAttribute(IBlob.ARCHIVE_NAME);
        }
        return archiveName;
    }

    public IBlob getBlobByLogicalName(String logicalName) throws MFException
    {
    	trace(TRACE_CONTAINER_ACCESS,  "getBlobByLogicalName - " + logicalName);
        validateStarted();
        validateActive();
        // READ operation, so check permissions after the read
        IBlob blob = m_ds.getBlobByLogicalName(logicalName);
        if (blob != null)
        {
            configurePermissionReadCheck(logicalName, blob.getElement().getIdentity().getName(), true);
        }
        return blob;
    }

    public IBlob getBlobByLogicalName(String subscriber, String logicalName) throws MFException
    {
        trace(TRACE_CONTAINER_ACCESS, subscriber + ": getBlobByLogicalName - " + logicalName);

        // We don't do change notifications for handler files. So this logicalName is to be handled by a handler
        // we call getBlobByLogicalName immediatelt, bypassing the registration of the subscriber with the envelope
        // element of this file
        if (m_ds.isHandlerPath(logicalName))
        {
            return m_ds.getBlobByLogicalName(logicalName);
        }

        IElement element = getElementByLogicalNameInternal(subscriber, logicalName);
        if (element == null)
        {
            return null;
        }
        String archiveName = getArchiveName(element);
        // archiveName is not a persistent attribute. Since we now get the element using
        // using the storage name, save it in the element for the caller
        IBlob blob = getBlob(element.getIdentity().getName(), Boolean.FALSE);
        element = blob.getElement();
        if (archiveName != null)
        {
            try
            {
                Blob.markBlobState((Element)element, archiveName, IBlob.ARCHIVE_NAME);
            }
            catch (Exception e)
            {
                throw new MFException(e.toString());
            }
        }
        return blob;
    }

    public IDirElement getElement(String subscriber, String elementName) throws MFException
    {
    	trace(TRACE_CONTAINER_ACCESS, subscriber + ": getElement - " + elementName);
        validateStarted();
        validateActive();
        m_registry.subscribe(subscriber, elementName);
        return m_ds.getElement(elementName, false);
    }

    public IDirElement getElement(String elementName, Boolean forUpdate) throws MFException
    {
        validateStarted();
        validateActive();
        IDirElement el = m_ds.getElement(elementName, forUpdate.booleanValue());
        // now do read permissions check
        String logicalName = m_ds.storageToLogical(elementName);

        if (logicalName != null)
        {
            configurePermissionReadCheck(logicalName, elementName, true);
        }
        else
        {
            if (!elementName.startsWith("/mx/configTypes/"))
            {
                configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, elementName, false);
            }
        }
        return el;
    }

    public String logicalToStorage(String path) throws MFException
    {
        validateStarted();
        validateActive();
        String storage = m_ds.logicalToStorage(path);
        //do not check to add the trailing slash for permissions check as path is not supposed to be a folder
        // READ operation, so we check permissions after the read
        configurePermissionReadCheck(path, storage, true);
        return storage;
    }

    public String storageToLogical(String storageName) throws MFException
    {
        validateStarted();
        validateActive();
        // this method can only return the name of an element, so no need to check to
        // add trailing slash for the permissions check
        String logical = m_ds.storageToLogical(storageName);
        if (logical != null)
        {
            EntityName eName;
            try
            {
                eName = new EntityName(logical);
                String parent = eName.getParent();
                if (!parent.endsWith(MF_DIR_SEPARATOR_STRING))
                {
                    parent = parent + MF_DIR_SEPARATOR_STRING;
                }
                configurePermissionReadCheck(parent, storageName, true);
            }
            catch (ConfigException configE)
            {
                throw new DirectoryServiceException("Unable to check permissions in storageToLogical for " + storageName);
            }

        }
        else
        {
            configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, storageName, false);
        }

        return logical;
    }


    public IDirElement getElement(String elementName, Boolean forUpdate, Boolean getSubclassingDelta) throws MFException
    {
        validateStarted();
        validateActive();
        IDirElement el = m_ds.getElement(elementName, forUpdate.booleanValue(), getSubclassingDelta.booleanValue());
        // now do read permissions check
        String logicalName = m_ds.storageToLogical(elementName);

        if (logicalName != null)
        {
            configurePermissionReadCheck(logicalName, elementName, true);
        }
        else
        {
            if (!elementName.startsWith("/mx/configTypes/"))
            {
                configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, elementName, false);
            }
        }
        return el;
    }

    public IDirElement[] getElements(com.sonicsw.mf.common.config.query.Query query, Boolean forUpdate) throws MFException
    {
        validateStarted();
        validateActive();
        IDirElement[] elements = m_ds.getElements(query, forUpdate.booleanValue());
        //now check ALLOW_READ and prune the list
        ArrayList prunedList = new ArrayList();
        IDirElement[] prunedElements;
        for (int i=0; i<elements.length; i++)
        {
            try
            {
                String storageName = elements[i].getIdentity().getName();
                String logicalName = m_ds.storageToLogical(storageName);
                if (logicalName != null)
                {
                    configurePermissionReadCheck(logicalName, storageName, true);
                }
                else
                {
                    configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, storageName, false);
                }
                prunedList.add(elements[i]);
            }
            catch (ConfigurePermissionDeniedException denied)
            {
                continue;
            }
        }
        prunedElements = new IDirElement[prunedList.size()];
        prunedList.toArray(prunedElements);
        return prunedElements;
    }

    public IDirElement[] getElements(com.sonicsw.mf.common.config.query.Query query, Boolean forUpdate, Boolean getSubclassingDelta) throws MFException
    {
        validateStarted();
        validateActive();
        IDirElement[] elements = m_ds.getElements(query, forUpdate.booleanValue(), getSubclassingDelta.booleanValue());
        //now check ALLOW_READ and prune the list
        ArrayList prunedList = new ArrayList();
        IDirElement[] prunedElements;
        for (int i=0; i<elements.length; i++)
        {
            try
            {
                String storageName = elements[i].getIdentity().getName();
                String logicalName = m_ds.storageToLogical(storageName);
                if (logicalName != null)
                {
                    configurePermissionReadCheck(logicalName, storageName, true);
                }
                else
                {
                    configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, storageName, false);
                }
                prunedList.add(elements[i]);
            }
            catch (ConfigurePermissionDeniedException denied)
            {
                continue;
            }
        }
        prunedElements = new IDirElement[prunedList.size()];
        prunedList.toArray(prunedElements);
        return prunedElements;
    }

    public IBlob getBlob(String subscriber, String elementName) throws MFException
    {
        trace(TRACE_CONTAINER_ACCESS, subscriber + ": getBlob - " + elementName);
        validateStarted();
        validateActive();
        m_registry.subscribe(subscriber, elementName);
        return m_ds.getBlob(elementName, false);
    }

    private IBlob getEntireBlob(String elementName, Boolean forUpdate) throws MFException
    {
    	validateStarted();
        validateActive();
        IBlob blob = null;
        try
        {
          blob = m_ds.getEntireBlob(elementName, forUpdate.booleanValue());
        }
        catch (MFException mfE)
        {
            throw mfE;
        }
        catch (Exception e)
        {
            throw new MFException(e.toString());
        }
        //now perform permission checking. Find the logical name first if it exists.
        String logicalName = m_ds.storageToLogical(elementName);

        if (logicalName != null)
        {
            configurePermissionReadCheck(logicalName, elementName, true);
        }
        else
        {
            configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, elementName, false);
        }

        return blob;
    }

    public IBlob getBlob(String elementName, Boolean forUpdate) throws MFException
    {
        return getBlob(elementName, forUpdate, new Integer(0));
    }

    public IBlob getBlob(String elementName, Boolean forUpdate, Integer offset) throws MFException
    {
        validateStarted();
        validateActive();
        IBlob blob = null;
        try
        {
          blob = m_ds.getBlob(elementName, forUpdate.booleanValue(), offset.intValue());
        }
        catch (MFException mfE)
        {
            throw mfE;
        }
        catch (Exception e)
        {
            throw new MFException(e.toString());
        }
        //now perform permission checking. Find the logical name first if it exists.
        String logicalName = m_ds.storageToLogical(elementName);

        if (logicalName != null)
        {
            configurePermissionReadCheck(logicalName, elementName, true);
        }
        else
        {
            configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, elementName, false);
        }

        return blob;
    }

    public com.sonicsw.mf.common.config.IIdentity getIdentity(String name) throws MFException
    {
        validateStarted();
        validateActive();
        com.sonicsw.mf.common.config.IIdentity id = m_ds.getIdentity(name);
        String logicalName = null;
        try
        {
            logicalName = m_ds.storageToLogical(name);
        }
        catch (DirectoryServiceException e)
        {} // continue, maybe name is a directory

        if (logicalName != null)
        {
            EntityName eName;
            try
            {
                eName = new EntityName(logicalName);
                String parent = eName.getParent();
                if (!parent.endsWith(MF_DIR_SEPARATOR_STRING))
                {
                    parent = parent + MF_DIR_SEPARATOR_STRING;
                }
                configurePermissionReadCheck(parent, name, true);
            }
            catch (ConfigException configE)
            {
                throw new DirectoryServiceException("Unable to check permissions in getIdentity for " + name);
            }

        }
        else
        {
            configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, name, false);
        }

        return id;
    }

    public IDirElement[] getAllElements(String dirName, Boolean forUpdate) throws MFException
    {
        validateStarted();
        validateActive();
        IDirElement[] elements =  m_ds.getAllElements(dirName, forUpdate.booleanValue());
        //now check ALLOW_READ and prune the list
        ArrayList prunedList = new ArrayList();
        IDirElement[] prunedElements;
        for (int i=0; i<elements.length; i++)
        {
            try
            {
                String storageName = elements[i].getIdentity().getName();
                String logicalName = m_ds.storageToLogical(storageName);
                if (logicalName != null)
                {
                    configurePermissionReadCheck(logicalName, storageName, true);
                }
                else
                {
                    configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, storageName, false);
                }
                prunedList.add(elements[i]);
            }
            catch (ConfigurePermissionDeniedException denied)
            {
                continue;
            }
        }
        prunedElements = new IDirElement[prunedList.size()];
        prunedList.toArray(prunedElements);
        return prunedElements;
    }

    public byte[] getAllElementsCompressed(String dirName, Boolean forUpdate) throws MFException
    {
        validateStarted();
        validateActive();
        IDirElement[] prunedElements = getAllElements(dirName, forUpdate);
        try
        {
            return ZipUtils.asZippedBytes(prunedElements);
        } catch (IOException e)
        {
            throw new DirectoryServiceException("Failed to compress elements in "+ dirName);
        }
    }


    public IDirElement[] getAllElements(String subscriber, String dirName) throws MFException
    {
        trace(TRACE_CONTAINER_ACCESS, subscriber + ": getAllElements - " + dirName);
        validateStarted();
        validateActive();
        m_registry.subscribe(subscriber, dirName);
        return m_ds.getAllElements(dirName, false);
    }

    public com.sonicsw.mf.common.config.IIdentity[] listAll(String dirName) throws MFException
    {
        validateStarted();
        validateActive();
        com.sonicsw.mf.common.config.IIdentity[] all =  m_ds.listAll(dirName);
        //now check ALLOW_READ on the folder
        ArrayList prunedList = new ArrayList();
        // for a large DS, getting the folders for all the elements being returned can be
        // costly. Make sure permissions checking is enabled. We don't check permissions 
        // for /_MFContext
        if (checkPermissions(dirName))
        {
            for (int i = 0; i < all.length; i++)
            {
                String id = all[i].getName();
                ;
                String logicalName = null;
                String folderName = null;

                if (all[i] instanceof IElementIdentity)
                {
                    logicalName = m_ds.storageToLogical(id);
                }

                if (logicalName != null)
                {
                    EntityName eName;
                    try
                    {
                        eName = new EntityName(logicalName);
                        folderName = eName.getParent();
                    }
                    catch (Exception e)
                    {
                        throw new DirectoryServiceException("Unable to check permissions while executing listAll " + e.toString());
                    }
                }
                try
                {
                    if (folderName != null)
                    {
                        if (folderName.equals(MF_DIR_SEPARATOR_STRING))
                        {
                            configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, id, true);
                        }
                        else
                        {
                            configurePermissionReadCheck(folderName + MF_DIR_SEPARATOR_STRING, id, true);
                        }
                    }
                    else
                    {
                        configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, id, false);
                    }
                }
                catch (ConfigurePermissionDeniedException denied)
                {
                    continue;
                }
                prunedList.add(all[i]);
            }
            com.sonicsw.mf.common.config.IIdentity[] prunedArray = new com.sonicsw.mf.common.config.IIdentity[prunedList.size()];
            prunedList.toArray(prunedArray);
            return prunedArray;
        }
        else
        {
            return all;
        }
    }

    public IDirIdentity[] listDirectories(String dirName) throws MFException
    {
        validateStarted();
        validateActive();
        IDirIdentity[] ids = m_ds.listDirectories(dirName);
        // read check after the action
        configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, dirName, false);
        return ids;
    }

    public IElementIdentity[] listElements(String dirName) throws MFException
    {
        validateStarted();
        validateActive();
        IElementIdentity[] all = m_ds.listElements(dirName);
        //now check ALLOW_READ on the folder
        ArrayList prunedList = new ArrayList();
        for (int i=0; i< all.length; i++)
        {
            String id = all[i].getName();
            String logicalName = m_ds.storageToLogical(id);
            String folderName = null;
            if (logicalName != null)
            {
                EntityName eName;
                try
                {
                    eName = new EntityName(logicalName);
                    folderName = eName.getParent();
                }
                catch (Exception e)
                {
                    throw new DirectoryServiceException("Unable to check permissions while executing listAll " + e.toString());
                }
            }
            try
            {
                if (folderName != null)
                {
                    if (folderName.equals(MF_DIR_SEPARATOR_STRING))
                    {
                        configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, id, true);
                    }
                    else
                    {
                        configurePermissionReadCheck(folderName + MF_DIR_SEPARATOR_STRING, id, true);
                    }
                }
                else
                {
                    configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, id, false);
                }
            }
            catch (ConfigurePermissionDeniedException denied)
            {
                continue;
            }
            prunedList.add(all[i]);
        }
        IElementIdentity[] prunedArray = new IElementIdentity[prunedList.size()];
        prunedList.toArray(prunedArray);
        return prunedArray;
    }

    public void detachBlob(IDeltaDirElement delta, IDeltaView view) throws MFException
    {
        validateStarted();
        validateActive();
        // check DELETE permission on the blob name
        String storageName = delta.getIdentity().getName();
        String logicalName = m_ds.storageToLogical(storageName);

        if (logicalName != null)
        {
            configurePermissionDeleteCheck(logicalName, storageName, true);
        }
        else
        {
            configurePermissionDeleteCheck(MF_DIR_SEPARATOR_STRING, storageName, false);
        }

        m_ds.detachBlob(delta, view);
    }

    public void deleteElement(String elementName, IDeltaView view) throws MFException
    {
        validateStarted();
        validateActive();
        String logicalName = m_ds.storageToLogical(elementName);

        if (logicalName != null)
        {
            configurePermissionDeleteCheck(logicalName, elementName, true);
        }
        else
        {
            configurePermissionDeleteCheck(MF_DIR_SEPARATOR_STRING, elementName, false);
        }

        m_ds.deleteElement(elementName, view);
    }

    public void unSubclassElement(String elementName, IDeltaView view) throws MFException
    {
        validateStarted();
        validateActive();
        String logicalName = m_ds.storageToLogical(elementName);
        IDirElement el = m_ds.getElement(elementName, false);

        if (logicalName != null)
        {
            configurePermissionWriteCheck(logicalName, elementName, true);
        }
        else
        {
            configurePermissionWriteCheck(MF_DIR_SEPARATOR_STRING, null, false);
        }


        if (el != null)
        {
            String superName = el.getSuperElementName();
            if (superName != null)
            {
                String superLogicalName = m_ds.storageToLogical(superName);
                if (superLogicalName != null)
                {
                    configurePermissionWriteCheck(superLogicalName, superName, true);
                }
                else
                {
                    configurePermissionWriteCheck(MF_DIR_SEPARATOR_STRING, null, false);
                }
            }
        }

        m_ds.unSubclassElement(elementName, view);
    }

    public void createDirectory(String dirName) throws MFException
    {
        validateStarted();
        validateActive();
        configurePermissionWriteCheck(MF_DIR_SEPARATOR_STRING, dirName, false);
        m_ds.createDirectory(dirName);
    }

    public void deleteDirectory(String dirName) throws MFException
    {
        validateStarted();
        validateActive();
        configurePermissionDeleteCheck(MF_DIR_SEPARATOR_STRING, dirName, false);
        m_ds.deleteDirectory(dirName);
    }

    public void deleteDirectory(String dirName, IDeltaView view) throws MFException
    {
        validateStarted();
        validateActive();
        //this will cover the permission to delete the elements under this directory
        configurePermissionDeleteCheck(MF_DIR_SEPARATOR_STRING, dirName, false);
        m_ds.deleteDirectory(dirName, view);
    }


    public void attachBlob(IBasicElement element, byte[] blob, IDeltaView view) throws MFException
    {
        validateStarted();
        validateActive();
        String storageName = element.getIdentity().getName();
        String logicalName = m_ds.storageToLogical(storageName);

        if (logicalName != null)
        {
            configurePermissionWriteCheck(logicalName, storageName, true);
        }
        else
        {
            configurePermissionWriteCheck(MF_DIR_SEPARATOR_STRING, storageName, false);
        }

        m_ds.attachBlob(element, blob, view);
    }

    public void appendBlob(IBasicElement element, byte[] blob, Integer offset, Boolean last, IDeltaView view) throws MFException
    {
        validateStarted();
        validateActive();
        String storageName = element.getIdentity().getName();
        String logicalName = m_ds.storageToLogical(storageName);

        if (logicalName != null)
        {
            configurePermissionWriteCheck(logicalName, storageName, true);
        }
        else
        {
            configurePermissionWriteCheck(MF_DIR_SEPARATOR_STRING, storageName, false);
        }

        m_ds.appendBlob(element, blob, offset.intValue(), last.booleanValue(), view);
    }

    public INextVersionToken setElement(IBasicElement element, IDeltaView view) throws MFException
    {
        validateStarted();
        validateActive();
        String storageName = element.getIdentity().getName();
        String logicalName = m_ds.storageToLogical(storageName);

        if (logicalName != null)
        {
            configurePermissionWriteCheck(logicalName, storageName, true);
        }
        else
        {
            configurePermissionWriteCheck(MF_DIR_SEPARATOR_STRING, storageName, false);
        }

        return m_ds.setElement(element, view);
    }

    public void upgrade5to6(String configType, String configLogicalPath) throws MFException
    {
        validateStarted();
        validateActive();
        m_ds.upgrade5to6(configType, configLogicalPath);
    }

    public void setElementReleaseVersion(String elementName, String newVersion) throws MFException
    {
        validateStarted();
        validateActive();
        String logicalName = m_ds.storageToLogical(elementName);

        if (logicalName != null)
        {
            configurePermissionWriteCheck(logicalName, elementName, true);
        }
        else
        {
            configurePermissionWriteCheck(MF_DIR_SEPARATOR_STRING, elementName, false);
        }

        m_ds.setElementReleaseVersion(elementName, newVersion);
    }

    public INextVersionToken setElements(IBasicElement[] elements, String[] deleteList, IDeltaView view) throws MFException
    {
        validateStarted();
        validateActive();
        if (elements != null)
        {
            for (int i=0; i< elements.length; i++)
            {
                if (elements[i] != null)
                {
                    String storageName = elements[i].getIdentity().getName();
                    String logicalName = m_ds.storageToLogical(storageName);

                    if (logicalName != null)
                    {
                        configurePermissionWriteCheck(logicalName, storageName, true);
                    }
                    else
                    {
                        configurePermissionWriteCheck(MF_DIR_SEPARATOR_STRING, storageName, false);
                    }
                }
            }
        }
        if (deleteList != null)
        {
            for (int i=0; i< deleteList.length; i++)
            {
                if (deleteList[i] != null)
                {
                    String logical = m_ds.storageToLogical(deleteList[i]);

                    if (logical != null)
                    {
                        configurePermissionDeleteCheck(logical, deleteList[i], true);
                    }
                    else
                    {
                        configurePermissionDeleteCheck(MF_DIR_SEPARATOR_STRING, deleteList[i], false);
                    }
                }
            }
        }
        return m_ds.setElements(elements, deleteList, view);
    }

    public IDirElement cloneElement(String elementName, String newName, IDeltaView view) throws MFException
    {
        validateStarted();
        validateActive();
        //can we read the source
        String sourceLogical = m_ds.storageToLogical(elementName);

        if (sourceLogical != null)
        {
            configurePermissionReadCheck(sourceLogical, elementName, true);
        }
        else
        {
            configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, elementName, false);
        }

        // we have to be able to write the destination. We assume it's a new storage name
        configurePermissionWriteCheck(MF_DIR_SEPARATOR_STRING, newName, false);

        return m_ds.cloneElement(elementName, newName, view);
    }

    public IDirElement cloneElement(IBasicElement delta, String newName, IDeltaView view) throws MFException
    {
        validateStarted();
        validateActive();
        //can we read the source
        String storageName = delta.getIdentity().getName();
        String sourceLogical = m_ds.storageToLogical(storageName);

        if (sourceLogical != null)
        {
            configurePermissionReadCheck(sourceLogical, storageName, true);
        }
        else
        {
            configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, storageName, false);
        }

        // we have to be able to write the destination. We assume it's a new storage name
        configurePermissionWriteCheck(MF_DIR_SEPARATOR_STRING, newName, false);

        return m_ds.cloneElement(delta, newName, view);
    }

    public IDirElement cloneElement(String elementName, String newName, Boolean createTemplate, IDeltaView view) throws MFException
    {
        validateStarted();
        validateActive();
        //can we read the source
        String sourceLogical = m_ds.storageToLogical(elementName);

        if (sourceLogical != null)
        {
            configurePermissionReadCheck(sourceLogical, elementName, true);
        }
        else
        {
            configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, elementName, false);
        }

        // we have to be able to write the destination. We assume it's a new storage name
        configurePermissionWriteCheck(MF_DIR_SEPARATOR_STRING, newName, false);

        return m_ds.cloneElement(elementName, newName, createTemplate.booleanValue(), view);
    }

    public IDirElement cloneElement(IBasicElement delta, String newName, Boolean createTemplate, IDeltaView view) throws MFException
    {
        validateStarted();
        validateActive();
        // can we read the source
        String storageName = delta.getIdentity().getName();
        String sourceLogical = m_ds.storageToLogical(storageName);

        if (sourceLogical != null)
        {
            configurePermissionReadCheck(sourceLogical, storageName, true);
        }
        else
        {
            configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, storageName, false);
        }

        // we have to be able to write the destination. We assume it's a new storage name
        configurePermissionWriteCheck(MF_DIR_SEPARATOR_STRING, newName, false);

        return m_ds.cloneElement(delta, newName, createTemplate.booleanValue(), view);
    }


    public IDirElement subclassElement(IBasicElement delta, String newName, IDeltaView view) throws MFException
    {
        validateStarted();
        validateActive();
        //can we read the source
        String storageName = delta.getIdentity().getName();
        String sourceLogical = m_ds.storageToLogical(storageName);

        if (sourceLogical != null)
        {
            configurePermissionReadCheck(sourceLogical, storageName, true);
        }
        else
        {
            configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, null, false);
        }

        // we have to be able to write the destination. We assume it's a new storage name
        configurePermissionWriteCheck(MF_DIR_SEPARATOR_STRING, null, false);

        return m_ds.subclassElement(delta, newName, view);
    }

    public String ping(String pingMessage) throws MFException
    {
        validateStarted();
        validateActive();
        return pingMessage;
    }

    public String ping(String containerID, Short[] versionInfo) throws MFException
    {
        validateStarted();
        validateActive();

        ContainerCompatibility.addContainer(containerID, versionInfo[0].shortValue(), versionInfo[1].shortValue(), versionInfo[2].shortValue(), versionInfo[3].shortValue());

        return "PONG";
    }

    public  IDirElement[] getUpdatedList(String subscriber, IElementIdentity[] identities, HashMap deletedConfs, Long callerBackupVersion)
    throws MFException
    {
    	trace(TRACE_CONTAINER_ACCESS, subscriber + ": getUpdatedList ");

        validateStarted();
        validateActive();

        registerElementSubscriptions(subscriber, identities, deletedConfs);

        long callerBV = callerBackupVersion != null ? callerBackupVersion.longValue() : 0;
        return m_ds.getUpdatedList(identities, deletedConfs, callerBV);
    }

    public IDirElement[] getNewElements(String subscriber, String dirName, IElementIdentity[] identities) throws MFException
    {
    	trace(TRACE_CONTAINER_ACCESS, subscriber + ": getNewElements");

        validateStarted();
        validateActive();

        m_registry.subscribe(subscriber, dirName);

        return m_ds.getNewElements(dirName, identities);
    }

    public IDirElement[][] getCacheElements(String subscriber, Long callerBackupVersion, IElementIdentity[] identities, HashMap deletedConfs, String dirNames[]) throws MFException
    {
    	trace(TRACE_CONTAINER_ACCESS, subscriber + ": getCacheElements");

        validateStarted();
        validateActive();

        if (deletedConfs != null)
        {
            registerElementSubscriptions(subscriber, identities, deletedConfs);
        }

        if (dirNames != null)
        {
            for (int i = 0; i < dirNames.length; i++)
            {
                m_registry.subscribe(subscriber, dirNames[i]);
            }
        }

        long callerBV = callerBackupVersion != null ? callerBackupVersion.longValue() : 0;

        return m_ds.getCacheElements(callerBV, identities, deletedConfs, dirNames);
    }

    /**
     * This method is intended to superseed calls to getUpdatedList()/getNewElements()/getCacheElements with a single bulk operation. It will
     * be called by >= v2.1.1 containers.
     * <p>
     * Returns an array of three elements:
     * <p>
     * The first element holds a list of elements that were modified relative to a list of element identities
     * (note that the identity object contains the element's version). If an element in the central repository
     * has version greater than version in the identities list then this element is included in the list of returned
     * elements. If an element in the identities list does not exist in the central repository then the IDirElement
     * object returned in the list returns isDeleted() = true. Also returns elements that were deleted and maybe
     * recreated (specified in the deletedConfigurations list). If the map of deletedConfigurations is null, then this
     * is a repeat call for further new elements (second element), and the first element will be set to null.
     * <p>
     * The second element holds an array of read-only elements that were added to the given list of directories. If the
     * dirNames parameter is null, then this is a repeat call and the second element will be set to null.
     * <p>
     * The third element holds a hash map of logical to storage name corrections that must be applied to the cache.
     * Nothing is returned for names that match, null is returned for names that no longer exist. The new logical
     * names are returned for renamed elements.
     * <p>
     * If any element is an empty array (or an element of the second array indicates there is more data to come), then
     * it means the results are not complete due to response size constraints and the caller should call the method again.
     * @exception DirectoryServiceException if there is a problem accessing the underlying storage or the directory does not exist
     */
    public Object[] reconcileCache(String containerID, Short[] versionInfo, Long callerBackupVersion, IElementIdentity[] identities, HashMap deletedConfs, String dirNames[], HashMap logicalMap)
    throws MFException
    {
        ContainerCompatibility.addContainer(containerID, versionInfo[0].shortValue(), versionInfo[1].shortValue(), versionInfo[2].shortValue(), versionInfo[3].shortValue());
        if (m_ds.areNotificationsSuspended(containerID))
        {
        	// check if notifications should be turned back on. That would
        	// happen if this is the first call to reconcileCache after
        	// container startup after an upgrade.
        	if (versionInfo[0].shortValue() == Version.getMajorVersion() &&
        			versionInfo[1].shortValue() == Version.getMinorVersion() &&
        			versionInfo[2].shortValue() == Version.getPointVersion())
            {
                m_ds.resumeChangeNotifications(containerID);
            }
            else
            {
                return new Object[] {null, null, null};
            }
        }
        trace(TRACE_CONTAINER_ACCESS, containerID + ": reconcile");

        IDirElement[][] cacheElements = getCacheElements(containerID, callerBackupVersion, identities, deletedConfs, dirNames);
        HashMap corrections = null;
        if (logicalMap != null)
        {
            corrections = m_ds.getUpdatedLogicalNames(logicalMap);
        }
        return new Object[] { cacheElements[0], cacheElements[1], corrections };
    }

    private void registerElementSubscriptions(String subscriber, IElementIdentity[] identities, HashMap deletedConfs)
    {
        String[] elementNames = new String[identities.length];
        for (int i = 0; i < identities.length; i++)
        {
            elementNames[i] = identities[i].getName();
        }
        m_registry.subscribe(subscriber, elementNames);

        // register interest in configurations that were deleted but we still want to know if were recreated
        Iterator iterator = deletedConfs.keySet().iterator();
        while (iterator.hasNext())
        {
            m_registry.subscribe(subscriber, (String)iterator.next());
        }
    }

    public HashMap getUpdatedLogicalNames(HashMap names) throws MFException
    {
    	trace(TRACE_CONTAINER_ACCESS,  "getUpdatedLogicalNames");
        validateStarted();
        validateActive();
        return m_ds.getUpdatedLogicalNames(names);
    }

    /**
    * Subscribes to modifications of specific configuration elements or to modifications of any element under a specific directory.
    * The DSComponent guarantees the subscription for the 'duration' period and typically removes it when that period expires.
    * The DSComponent maintains a persistent (saved in the DS) list of all the subscribers that have at least one subscription.
    * That list is used when the DSComponent starts up - each subscriber gets a start-up notification. The subscribers must renew their
    * subscriptions periodically (that period must be sufficiently  smaller then the 'duration' parameter). The subscribers
    * also must renew their subscriptions when they get a startup notification from the the DSComponent.
    *
    */
    public Long subscribe(String subscriber, String[] dirAndEntitieNames) throws MFException
    {
    	trace(TRACE_CONTAINER_ACCESS, subscriber + ": subscribe");

        if ((super.m_traceMask & IComponent.TRACE_VERBOSE) > 0)
        {
            for (int i = 0; i < dirAndEntitieNames.length; i++)
            {
                trace(TRACE_ALL_DS_ACCESS,dirAndEntitieNames[i]);
            }
        }

        validateStarted();
        validateActive();
        m_registry.subscribe(subscriber, dirAndEntitieNames);
        return new Long(m_ds.getBackupTimestamp());
    }

    public Integer getDirectoryServiceVersion()
    {
        return new Integer(DirectoryService.DS_API_VERSION);
    }

    public String getDirectoryServiceReleaseVersion()
    {
        return m_ds.getDirectoryServiceReleaseVersion();
    }

    public IView getView() throws MFException
    {
        validateStarted();
        validateActive();
        IView view = m_ds.getView();
        // READ permission checked after the action
        configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, null, false);
        return view;
    }

    public IView setView(IDeltaView view) throws MFException
    {
        validateStarted();
        validateActive();
        configurePermissionWriteCheck(MF_DIR_SEPARATOR_STRING, null, false);
        return m_ds.setView(view);
    }

    public INextVersionToken setViewGetToken(IDeltaView view) throws MFException
    {
        validateStarted();
        validateActive();
        configurePermissionWriteCheck(MF_DIR_SEPARATOR_STRING, null, false);
        return m_ds.setViewGetToken(view);
    }


    public String exportElementToXML(String elementName) throws MFException
    {
        validateStarted();
        validateActive();
        String xml = m_ds.exportElementToXML(elementName);
        // READ check after the action
        String logicalName = m_ds.storageToLogical(elementName);

        if (logicalName != null)
        {
            configurePermissionReadCheck(logicalName, elementName, true);
        }
        else
        {
            configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, elementName, false);
        }

        return xml;
    }

    public String exportDSBootFileString(String elementName) throws MFException
    {
    	validateStarted();
        validateActive();
        String xml = m_ds.exportDSBootFileString(elementName);
        // READ check after the action
        String logicalName = m_ds.storageToLogical(elementName);

        if (logicalName != null)
        {
            configurePermissionReadCheck(logicalName, elementName, true);
        }
        else
        {
            configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, elementName, false);
        }

        return xml;
    }

    public String exportDirectoryToXML(String dirName) throws MFException
    {
        validateStarted();
        validateActive();
        return m_ds.exportDirectoryToXML(dirName);
    }

    public void dumpContentsToXML()
    {
        validateStarted();
        validateActive();
        m_ds.dumpContentsToXML();
    }

    public void importFromXML(String XMLDocument) throws MFException
    {
        validateStarted();
        validateActive();
        m_ds.importFromXML(XMLDocument);
    }

    public Boolean leaseLock(String lockName, String key, Integer leaseDuration) throws MFException
    {
        if (leaseDuration.intValue() == 0)
        {
            throw new IllegalArgumentException("Lease duration must be > 0");
        }

        validateStarted();

        // the active DS needs to make best attempts to replicate the lock to the standby .. it does this
        // by sending a negative value to the standby .. thus we only check for active on positive values
        if (leaseDuration.intValue() < 0)
        {
            leaseDuration = new Integer(0 - leaseDuration.intValue());
        }
        else
        {
            validateActive();
        }

        Boolean leased = new Boolean(m_lockManager.leaseLock(lockName, key, (leaseDuration.intValue() * 1000)));

        // if this DS is fault tolerant and active make some attempt to replicate the lease to the
        // fault tolerant partner .. however its not critical that the call get through
        if (!m_isNotFaultTolerant &&
            m_faultToleranceStateManager.getState(null) == IFaultTolerantState.STATE_ACTIVE && leased.booleanValue())
        {
            try
            {
                super.m_frameworkContext.invoke(m_FTpartnerAddress, "leaseLock",
                                                new Object[] { lockName, key, new Integer(0 - leaseDuration.intValue()) },
                                                LEASE_LOCK_SIGNATURE, false, 0);
            }
            catch(Exception e) { }
        }

        return leased;
    }

    public void releaseLock(String lockName, String key) throws MFException
    {
        validateStarted();

        m_lockManager.releaseLock(lockName, key);
    }

    @Override
    public Class loadClass(String className, String classpath)
    throws Exception
    {
        URL[] applicationURLs = URLUtility.classpathToURLArray(classpath, IContainer.DS_CLASSPATH_DELIMITER);

        String containerName = m_frameworkContext.getContainer().getContainerIdentity().getCanonicalName();

        // create a unique class loader for this class and load the class
        ClassLoader classLoader = ClassLoaderFactory.createDelegatingLoader(containerName, className, applicationURLs, m_sharedLoader, new String[] { "$MQclient" });
        return Class.forName(className, false, classLoader);
    }
    
    @Override
    public void logMessage(String message, int severityLevel)
    {
        if (super.m_context != null)
        {
            super.m_context.logMessage(message, severityLevel);
        }
    }

    @Override
    public void logMessage(String message, Throwable throwable, int severityLevel)
    {
        if (super.m_context != null)
        {
            super.m_context.logMessage(message, throwable, severityLevel);
        }
    }

    public void trace(int mask, String message)
    {
        if ((super.m_traceMask & mask) > 0 && super.m_context != null)
        {
            super.m_context.logMessage(message, Level.TRACE);
        }
    }
    
    public void trace(int mask, String message, Throwable throwable)
    {
        if ((super.m_traceMask & mask) > 0 && super.m_context != null)
        {
            super.m_context.logMessage(message, throwable, Level.TRACE);
        }
    }
    
    private void validateStarted() throws DSNotStartedException
    {
        if (m_state != IComponentState.STATE_ONLINE)
        {
            throw new DSNotStartedException("The Directory Service is not started.");
        }
    }

    private void validateActive()
    {
        if (!m_isNotFaultTolerant && m_faultToleranceStateManager.getState(null) != IFaultTolerantState.STATE_ACTIVE)
        {
            throw new MFServiceNotActiveException('[' + m_faultToleranceRole + "] Directory Service not active");
        }
    }

    private MFRuntimeException createMFRuntimeException(Exception e)
    {
        MFRuntimeException mfe = new MFRuntimeException(e.toString());
        mfe.setLinkedException(e);
        return mfe;
    }

    private class DSListener implements IArrayElementNotificationListener
    {
        private HashMap queuedChangeSenders = new HashMap();
        private DSListener() { }

        @Override
        public void elementsChanged(IBasicElement[] elements)
        {
            elementsChanged(elements, null);
        }

        @Override
        public void elementsChanged(IDirElement[] elements)
        {
            // First take care of subscribers that subscribed for the whole directory
            HashMap handledDirSubscribers = internalElementsChanged(elements);

            // Now take care of subscribers that subscribed of individual elements and JMX subscribers
            elementsChanged(elements, handledDirSubscribers);
        }

        private HashMap internalElementsChanged(final IDirElement[] elements)
        {
            if (elements == null || elements.length == 0)
            {
                return null;
            }

            HashMap handledDirSubscribers = new HashMap();

            String parentDir = getParentName(elements[0].getIdentity().getName());
            if (parentDir.startsWith(HIERARCHICAL_TYPES_PATH))
            {
                try
                {
                    readHierarchicalTypes();
                }
                catch (DirectoryServiceException dirE)
                {
                    m_context.logMessage("Failed to refresh hierarchical types: " + dirE.getMessage(),Level.SEVERE);
                }
            }
            String[] dirSubscribers = m_registry.getSubscribers(parentDir);
            final boolean debugNotifications = (m_traceMask & IDebuggingMasks.TRACE_CONFIGURATION_NOTIFICATIONS) > 0;

            for (int i = 0; i < dirSubscribers.length; i++)
            {
                handledDirSubscribers.put(dirSubscribers[i], Boolean.TRUE);

                if ((m_traceMask & IComponent.TRACE_VERBOSE) > 0)
                {
                    trace(IDebuggingMasks.TRACE_CONFIGURATION_NOTIFICATIONS, "Queue notify \"" + dirSubscribers[i] + "\" about \"" + parentDir + "\" directory modifications.");
                }

                final String subscriber = dirSubscribers[i];
                Runnable changeSender = new Runnable()
                {
                    @Override
                    public void run()
                    {
                        DSComponent.this.sendChangedElements(elements, subscriber, debugNotifications);
                    }
                };
                queueChangeSender(subscriber, changeSender);
            }

            return handledDirSubscribers;

        }

        private void elementsChanged(IBasicElement[] elements, HashMap handledDirSubscribers)
        {
            if (elements == null || elements.length == 0)
            {
                return;
            }
            final boolean debugNotifications = (m_traceMask & IDebuggingMasks.TRACE_CONFIGURATION_NOTIFICATIONS) > 0;

            // notify management application listeners
            sendElementChangeNotification(elements);
            String groupParent = null;

            // map of subscribers that can handle multiple changed elements in
            // a single bulk call
            HashMap batchSubscribers = new HashMap();

            // notify interested containers
            for (int i = 0; i < elements.length; i++)
            {
                String elementName = elements[i].getIdentity().getName();
                String parentDir = getParentName(elementName);
                if (parentDir.startsWith(HIERARCHICAL_TYPES_PATH))
                {
                    try
                    {
                        readHierarchicalTypes();
                    }
                    catch (DirectoryServiceException dirE)
                    {
                        m_context.logMessage("Failed to refresh hierarchical types: " + dirE.getMessage(),Level.SEVERE);
                    }
                }
                if (handledDirSubscribers != null)
                {
                    if (groupParent != null && !groupParent.equals(parentDir))
                    {
                        String message = "IllegalStateException: All the elements of the group must be under the same directory.";
                        m_context.logMessage(message, Level.SEVERE);
                        throw new IllegalStateException(message);
                    }
                    else if (groupParent == null)
                    {
                        groupParent = parentDir;
                    }

                }

                String[] elementSubscribers = m_registry.getSubscribers(elementName);
                String[] dirSubscribers = m_registry.getSubscribers(parentDir);
                HashMap elementSubscribersTable = new HashMap();
                for (int i1 = 0; i1 < elementSubscribers.length; i1++)
                {
                    // Did we already send a group notification to this subscriber?
                    if (handledDirSubscribers != null && handledDirSubscribers.get(elementSubscribers[i1]) != null)
                    {
                        continue;
                    }

                    // Remember the subscriber so we don't send the modification again when processing dirSubscribers below
                    elementSubscribersTable.put(elementSubscribers[i1], elementSubscribers[i1]);

                    ArrayList notifs = (ArrayList)batchSubscribers.get(elementSubscribers[i1]);
                    if (notifs == null)
                    {
                        notifs = new ArrayList();
                        batchSubscribers.put(elementSubscribers[i1], notifs);
                    }
                    notifs.add(elements[i]);
                }

                // Subscribers for the whole directory where already taken care of
                if (handledDirSubscribers != null)
                {
                    continue;
                }

                for (int i1 = 0; i1 < dirSubscribers.length; i1++)
                {
                    if (!elementSubscribersTable.containsKey(dirSubscribers[i1]))
                    {
                        ArrayList notifs = (ArrayList)batchSubscribers.get(dirSubscribers[i1]);
                        if (notifs == null)
                        {
                            notifs = new ArrayList();
                            batchSubscribers.put(dirSubscribers[i1], notifs);
                        }
                        notifs.add(elements[i]);
                    }
                }
            }

            // are there any v6.1 or greater subscribers .. if so then send them bulk
            // updates
            Iterator iterator = batchSubscribers.entrySet().iterator();
            while (iterator.hasNext())
            {
                Map.Entry entry = (Map.Entry)iterator.next();
                final String subscriber = (String)entry.getKey();
                IBasicElement[] updatedElements = (IBasicElement[])((ArrayList)entry.getValue()).toArray(EMPTY_ELEMENT_ARRAY);
                if ((m_traceMask & IComponent.TRACE_VERBOSE) > 0)
                {
                    StringBuffer sb = new StringBuffer("Notify " + subscriber + " about:");
                    sb.append(IContainer.NEWLINE);
                    for (int i = 0; i < updatedElements.length; i++)
                    {
                        sb.append(IContainer.NEWLINE).append('\t').append(updatedElements[i]);
                    }
                    sb.append(IContainer.NEWLINE);
                    trace(IDebuggingMasks.TRACE_CONFIGURATION_NOTIFICATIONS, sb.toString());
                }

                // if we have too much data we should break it down into smaller chunks (SizedArrayList.MAXIMUM_CONTENT_SIZE) for sending
                SizedArrayList updateList = new SizedArrayList();
                for (int i = 0; i < updatedElements.length;)
                {
                    updateList.add(updatedElements[i]);
                    // replacement envelope should be delivered with the deleted but recreated envelope irrespective of current size
                    if (updatedElements[i] instanceof IEnvelope && ((IEnvelope)updatedElements[i]).getProperty(IEnvelope.DELETED_BUT_RECREATED_LABEL) != null
                        && (i+1 < updatedElements.length))
                    {
                        updateList.add(updatedElements[++i]);
                    }
                    i++;
                    if (i == updatedElements.length || updateList.getEstimatedContentSize() > SizedArrayList.MAXIMUM_CONTENT_SIZE)
                    {
                        final SizedArrayList list = updateList;
                        Runnable changeSender = new Runnable()
                        {
                            @Override
                            public void run()
                            {
                                DSComponent.this.sendChangedElements((IBasicElement[])list.toArray(EMPTY_ELEMENT_ARRAY), subscriber, false, debugNotifications);
                            }
                        };
                        queueChangeSender(subscriber, changeSender);
                        if (i < updatedElements.length)
                        {
                            updateList = new SizedArrayList();
                        }
                    }
                }
            }
        }

        private String getParentName(String name)
        {
             EntityName eName = null;
             try
             {
                 eName = new EntityName(name);
             }
             catch(ConfigException e)
             {
                 throw new Error(e.toString());
             }

             return eName.getParent();
        }

        private void queueChangeSender(String subscriber, Runnable changeSender)
        {
            synchronized(this.queuedChangeSenders)
            {
                SenderManager manager = (SenderManager)this.queuedChangeSenders.get(subscriber);
                if (manager == null)
                {
                    manager = new SenderManager();
                    manager.subscriber = subscriber;
                    this.queuedChangeSenders.put(subscriber, manager);
                    DSComponent.this.m_context.scheduleTask(manager, new Date());
                }
                manager.changeSenders.add(changeSender);
            }
        }

        private class SenderManager
        implements Runnable
        {
            private ArrayList changeSenders = new ArrayList();
            private String subscriber;

            @Override
            public void run()
            {
                Runnable changeSender = null;
                while (true)
                {
                    synchronized(DSListener.this.queuedChangeSenders)
                    {
                        if (changeSenders.isEmpty())
                        {
                            DSListener.this.queuedChangeSenders.remove(subscriber);
                            break;
                        }
                        changeSender = (Runnable)changeSenders.remove(0);
                    }
                    changeSender.run();
                }
            }
        }

        private void sendElementChangeNotification(IBasicElement[] elements)
        {
            INotification notification =
                m_context.createNotification(INotification.CONFIGURATION_CATEGORY, INotification.SUBCATEGORY_TEXT[INotification.STORAGE_SUBCATEGORY], CHANGE_NOTIFICATION_TYPE, Level.CONFIG);
            notification.setLogType(INotification.INFORMATION_TYPE);
            notification.setAttribute("Elements", elements);
            DSComponent.super.m_context.sendNotification(notification);

           // send notifications to those listening for FS notifications (if FS interface is used)
           if (m_ds.isFSInterfaceInUse())
           {
                IBasicElement[] elements1 = m_ds.translateElementsToLogical(elements);
                INotification fsNotification =
                    m_context.createNotification(INotification.CONFIGURATION_CATEGORY, INotification.SUBCATEGORY_TEXT[INotification.STORAGE_SUBCATEGORY], FSCHANGE_NOTIFICATION_TYPE, Level.CONFIG);
                fsNotification.setLogType(INotification.INFORMATION_TYPE);
                fsNotification.setAttribute("Elements", elements1);
                DSComponent.super.m_context.sendNotification(fsNotification);
           }
        }
    }

    private class DSNamingListener implements INamingListener
    {
        @Override
        public void onNotification(INamingNotification notification)
        {
            ArrayList notifications = new ArrayList();
            notifications.add(notification);
            onNotifications(notifications);
        }

        @Override
        public void onNotifications(ArrayList notifications)
        {
            ArrayList renameNotifications = new ArrayList();
            HashSet interestedContainers = updateLogicalRegistry(notifications, renameNotifications);
            sendLogicalRenamings(renameNotifications, (String[])interestedContainers.toArray(IEmptyArray.EMPTY_STRING_ARRAY));

            INotification fsNotification =
                m_context.createNotification(INotification.CONFIGURATION_CATEGORY, INotification.SUBCATEGORY_TEXT[INotification.STORAGE_SUBCATEGORY], NAMING_NOTIFICATION_TYPE, Level.CONFIG);
            fsNotification.setLogType(INotification.INFORMATION_TYPE);
            fsNotification.setAttribute("Elements", notifications);
            DSComponent.super.m_context.sendNotification(fsNotification);
        }
    }

    // Send renaming notifications to interested subscribers (containers)
    private void sendLogicalRenamings(ArrayList notifications, String[] interestedContainers)
    {
        if (interestedContainers.length == 0)
        {
            return;
        }

        IDirElement notificationElement =  ElementFactory.createElement(DS_RENAMING_ELEMENT, "renaming notification", "2.0");
        IAttributeSet attributes = notificationElement.getAttributes();

        // Serialize the notifications and set the element
        try
        {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream objectOut = new ObjectOutputStream(out);
            objectOut.writeObject(notifications);
            byte[] notificationsBytes = out.toByteArray();
            objectOut.close();

            attributes.setBytesAttribute("notifications", notificationsBytes);
        }
        catch (Exception e)
        {
            throw new Error(); //Should never happen
        }


        //Send to containers
        for (int i = 0; i < interestedContainers.length; i++)
        {
            DSComponent.this.sendChangedElement(notificationElement, interestedContainers[i], false,
                                         (DSComponent.super.m_traceMask & IDebuggingMasks.TRACE_CONFIGURATION_NOTIFICATIONS) > 0 );
        }

    }

    // Update the logical-names-to-subscribers map and return the set of interested containers and filter out
    // all the non renaming notifications (put renaming notifications in renameNotifications)
    private HashSet updateLogicalRegistry(ArrayList notifications, ArrayList renameNotifications)
    {
        HashSet interestedContainers = new HashSet();
        for (int i = 0; i < notifications.size(); i++)
        {
            INamingNotification notification = (INamingNotification)notifications.get(i);
            if (notification instanceof IFolderDeleteNotification || notification instanceof IElementDeleteNotification)
            {
                m_registry.deleteLogicalPath(notification.getName());
            }
            else if (notification instanceof IRenameNotification)
            {
                interestedContainers.addAll(m_registry.renameLogicalPath(((IRenameNotification)notification).getName(),
                                                                          ((IRenameNotification)notification).getNewName()));
                renameNotifications.add(notification);
            }

            // We ignore all the other notifications (such as new elements and folders) since new entries are added to the registry
            // through the addLogicalSubscriber calls at getElementByLogicalName
        }
        return interestedContainers;
    }

    /*****************************************************************************************************
     ******************************* IDirectoryFileSystemService methods *********************************
     *****************************************************************************************************/

    public void defineFolderMetaAttributes(String[] attributeNames) throws MFException
    {
        validateStarted();
        validateActive();
        configurePermissionWriteCheck(MF_DIR_SEPARATOR_STRING, null, false);
        m_ds.defineFolderMetaAttributes(attributeNames);
    }

    public String[] getDefinedFolderMetaAttributes() throws MFException
    {
        validateStarted();
        validateActive();
        String [] attributes = m_ds.getDefinedFolderMetaAttributes();
        // read operation, so check permissions after the get
        configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, null, false);
        return attributes;
    }

    public void defineElementMetaAttributes(String[] attributeNames) throws MFException
    {
        validateStarted();
        validateActive();
        configurePermissionWriteCheck(MF_DIR_SEPARATOR_STRING, null, false);
        m_ds.defineElementMetaAttributes(attributeNames);
    }

    public String[] getDefinedElementMetaAttributes() throws MFException
    {
        validateStarted();
        validateActive();
        //read operation, so check permissions after the get
        String [] attributes = m_ds.getDefinedElementMetaAttributes();
        configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, null, false);
        return attributes;
    }

    public void rename(String oldPath, String newPath) throws MFException
    {
        validateStarted();
        validateActive();
        SharedPermissionChecks checks = new SharedPermissionChecks(getContext(), m_ds);
        checks.renameCheck(oldPath, newPath);
        m_ds.rename(oldPath, newPath);
    }

    public void renameFolder(String oldPath, String newPath) throws MFException
    {
        validateStarted();
        validateActive();

        m_ds.renameFolder(oldPath, newPath);
    }

    public void renameFile(String oldPath, String newPath) throws MFException
    {
        validateStarted();
        validateActive();

        m_ds.renameFile(oldPath, newPath);
    }

    public void createFolder(String folderPath) throws MFException
    {
        validateStarted();
        validateActive();
        (new SharedPermissionChecks(getContext(), m_ds)).createFolderCheck(folderPath, false);
        m_ds.createFolder(folderPath);
    }

    public void createFolder(String folderPath, Boolean existingOk) throws MFException
    {
        validateStarted();
        validateActive();
        (new SharedPermissionChecks(getContext(), m_ds)).createFolderCheck(folderPath, existingOk.booleanValue());
        m_ds.createFolder(folderPath, existingOk.booleanValue());
    }

    public void copyFiles(String fromPath, String toPath) throws MFException
    {
        validateStarted();
        validateActive();

        try
        {

            ExtendedSonicFSFileSystem extendedFS = new ExtendedSonicFSFileSystem(m_ds, null, null);

            String canonicalFrom = extendedFS.getCanonical(fromPath);
            String canonicalTo = extendedFS.getCanonical(toPath);
            String canonicalToParent = canonicalTo.equals("/") ? null : extendedFS.getParent(canonicalTo);

            SonicFSFile fromFile = extendedFS.getFileDetails(canonicalFrom);
            SonicFSFile toFile = extendedFS.getFileDetails(canonicalTo);
            SonicFSFile toParentFile = null;
            if (canonicalToParent != null)
            {
                toParentFile = extendedFS.getFileDetails(canonicalToParent);
            }


            if (fromFile != null)
            {
                SonicFSFile[] files = extendedFS.deepListDetails(canonicalFrom);
                for (int i = 0; i < files.length; i++)
                {
                    SonicFSFile file = files[i];
                    String checkPath = file.getFullName();
                    if (file.isDirectory())
                    {
                        if (!checkPath.endsWith(MF_DIR_SEPARATOR_STRING))
                        {
                            checkPath += MF_DIR_SEPARATOR_STRING;
                        }
                    }
                    configurePermissionReadCheck(checkPath, null, true);
                }
            }


            if (toFile  != null)
            {
                if (toFile.isFile())
                {
                    configurePermissionDeleteCheck(canonicalTo, null, true);
                    configurePermissionWriteCheck(canonicalToParent, null, true);
                }
                else
                {
                    String checkPath = canonicalTo;
                    if (!checkPath.endsWith(MF_DIR_SEPARATOR_STRING))
                    {
                        checkPath += MF_DIR_SEPARATOR_STRING;
                    }
                    configurePermissionWriteCheck(checkPath, null, true);
                }
            }
            else if (toParentFile != null)
            {
                String checkPath = canonicalToParent;
                if (!checkPath.endsWith(MF_DIR_SEPARATOR_STRING))
                {
                    checkPath += MF_DIR_SEPARATOR_STRING;
                }
                configurePermissionWriteCheck(checkPath, null, true);
            }
        }
        catch (Exception e)
        {
            throw new MFException(e.toString());
        }

        try
        {
            m_ds.copyFiles(fromPath,  toPath);
        }
        catch (DirectoryServiceException e)
        {
            throw new MFException(e.toString());
        }
    }

    public void deleteFolder(String folderPath) throws MFException
    {
        validateStarted();
        validateActive();
        (new SharedPermissionChecks(getContext(), m_ds)).deleteFolderCheck(folderPath);
        m_ds.deleteFolder(folderPath);
    }

    public HashMap[] listFolders(String folderPath) throws MFException
    {
        validateStarted();
        validateActive();
        HashMap[] folders = m_ds.listFolders(folderPath);
        // now do the ALLOW_READ check
        String checkFolderName = folderPath;
        if (!checkFolderName.endsWith(MF_DIR_SEPARATOR_STRING))
        {
            checkFolderName = checkFolderName + MF_DIR_SEPARATOR_STRING;
        }
        configurePermissionReadCheck(checkFolderName, null, true);
        return folders;
    }

    public HashMap[] listAllFolders() throws MFException
    {
        validateStarted();
        validateActive();
        HashMap[] allFolders = m_ds.listAllFolders();
        // now check the permissions of the parent folders
        ArrayList prunedList = new ArrayList();
        for (int i=0; i<allFolders.length; i++)
        {
            HashMap folder = allFolders[i];
            String folderName = (String)folder.get(ILogicalNameSpace.FOLDER_NAME);
            if (folderName.equals(MF_DIR_SEPARATOR_STRING))
            {
                prunedList.add(folder);
            }
            else
            {
                EntityName folderEName;
                try
                {
                    folderEName = new EntityName(folderName);
                }
                catch (Exception e)
                {
                    throw new DirectoryServiceException("Unable to check permissions for " + folderName);
                }
                String parentFolder = folderEName.getParent();
                try
                {
                    if (parentFolder.equals(MF_DIR_SEPARATOR_STRING))
                    {
                        configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, null, true);
                    }
                    else
                    {
                        configurePermissionReadCheck(parentFolder + MF_DIR_SEPARATOR_STRING, null, true);
                    }
                    prunedList.add(folder);
                }
                catch (ConfigurePermissionDeniedException denied)
                {
                }
            }
        }
        HashMap[] prunedFolders = new HashMap[prunedList.size()];
        prunedList.toArray(prunedFolders);
        return prunedFolders;
    }

    public HashMap[] listFSAll(String path) throws MFException
    {
        return listFSAll(path, true, null);
    }

    public HashMap[] listFSAll(String path, Boolean getFolders, String extension)
    throws MFException
    {
        validateStarted();
        validateActive();
        HashMap[] all = m_ds.listFSAll(path, getFolders.booleanValue(), extension);
        //now check ALLOW_READ on the folder
        String checkFolderName = path;
        if (!checkFolderName.endsWith(MF_DIR_SEPARATOR_STRING))
        {
            checkFolderName = checkFolderName + MF_DIR_SEPARATOR_STRING;
        }
        configurePermissionReadCheck(checkFolderName, null, true);
        return all;
    }

    // optimized version of this method; it does not call the corresponding
    // DirectorySErvice method so it can check management permissions as it is recursing
    // as the primary use of this method is from SonicFSFileSystem, it does not recurse
    // folders which represent configurations
    public ArrayList<HashMap> recursiveList(String path, Boolean getFolders, Boolean getElements, String extension)
    throws MFException
    {
        validateStarted();
        validateActive();
        ArrayList<HashMap> recursiveResult = new ArrayList<HashMap>();
        try
        {
            String checkFolderName = path;
            if (!checkFolderName.endsWith(MF_DIR_SEPARATOR_STRING))
            {
                checkFolderName = checkFolderName + MF_DIR_SEPARATOR_STRING;
            }
            configurePermissionReadCheck(checkFolderName, null, true);
        }
        catch (ConfigurePermissionDeniedException denied)
        {
            return recursiveResult;
        }

        HashMap pathAttributes = getMetaAttributes(path);
        if (pathAttributes.get(ILogicalNameSpace.FOLDER_NAME) == null)
         {
            throw new MFException(path + " is not a folder name");
        //recursiveResult.add(pathAttributes);
        }

        ArrayList<HashMap> localResult = m_ds.listFSAll(path, true, true, extension);

        for (HashMap childMap : localResult)
        {
            String folderName = (String)childMap.get(ILogicalNameSpace.FOLDER_NAME);
            IElementIdentity elementID = (IElementIdentity)childMap.get(ILogicalNameSpace.ELEMENT_IDENTITY);
            if (folderName != null)
            {
                boolean isRealFolder = isRealFolder(childMap);
                if (getFolders && isRealFolder)
                {
                    recursiveResult.add(childMap);
                }

                if (isRealFolder)
                {
                    recursiveResult.addAll(recursiveList(folderName, getFolders, getElements, extension));
                }
            }
            else if (getElements)
            {
                recursiveResult.add(childMap);
            }
        }
        return recursiveResult;
    }

    // The SonicFSFileSystem folder definition, used in recursiveList
    private boolean isRealFolder(Map map)
    {
        try
        {
            Map res = Util.splitToolMetaAttributes(map);

            return (!(res.containsKey(IConfigServer.FOLDER_NAME) &&
                      res.containsKey(ConfigServerUtility.TYPE)));
        }
        catch (Exception e)
        {
        }

        return false;
    }

    public HashMap[] listFSElements(String folderPath) throws MFException
    {
        validateStarted();
        validateActive();
        HashMap[] elements =  m_ds.listFSElements(folderPath);
        //now check ALLOW_READ on the folder
        String checkFolderName = folderPath;
        if (!checkFolderName.endsWith(MF_DIR_SEPARATOR_STRING))
        {
            checkFolderName = checkFolderName + MF_DIR_SEPARATOR_STRING;
        }
        configurePermissionReadCheck(checkFolderName, null, true);
        return elements;
    }

    public void setMetaAttributes(String path, HashMap attributes) throws MFException
    {
        validateStarted();
        validateActive();
        (new SharedPermissionChecks(getContext(), m_ds)).setMetaAttributesCheck(path);
        m_ds.setMetaAttributes(path, attributes);
    }

    public HashMap getMetaAttributes(String path) throws MFException
    {
        validateStarted();
        validateActive();
        HashMap attrs =  m_ds.getMetaAttributes(path);
        // now check ALLOW_READ
        if (attrs != null)
        {
            String checkName;
            if (attrs.get(ILogicalNameSpace.FOLDER_NAME) != null && !path.endsWith(MF_DIR_SEPARATOR_STRING))
            {
                checkName = path + MF_DIR_SEPARATOR_STRING;
            }
            else
            {
                checkName = path;
            }
            configurePermissionReadCheck(checkName, null, true);
        }
        return attrs;

    }

    public void setStorageHint(String elementType, String directoryPath) throws MFException
    {
        validateStarted();
        validateActive();
        configurePermissionWriteCheck(MF_DIR_SEPARATOR_STRING, null, false);
        m_ds.setStorageHint(elementType,directoryPath);
    }

    public void setStorageHint(String elementType, String postfix, String directoryPath) throws MFException
    {
        validateStarted();
        validateActive();
        configurePermissionWriteCheck(MF_DIR_SEPARATOR_STRING, null, false);
        m_ds.setStorageHint(elementType, postfix, directoryPath);
    }

    public void setComplexStorageHint(String elementType, String directoryPath) throws MFException
    {
        validateStarted();
        validateActive();
        configurePermissionWriteCheck(MF_DIR_SEPARATOR_STRING, null, false);
        m_ds.setComplexStorageHint(elementType, directoryPath);
    }

    public void setBackReferenceTypes(String[] types) throws MFException
    {
        validateStarted();
        validateActive();
        // the back references element gets removed and recreated in this method,
        // so check both ALLOW_WRITE and ALLOW_DELETE
        configurePermissionWriteCheck(MF_DIR_SEPARATOR_STRING, null, false);
        configurePermissionDeleteCheck(MF_DIR_SEPARATOR_STRING, null, false);
        m_ds.setBackReferenceTypes(types);
    }

    public IDirElement[] getFSElements(com.sonicsw.mf.common.config.query.Query query, Boolean forUpdate, Boolean getSubclassingDelta) throws MFException
    {
        validateStarted();
        validateActive();

        IDirElement[] elements = m_ds.getFSElements(query, forUpdate.booleanValue(), getSubclassingDelta.booleanValue());
        // now check ALLOW_READ and prune the list
        ArrayList prunedList = new ArrayList();
        IDirElement[] prunedElements;
        for (int i=0; i<elements.length; i++)
        {
            try
            {
                String storageName = elements[i].getIdentity().getName();
                configurePermissionReadCheck(storageName, null, true);
                prunedList.add(elements[i]);
            }
            catch (ConfigurePermissionDeniedException denied)
            {
                continue;
            }
        }
        prunedElements = new IDirElement[prunedList.size()];
        prunedList.toArray(prunedElements);
        return prunedElements;
    }

    public QueryBatch getFSElements(com.sonicsw.mf.common.config.query.Query query, Boolean forUpdate, Boolean getSubclassingDelta,
    		com.sonicsw.mf.common.config.query.QueryBatch qb) throws MFException
    {
        validateStarted();
        validateActive();

        IDirElement[] elements = m_ds.getFSElements(query, forUpdate.booleanValue(), getSubclassingDelta.booleanValue(), qb).getElements();
        // now check ALLOW_READ and prune the list
        ArrayList prunedList = new ArrayList();
        IDirElement[] prunedElements;
        for (int i=0; i<elements.length; i++)
        {
            try
            {
                String storageName = elements[i].getIdentity().getName();
                configurePermissionReadCheck(storageName, null, true);
                prunedList.add(elements[i]);
            }
            catch (ConfigurePermissionDeniedException denied)
            {
                continue;
            }
        }
        prunedElements = new IDirElement[prunedList.size()];
        prunedList.toArray(prunedElements);
        return new QueryBatch(prunedElements, qb);
    }

    public IDirElement[] getFSElements(com.sonicsw.mf.common.config.query.Query query, Boolean forUpdate) throws MFException
    {
        validateStarted();
        validateActive();
        IDirElement[] elements = m_ds.getFSElements(query, forUpdate.booleanValue());
        // now return only those that the user can see
        ArrayList prunedList = new ArrayList();
        IDirElement[] prunedElements;
        for (int i=0; i<elements.length; i++)
        {
            try
            {
                String storageName = elements[i].getIdentity().getName();
                configurePermissionReadCheck(storageName, null, true);
                prunedList.add(elements[i]);
            }
            catch (ConfigurePermissionDeniedException denied)
            {
                continue;
            }
        }
        prunedElements = new IDirElement[prunedList.size()];
        prunedList.toArray(prunedElements);
        return prunedElements;
    }

    public IDirElement getFSElement(String elementPath, Boolean forUpdate) throws MFException
    {
        validateStarted();
        validateActive();
        IDirElement el = m_ds.getFSElement(elementPath, forUpdate.booleanValue());
        // now check ALLOW_READ
        configurePermissionReadCheck(elementPath, null, true);
        return el;
    }

    public IDirElement[] getFSElements(String folderPath, Boolean forUpdate) throws MFException
    {
        validateStarted();
        validateActive();
        IDirElement[] elements =  m_ds.getFSElements(folderPath, forUpdate.booleanValue());
        //now return only those that the user can see
        ArrayList prunedList = new ArrayList();
        IDirElement[] prunedElements;
        for (int i=0; i<elements.length; i++)
        {
            try
            {
                String storageName = elements[i].getIdentity().getName();
                configurePermissionReadCheck(storageName, null, true);
                prunedList.add(elements[i]);
            }
            catch (ConfigurePermissionDeniedException denied)
            {
                continue;
            }
        }
        prunedElements = new IDirElement[prunedList.size()];
        prunedList.toArray(prunedElements);
        return prunedElements;
    }

    public IDirElement getFSElement(String elementPath, Boolean forUpdate, Boolean getSubclassingDelta) throws MFException
    {
        validateStarted();
        validateActive();
        IDirElement el = m_ds.getFSElement(elementPath, forUpdate.booleanValue(), getSubclassingDelta.booleanValue());
         //now check ALLOW_READ
        configurePermissionReadCheck(elementPath, null, true);
        return el;
    }

    public IElementIdentity getFSIdentity (String elementPath) throws MFException
    {
        validateStarted();
        validateActive();
        IElementIdentity id = m_ds.getFSIdentity(elementPath);
        // now do the ALLOW_READ check

        EntityName eName;
        try
        {
            eName = new EntityName(elementPath);
            String parent = eName.getParent();
            if (!parent.endsWith(MF_DIR_SEPARATOR_STRING))
            {
                parent = parent + MF_DIR_SEPARATOR_STRING;
            }
            configurePermissionReadCheck(parent, null, true);
        }
        catch (ConfigException configE)
        {
            throw new DirectoryServiceException("Unable to check permissions in getFSIdentity for " + elementPath);
        }

        return id;
    }

    public IElementIdentity deleteFSElement(String elementPath) throws MFException
    {
        validateStarted();
        validateActive();
        (new SharedPermissionChecks(getContext(), m_ds)).deleteFSElementCheck(elementPath);
        return m_ds.deleteFSElement(elementPath);
    }

    public INextVersionToken createFSElement(IDirElement element) throws MFException
    {
        validateStarted();
        validateActive();
        (new SharedPermissionChecks(getContext(), m_ds)).createFSElementsCheck(new IDirElement[]{element});
        return m_ds.createFSElement(element);
    }

    public INextVersionToken updateFSElement(IDeltaDirElement element) throws MFException
    {
        validateStarted();
        validateActive();
        (new SharedPermissionChecks(getContext(), m_ds)).updateFSElementCheck(element.getIdentity().getName());
        return m_ds.updateFSElement(element);
    }

    public IDirElement cloneFSBlob(String elementPath, String newElementPath) throws MFException
    {
        validateStarted();
        validateActive();
        configurePermissionReadCheck(elementPath, elementPath, true);
        EntityName newEName;
        try
        {
            newEName = new EntityName(newElementPath);
        }
        catch (Exception e)
        {
            throw new DirectoryServiceException("Unable to check permissions while cloning " + elementPath + e.toString());
        }
        String parentFolder = newEName.getParent();
        if (parentFolder.equals(MF_DIR_SEPARATOR_STRING))
        {
            configurePermissionWriteCheck(parentFolder, null, true);
        }
        else
        {
            configurePermissionWriteCheck(parentFolder + IMFDirectories.MF_DIR_SEPARATOR, null, true);
        }
        return m_ds.cloneFSBlob(elementPath, newElementPath);
    }

    public IDirElement cloneFSElement(String elementPath, String newElementPath) throws MFException
    {
        validateStarted();
        validateActive();
        (new SharedPermissionChecks(getContext(), m_ds)).cloneFSElementCheck(elementPath, newElementPath);
        return m_ds.cloneFSElement(elementPath, newElementPath);
    }

    public IDirElement cloneFSElement(IBasicElement delta, String newElementPath) throws MFException
    {
        validateStarted();
        validateActive();
        (new SharedPermissionChecks(getContext(), m_ds)).cloneFSElementCheck(delta.getIdentity().getName(), newElementPath);
        return m_ds.cloneFSElement(delta, newElementPath);
    }

    public IDirElement cloneFSElement(String elementPath, String newElementPath, Boolean createTemplate) throws MFException
    {
        validateStarted();
        validateActive();
        (new SharedPermissionChecks(getContext(), m_ds)).cloneFSElementCheck(elementPath, newElementPath);
        return m_ds.cloneFSElement(elementPath, newElementPath, createTemplate.booleanValue());
    }

    public IDirElement cloneFSElement(IBasicElement delta, String newElementPath, Boolean createTemplate) throws MFException
    {
        validateStarted();
        validateActive();
        (new SharedPermissionChecks(getContext(), m_ds)).cloneFSElementCheck(delta.getIdentity().getName(), newElementPath);
        return m_ds.cloneFSElement(delta, newElementPath, createTemplate.booleanValue());
    }

    public void attachFSBlob(IBasicElement element, byte[] bytes) throws MFException
    {
        validateStarted();
        validateActive();
        // UPDATE operation, so check permissions before updating
        (new SharedPermissionChecks(getContext(), m_ds)).attachFSBlobCheck(element.getIdentity().getName());
        m_ds.attachFSBlob(element, bytes);
    }

    public void appendFSBlob(IBasicElement element, byte[] bytes, Integer offset, Boolean last) throws MFException
    {
        validateStarted();
        validateActive();
        //UPDATE operation, so check permissions before updating
        (new SharedPermissionChecks(getContext(), m_ds)).appendFSBlobCheck(element.getIdentity().getName());
        m_ds.appendFSBlob(element, bytes, offset.intValue(), last.booleanValue());
    }

    // mrd 12/08/2004 A blob is created with an IChunkedBlobStreamer. Before returning the object through
    // the wire, remove the object. The object on the client side will be the streamer.
    public IBlob getFSBlob(String elementPath, Boolean forUpdate) throws MFException
    {
        return getFSBlob(elementPath, forUpdate, new Integer(0));
    }

     public IBlob getFSBlob(String elementPath, Boolean forUpdate, Integer offset) throws MFException
    {
        validateStarted();
        validateActive();
        IBlob blob = null;
        try
        {
          blob = m_ds.getFSBlob(elementPath, forUpdate.booleanValue(), offset.intValue());
        }
        catch (MFException mfE)
        {
            throw mfE;
        }
        catch (Exception e)
        {
            throw new MFException(e.toString());
        }
        // now check ALLOW_READ
        configurePermissionReadCheck(elementPath, null, true);
        return blob;
    }

     public IBlob getFiles(String[] fileNames) throws DirectoryServiceException
     {
         validateStarted();
         validateActive();
         // return only those that you can read
         ArrayList filtered = new ArrayList();
         for (String fileName : fileNames)
         {
             try
             {
                 configurePermissionReadCheck(fileName, fileName, true);
                 filtered.add(fileName);
             }
             catch (Exception e) {continue;} // didn't pass the permissions check
         }
         String[] filteredArray = new String[filtered.size()];
         filtered.toArray(filteredArray);
         return m_ds.getFiles(filteredArray);
     }

     public IBlob getFiles(String path, Boolean recurse, String extension) throws MFException
     {
         validateStarted();
         validateActive();
         ArrayList<HashMap>filesToGet = new ArrayList<HashMap>();

         if (!recurse.booleanValue())
         {
             // we'll use the method in DirectoryService to get one level
             // of children from a folder and returns it as an ArrayList.
             // It does not check permissions so we do it here.
             try
             {
                 String checkFolderName = path;
                 if (!checkFolderName.endsWith(MF_DIR_SEPARATOR_STRING))
                {
                    checkFolderName = checkFolderName + MF_DIR_SEPARATOR_STRING;
                }
                 configurePermissionReadCheck(checkFolderName, null, true);
             }
             catch (ConfigurePermissionDeniedException denied)
             {
                 return getFiles(new String[0]);
             }

             HashMap pathAttributes = getMetaAttributes(path);
             if (pathAttributes.get(ILogicalNameSpace.FOLDER_NAME) == null)
            {
                throw new MFException(path + " is not a folder name");
            }
             filesToGet = m_ds.listFSAll(path, false, true, extension);
         }
        else
        {
            filesToGet = recursiveList(path, false, true, extension);
        }

         String[] filteredArray = new String[filesToGet.size()];
         int arrayIndex = 0;
         for (HashMap map : filesToGet)
        {
            filteredArray[arrayIndex++] = ((IElementIdentity)map.get(ILogicalNameSpace.ELEMENT_IDENTITY)).getName();
        }
         // getFiles will check that you can read the files before zipping them up
         return getFiles(filteredArray);
     }

    public void detachFSBlob(IDeltaDirElement delta) throws MFException
    {
        validateStarted();
        validateActive();
        (new SharedPermissionChecks(getContext(), m_ds)).detachFSBlobCheck(delta.getIdentity().getName());
        m_ds.detachFSBlob(delta);
    }

    public IDirElement subclassFSElement(IBasicElement delta, String newElementPath) throws MFException
    {
        validateStarted();
        validateActive();
        (new SharedPermissionChecks(getContext(), m_ds)).subclassFSElementCheck(delta.getIdentity().getName(), newElementPath);
        return m_ds.subclassFSElement(delta, newElementPath);
    }

    public void unSubclassFSElement(String elementPath) throws MFException
    {
        validateStarted();
        validateActive();
        // ALLOW_WRITE both on the superclass and the element
        IDirElement el = m_ds.getFSElement(elementPath, false);
        String superName = null;
        if (el != null)
        {
            superName = el.getSuperElementName();
            if (superName != null)
            {
                configurePermissionWriteCheck(superName, null, true);
                configurePermissionWriteCheck(elementPath, null, true);
            }
            // else we haven't checked permissions, but the following call will fail anyway
        }
        m_ds.unSubclassFSElement(elementPath);
    }

    public INextVersionToken executeTransaction(IDSTransaction transaction) throws MFException
    {
        validateStarted();
        validateActive();
        return m_ds.executeTransaction(transaction, getContext());
    }

    public String[] getBackReferenceTypes() throws MFException
    {
        validateStarted();
        validateActive();
        return m_ds.getBackReferenceTypes();
    }

    public AttributeName[] getReferences(String elementPath) throws MFException
    {
        validateStarted();
        validateActive();
        AttributeName [] names = m_ds.getReferences(elementPath);
        // ALLOW_READ check after the read
        configurePermissionReadCheck(elementPath, null, true);
        return names;
    }

    public void repairReferences(String[] exclusions) throws MFException
    {
        validateStarted();
        validateActive();
        // must be able to modify all elements in the DS
        // It is assumed that this method is used only in internal tools,
        // although it is exposed in DSProxy
        configurePermissionWriteCheck(MF_DIR_SEPARATOR_STRING, null, false);
        m_ds.repairReferences(exclusions);
    }

    public void rebuildBackReferences() throws MFException
    {
        validateStarted();
        validateActive();
        // ALLOW_DELETE of backRefDir, ALLOW_WRITE of backRefElement
        configurePermissionWriteCheck(MF_DIR_SEPARATOR_STRING, null, false);
        configurePermissionDeleteCheck(MF_DIR_SEPARATOR_STRING, null, false);
        m_ds.rebuildBackReferences();
    }

    public void resetBackReferences() throws MFException
    {
        validateStarted();
        validateActive();
        // should be ALLOW_WRITE on elements under "/", ALLOW_DELETE on both directories and
        // elements under "/"
        configurePermissionWriteCheck(MF_DIR_SEPARATOR_STRING, null, false);
        configurePermissionDeleteCheck(MF_DIR_SEPARATOR_STRING, null, false);
        m_ds.resetBackReferences();
    }

    public IDirElement revertToTemplate(String elementName, AttributeName[] attributes) throws MFException
    {
        validateStarted();
        validateActive();

        configurePermissionWriteCheck(elementName, null, true);

        IDirElement el = m_ds.getFSElement(elementName, false);
        String superClass = null;
        if (el != null)
        {
            superClass = el.getSuperElementName();
        }

        if (superClass != null)
        {
            configurePermissionWriteCheck(superClass, null, true);
        }

        return m_ds.revertToTemplate(elementName, attributes);
    }

    public IDirElement getDomainElement(Boolean forUpdate) throws MFException
    {
        validateStarted();
        validateActive();
        IDirElement el = m_ds.getDomainElement(forUpdate.booleanValue());
        // READ check after the action
        configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, null, false);
        return el;
    }

    public void setDomainElement(IDeltaDirElement element) throws MFException
    {
        validateStarted();
        validateActive();
        configurePermissionWriteCheck(MF_DIR_SEPARATOR_STRING, null, false);
        m_ds.setDomainElement(element);
    }
    
    public String resolveURL(String url)
    {
        validateStarted();
        validateActive();

        // no permissions checking currently
        
        try
        {
            return (String)new URL(url).getContent();
        }
        catch (Exception e)
        {
            this.m_context.logMessage("Failed request to resolve URL \"" + url + "\",  trace follows...", e, Level.WARNING);
            return "";
        }
    }

    /**
     * This method is used by PASS
     * <p>
     * This method return list of External Domain descriptor that have been configured with
     * Management SPI.
     * For Example, one of the element can be <code>/authentication/domains/0/_MFDomainDescriptor </code>
     * <p>
     * @return a string array
     * @throws DirectoryServiceException
     */
    public String[] listExternalDomainWithManagementSPI() throws MFException
    {
        if (Debug.TRACE)
        {
            Debug.trace("calling listExternalDomainWithManagementSPI on the m_ds");

        }

        validateStarted();
        validateActive();

        // weed the return list to those elements for which there is an ALLOW_READ
        // permission on the parent folder (like other list methods) or, if the element
        // has no logical name, check the ALLOW_READ permission on the root
        String[] domainList = m_ds.listExternalDomainWithManagementSPI();
        ArrayList prunedDomainList = new ArrayList();
        for (int i=0; i<domainList.length; i++)
        {
            // find the logicalName
            String logicalName = m_ds.storageToLogical(domainList[i]);
            try
            {
                if (logicalName != null)
                {
                    String parentName = (new EntityName(logicalName)).getParent();
                    if (parentName.equals(MF_DIR_SEPARATOR_STRING))
                    {
                        configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, null, true);
                    }
                    else
                    {
                        configurePermissionReadCheck(parentName +MF_DIR_SEPARATOR_STRING, null, true );
                    }
                }
                else
                {
                    configurePermissionReadCheck(MF_DIR_SEPARATOR_STRING, null, false);
                }
                prunedDomainList.add(domainList[i]);
            }
            catch (ConfigException configE)
            {
                throw new DirectoryServiceException("Unable to check permissions in listExternalDomainWithManagementSPI: " + configE.toString());
            }
            catch (ConfigurePermissionDeniedException denied) {continue;}

        }
        String[] prunedDomainArray = new String[prunedDomainList.size()];
        prunedDomainList.toArray(prunedDomainArray);
        return prunedDomainArray;
    }

    /**
     * This method is used by PASS
     * <p>
     * This method reloads the External Domain that matches the descriptor passed in.
     * For Example, passed in descriptor can be  <code> /authentication/domains/0/_MFDomainDescriptor </code>
     * <p>
     * @param mfDomainDescriptor
     * @return Boolean.TRUE if successful
     * @throws MFException
     */
    public Boolean reloadExternalAuthenticationDomain(String mfDomainDescriptor) throws MFException
    {
        if (Debug.TRACE)
        {
            Debug.trace("calling reload on the m_ds");

        }

        validateStarted();
        validateActive();

        return m_ds.reloadExternalAuthenticationDomain(mfDomainDescriptor);
    }

  private void createContainerWithADandHM(String containerPath, String activationPath, String daemonName, String hostManagerPath, String hostManagerName) throws Exception
  {
        MFMgmtBeanFactory factory = new MFMgmtBeanFactory();
        factory.connect(m_ds);

      // don't let any writes happen if any of the permission checks are going to fail. Either all
      // writes happen, or no writes happen.
        ensureFolderExists(containerPath, factory);
        ensureFolderExists(activationPath, factory);
        ensureFolderExists(hostManagerPath, factory);

        IContainerBean container = factory.createContainerBean(containerPath);
        configurePermissionWriteCheck(containerPath, null, true);

        if (hostManagerPath != null)
        {
            IHostManagerBean hm = null;
            try
            {
                 hm = factory.getHostManagerBean(hostManagerPath);
                 // ALLOW_READ check after the operation to allow other read exceptions to be thrown
                 configurePermissionReadCheck(hostManagerPath, null, true);
            }
            catch (ConfigurePermissionDeniedException denied)
            {
                throw denied;
            }
            catch (Exception e) {} // Does not yet exist

            if (hm == null)
            {
                configurePermissionWriteCheck(hostManagerPath, null, true);

                hm = factory.createHostManagerBean(hostManagerPath);
                factory.saveHostManagerBean(hm);
            }

            IContainerBean.IComponentsType components = container.getComponents();
            IContainerBean.IStartupParams entry = components.createEntry();
            entry.setAutoStart(true);
            entry.setConfigRef(hm);
            components.addEntry(hostManagerName, entry);


        }

        if (activationPath != null)
        {
            IActivationDaemonBean daemon = null;
            try
            {
                 daemon = factory.getActivationDaemonBean(activationPath);
                 // ALLOW_READ check after the operation to allow other read exceptions to be thrown
                 configurePermissionReadCheck(activationPath, null, true);
            }
            catch (ConfigurePermissionDeniedException denied)
            {
                throw denied;
            }
            catch (Exception e) {} // Does not yet exist

            if (daemon == null)
            {
                configurePermissionWriteCheck(activationPath, null, true);

                daemon = factory.createActivationDaemonBean(activationPath);
                factory.saveActivationDaemonBean(daemon);
            }

            IContainerBean.IComponentsType components = container.getComponents();
            IContainerBean.IStartupParams entry = components.createEntry();
            entry.setAutoStart(true);
            entry.setConfigRef(daemon);
            components.addEntry(daemonName, entry);


        }

        factory.saveContainerBean(container);

        factory.commit();
  }

  private void ensureFolderExists(String path, MFMgmtBeanFactory factory)
  {
      try
      {
          factory.createFolder(new EntityName(path).getParent());
      }
      catch (Exception e){} // Already exists
  }

  // Used by the launcher when used by the AD to activate containers - we don't want to access the DS through a connector
  // if it's local
  public IDirectoryAdminService getDS()
  {
      return m_ds;
  }

  /**
   * Backup the running DS, using the underlying PSE database backup capabilities.
   * @param backupDir Name of the directory to use for the backup. The domain name of the original DS is used as the subdirectory.
   * @throws MFException If there's a problem creating the subdirectory or if the timestamp of the backup cannot be modified.
   */
  public void startBackup(String backupDir, Boolean overwrite) throws MFException
  {
      if (Debug.TRACE)
      {
          Debug.trace("calling startBackup on the m_ds");

      }

      validateStarted();
      validateActive();

      m_ds.startBackup(backupDir, overwrite.booleanValue());
  }

  public IBackupStatus getBackupStatus() throws MFException
  {
      if (Debug.TRACE)
      {
          Debug.trace("calling getBackupStatus on the m_ds");

      }

      validateStarted();
      validateActive();

      return m_ds.getBackupStatus();
  }

  @Override
public void globalComponentAlreadyExists(String name)
  {
      if (m_isNotFaultTolerant)
      {
          m_context.logMessage("A non-fault tolerant or \"PRIMARY\" Directory Service appears to be running elsewhere; it must be shutdown prior to starting this container hosting the \"PRIMARY\" Directory Service", Level.SEVERE);
          abortContainer(IContainerExitCodes.DS_ALREADY_RUNNING_EXIT_CODE);
      }
      else
      {
           // The case the FT peer apears to be active (the if statement below is false) will be handle by PSE detection - no need to
           // resolve here
          if (name.startsWith('[' + m_faultToleranceRole + ']'))
          {
              m_context.logMessage("A \"" + m_faultToleranceRole + "\" Directory Service appears to be running elsewhere; it must be shutdown prior to starting this container hosting the \"" + m_faultToleranceRole + "\" Directory Service", Level.SEVERE);
              abortContainer(IContainerExitCodes.DS_ALREADY_RUNNING_EXIT_CODE);
          }
      }
  }

  private static void setReplicationTracing(int traceMask)
  {
       com.odi.Storage.setReplicationTracing((traceMask & IDebuggingMasks.TRACE_FAULT_DETECTION) > 0, false); //SNC00068921 pass 'false' - should not switch verbose replication tracing on, over detailed for normal use
  }


  void openStorageForReplication()
  {
      File domainDir = new File(new File(m_hostDir), m_domainName);
      File storageDir = new File(domainDir, IDirectoryMFService.DS_STORAGE_NAME);

      HashMap storageParameters = new HashMap();
      storageParameters.put("NO_READ_LOCK", Boolean.TRUE);



      storageParameters.put(com.odi.Storage.REPLICATION_RETRY_INTERVAL_ATTR, new Integer(m_replicationRetryInterval));
      storageParameters.put(com.odi.Storage.REPLICATION_PING_INTERVAL_ATTR, new Integer(m_replicationPingInterval));
      storageParameters.put(com.odi.Storage.REPLICATION_FAILURE_DETECTION_TIMEOUT_ATTR,
                            new Integer(m_replicationFailureDetectionTimeout));
      storageParameters.put(com.odi.Storage.MAX_REPLICATION_LOG_SIZE_ATTR, new Integer(m_maxReplicationLogSize));
      storageParameters.put(com.odi.Storage.REPLICATION_TIMEOUT_ATTR, new Integer(m_replicationTimeout));
      if (m_replSSLParams != null)
    {
        storageParameters.put(com.odi.Storage.REPLICATION_SSL_ATTR, m_replSSLParams);
    }

      setReplicationTracing(m_traceMask);

      m_replicationStateHandler = new DSStateHandler(m_faultToleranceStateManager);
      m_dsStorage = com.odi.Storage.openStorage(new DSReplicationConroller(),
                                                m_replicationStateHandler,
                                                storageDir.getAbsolutePath(),
                                                storageParameters,
                                                !m_isBackup,
                                                m_startActive,
                                                m_dualActiveResolution,
                                                m_replConnections);

  }

  //Allows to turn m_startActive on using a file placement in the working-directory (the TIDE environment doesn't have an easy way to
  // set system properties per single container
  private static boolean testStartActive(boolean deleteFile)
  {
      String testFileName = System.getProperty("_TEST_DSReplication_startActive");
      if (testFileName == null)
    {
        return false;
    }
      java.io.File testFile = new java.io.File(testFileName);
      if (!testFile.exists())
    {
        return false;
    }

      if (deleteFile)
    {
        testFile.delete();
    }
      return true;
  }


  private class DSStateHandler extends ReplicationStateHandler
  {
      private static final int NO_NEW_STATE = 0;
      private static final int TO_ACTIVE = 1;
      private static final int TO_STANDBY = 2;

      private IStateManager m_stateManager;

      private int m_currentState = NO_NEW_STATE;
      private int m_inStateActivation = NO_NEW_STATE;
      private int m_newState = NO_NEW_STATE;
      private int m_storageState = 0;
      private boolean m_closing = false;
      private boolean m_firstPhaseOfDeepSyncDone = false;


      DSStateHandler(IStateManager stateManager)
      {
          m_stateManager = stateManager;
          Thread stateModifier = new Thread("DSComponent.DSStateHandler replication state activator ")
          {
              @Override
            public void run()
              {
                  while(true)
                  {
                      boolean toActive = waitForNewState();
                      if (m_closing || m_container.isClosing())
                    {
                        return;
                    }
                      activateNewState(toActive);
                      finishedActivation();
                  }
              }
          };
          stateModifier.setDaemon(true);
          stateModifier.start();
      }

      String getStandbyStorageState()
      {
          switch (m_storageState)
          {
              case DEEP_SYNCHRONIZING_STANDBY:
                  return "Copying data (deep synchronization)";
              case SYNCHRONIZING_STANDBY:
                  return "Synchronizing";
              default:
                  return null;
          }
      }

      @Override
    public void newState(short state)
      {
          if (m_context != null &&
              ((m_firstPhaseOfDeepSyncDone && state == STANDBY) ||
              (m_storageState == DEEP_SYNCHRONIZING_STANDBY && state == STANDBY)) )
          {
              m_context.logMessage("...completed copying data from " + m_partnerRole , Level.INFO);
          }

          m_firstPhaseOfDeepSyncDone = m_storageState == DEEP_SYNCHRONIZING_STANDBY && state == SYNCHRONIZING_STANDBY;


          m_storageState = state;

          if (m_closing || m_container.isClosing())
        {
            return;
        }

          if ((m_traceMask & IDebuggingMasks.TRACE_FAULT_DETECTION) > 0)
        {
            m_context.logMessage("Storage replication state chaned to: " + stateToString(state), Level.TRACE);
        }
          stateChanged(state == SYNCHRONIZING_ACTIVE || state == ACTIVE);
      }


      @Override
    public void newMessage(String message, boolean warning)
      {
          if (m_context != null)
        {
            m_context.logMessage(message, warning ? Level.WARNING : Level.INFO);
        }
      }

      @Override
    public void shutdownState(String shutdownReason, Exception e)
      {
          if (e != null)
        {
            m_context.logMessage(shutdownReason, e, Level.SEVERE);
        }
        else
        {
            m_context.logMessage(shutdownReason,  Level.SEVERE);
        }

          int exitCode = IContainerExitCodes.DS_FAILURE_EXIT_CODE;
          if (shutdownReason != null && shutdownReason.indexOf("Both") != -1 && shutdownReason.indexOf("unreplicated") != -1)
        {
            exitCode = IContainerExitCodes.DS_DUAL_ACTIVE_EXIT_CODE;
        }
          abortContainer(exitCode);
      }

      synchronized void close()
      {
          m_closing = true;
          notifyAll();
      }

      private void activateNewState(boolean toActive)
      {
          short oldState = m_stateManager.getState(null);
          try
          {
              m_stateManager.requestStateChange(m_stateManager.getState(null),
                                             toActive ? IFaultTolerantState.STATE_ACTIVE : IFaultTolerantState.STATE_STANDBY, null);
              if (!toActive && m_storageState == DEEP_SYNCHRONIZING_STANDBY)
            {
                m_context.logMessage("Copying data from " + m_partnerRole + " (deep synchronization)...",    Level.INFO);
            }
          }
          catch (Exception e)
          {
              // we were trying to become active, so we should do our best to do that if we were transitioning from standby
              // unless we can determine that something is really wrong .. so lets assume that if we got an IOException that
              // something is *really* wrong (e.g. some disk/read issue) otherwise we'll try a restart
              boolean tryRestart = false;
              if (oldState == IFaultTolerantState.STATE_STANDBY && !(e instanceof IOException))
              {
                  Throwable cause = e.getCause();
                  if (cause == null || !(cause instanceof IOException))
                {
                    tryRestart = true;
                }
              }

              if (tryRestart)
              {
                  m_context.logMessage("The transition to active state failed, recovering by restarting the container...", e, Level.WARNING);
                  abortContainer(IContainerExitCodes.CONTAINER_RESTART_EXIT_CODE);
              }
              else
              {
                  m_context.logMessage("The transition to active state failed...", e, Level.SEVERE);
                  abortContainer(IContainerExitCodes.DS_FAILURE_EXIT_CODE);
              }
          }
      }

      private synchronized boolean waitForNewState()
      {
          while (m_newState == NO_NEW_STATE && !m_closing)
        {
            try
              {
                  wait();
              }
              catch (InterruptedException e)
              {
                  continue;
              }
        }

          if (m_closing || m_container.isClosing())
        {
            return false;
        }

          m_inStateActivation = m_newState;
          m_newState = NO_NEW_STATE;
          return m_inStateActivation == TO_ACTIVE;
      }

      private synchronized void finishedActivation()
      {
          m_currentState = m_inStateActivation;
          m_inStateActivation = NO_NEW_STATE;
      }

      private synchronized void stateChanged(boolean active)
      {
          int inCommingState = active ? TO_ACTIVE : TO_STANDBY;

          if (m_inStateActivation == NO_NEW_STATE && inCommingState != m_currentState)
        {
            m_newState = inCommingState;
        }
        else  if (m_newState == NO_NEW_STATE && m_inStateActivation != inCommingState)
        {
            m_newState = inCommingState;
        }
        else if (m_newState != inCommingState)
        {
            //The pending new state is cancelled
            m_newState = NO_NEW_STATE;
        }

          notifyAll();
      }


  }

  private class DSReplicationConroller extends ReplicationController
  {
      @Override
    public boolean allowedToGetActive()
      {
            return getAllowFailover().booleanValue();
      }
  }

  private class SdfMFTracingIntegration extends com.sonicsw.sdf.AbstractMFComponentTracing
  {
       private boolean m_updateTraceLevelWasCalled;

       SdfMFTracingIntegration()
       {
           super("sonic.mf.ds", getTraceMaskValues());
           m_updateTraceLevelWasCalled = false;

           setTraceMask();
       }
       
       private void setTraceMask() {
           setTraceMask(new Integer(DSComponent.this.m_traceMask));
       }

       boolean wasUpdated()
       {
           return m_updateTraceLevelWasCalled;
       }

       @Override
    public void updateTraceLevel(String doiIDNotUsed, HashMap parameters, StringBuffer buffer)
       {
           super.updateTraceLevel(doiIDNotUsed, parameters, buffer);
           m_updateTraceLevelWasCalled = true;
           DSComponent.this.setTraceMask(getCurrentMask(), true);
       }
  }

  private void abortContainer(final int exitCode)
  {
      m_context.logMessage("Aborting container", Level.SEVERE);
      new Thread(GLOBAL_ID + " - Shutdown Handler")
      {
          @Override
        public void run()
          {
              DSComponent.this.m_frameworkContext.getContainer().shutdown(exitCode);
          }
      }.start();
  }

  public void setManagementPermissions(String[]paths, String type, IManagementPermission[][] permissions)
  throws MFException
  {
      if (Debug.TRACE)
	  {
	      Debug.trace("calling setManagementPermissions on the m_ds");
	  }

      if (! m_ds.isPermissionsCheckingEnabled())
    {
        return;
    }

	  validateStarted();
	  validateActive();

	  m_ds.setManagementPermissions(paths, type, permissions, getContext());
  }

	public void removeManagementPermissions(String[]paths, String type, String[][] principals)
	  throws MFException
	{
	    if (Debug.TRACE)
	    {
	    	Debug.trace("calling removeManagementPermissions on the m_ds");
	    }

        if (!m_ds.isPermissionsCheckingEnabled())
        {
            return;
        }

	    validateStarted();
	    validateActive();

	    m_ds.removeManagementPermissions(paths, type, principals, getContext(), true);
	}

    public void removeManagementPermissions(String[]paths, String type)
      throws MFException
    {
        if (Debug.TRACE)
        {
            Debug.trace("calling removeManagementPermissions on the m_ds");
        }

        if (!m_ds.isPermissionsCheckingEnabled())
        {
            return;
        }

        validateStarted();
        validateActive();

        m_ds.removeManagementPermissions(paths, type, getContext(), true);
    }

	public IManagementPermission[][] getManagementPermissions(String paths[], String type)
	  throws MFException
	{
		if (Debug.TRACE)
	    {
	        Debug.trace("calling getManagementPermissions on the m_ds");
	    }

        if (!m_ds.isPermissionsCheckingEnabled())
        {
            return new IManagementPermission[0][0];
        }

	    validateStarted();
	    validateActive();

	    return m_ds.getManagementPermissions(paths, type, getContext(), true);
	}

	public void removeAllManagementPermissions()
	throws MFException
	{
		if (Debug.TRACE)
	    {
	        Debug.trace("calling removeAllManagementPermissions on the m_ds");
	    }

        if (!m_ds.isPermissionsCheckingEnabled())
        {
            return;
        }

        validateStarted();
	    validateActive();

	    m_ds.removeAllManagementPermissions();
	}

	public void suspendChangeNotifications(String containerID, String[] allowTypes)
	throws MFException
	{
		if (Debug.TRACE)
	    {
	        Debug.trace("calling suspendChangeNotifications on the m_ds for container " + containerID);
	    }
		validateStarted();
        validateActive();
        this.configurePermissionWriteCheck(containerID, containerID, true);
        m_ds.suspendChangeNotifications(containerID, allowTypes);
	}

	public void resumeChangeNotifications(String containerID)
	throws MFException
	{
		if (Debug.TRACE)
	    {
	        Debug.trace("calling resumeChangeNotifications on the m_ds for container " + containerID);
	    }
		validateStarted();
        validateActive();
        this.configurePermissionWriteCheck(containerID, containerID, true);
        m_ds.resumeChangeNotifications(containerID);
	}

	public void resumeAllChangeNotifications()
	throws MFException
	{
		if (Debug.TRACE)
	    {
	        Debug.trace("calling resumeAllChangeNotifications on the m_ds");
	    }
		validateStarted();
        validateActive();
        this.configurePermissionWriteCheck(MF_DIR_SEPARATOR_STRING, null, false);
        m_ds.resumeAllChangeNotifications();
	}

	public void setDefaultManagementPermissions()
	throws MFException
	{
		if (Debug.TRACE)
	    {
	        Debug.trace("calling addDefaultManagementPermissions on the m_ds");
	    }

	    validateStarted();
	    validateActive();

	    m_ds.setDefaultManagementPermissions();
	}

    private void configurePermissionReadCheck(String path, String originalPath, boolean isLogical)
    throws DirectoryServiceException
    {
        configurePermissionCheck(path, originalPath, IConfigurePermissionBits.ALLOW_READ, isLogical);
    }

    private void configurePermissionWriteCheck(String path, String originalPath, boolean isLogical)
    throws DirectoryServiceException
    {
        configurePermissionCheck(path, originalPath, IConfigurePermissionBits.ALLOW_WRITE, isLogical);
    }

    private void configurePermissionDeleteCheck(String path, String originalPath, boolean isLogical)
    throws DirectoryServiceException
    {
        configurePermissionCheck(path, originalPath, IConfigurePermissionBits.ALLOW_DELETE, isLogical);
    }

    private void configurePermissionCheck(String path, String originalPath, int permission, boolean isLogical)
    throws DirectoryServiceException
    {
        if (originalPath != null && originalPath.startsWith(MFCONTEXT_ROOT_DIR))
         {
            return; // we do not enforce permissions on our internal JNDI store
        }
        if (path != null && path.startsWith(DiskFileDSHandler.getHandlerName()))
         {
            return; // no permissions if we're returning a zipped file. The contents
        }
                    // have already been checked for permissions
        // the call to getPermissionsPath can trigger the Eclipse handler midway
        // into being seeded. Do not call the PermissionsManager if permissions checking
        // is not enabled
        if (getContext().getPermissionsManager().isPermissionsCheckingEnabled())
        {
            getContext().getPermissionsManager().configurePermissionCheck(getContext(), m_ds.getPermissionsPath(path), isLogical, permission);
        }
    }
    
    private boolean checkPermissions(String elementOrDirName)
    {
        return getContext().getPermissionsManager().isPermissionsCheckingEnabled() && 
            !elementOrDirName.startsWith(MFCONTEXT_ROOT_DIR);
    }
}
