// Copyright (c) 2010 Progress Software Corporation. All Rights Reserved.

package com.sonicsw.mf.framework.directory;

import com.sonicsw.mx.config.ConfigServerUtility;
import com.sonicsw.mx.config.ConfigServiceException;

public final class DirectoryServiceFileImporter
{
    private static class ConfigServerUtilityLazyLoader {
        private static final ConfigServerUtility CSU = new ConfigServerUtility();
    }

    public static void main(String[] args)  throws Exception
    {
        if (args.length < 2 || args[0].equals("?"))
        {
            printUsage();
        }

        try
        {
            new DirectoryServiceFileImporter(args);
        }
        catch(Exception e) { e.printStackTrace(); }
    }

    private DirectoryServiceFileImporter(String[] args)
    throws Exception
    {
        int status = 0; // Exit status of 0 indicates no errors, non-zero = errors

        String domain = "Domain1";
        String url = "tcp://localhost:2506";
        String user = "Administrator";
        String password = null;

        String fromDir = null;
        String toPath = null;

        int i = 0;

        while (i < args.length)
        {
            if (args[i].equals("-domain"))
            {
                domain = args[++i];
            }
            else if (args[i].equals("-url"))
            {
                url = args[++i];
            }
            else if (args[i].equals("-user"))
            {
                user = args[++i];
            }
            else if (args[i].equals("-password"))
            {
                password = args[++i];
            }
            else if (args[i].equals("-from"))
            {
                fromDir = args[++i];
            }
            else if (args[i].equals("-to"))
            {
                toPath = args[++i];
            }
            else
            {
                break;
            }
            i++;
        }

        System.out.println("Importing files");
        System.out.println("from: " + fromDir);
        System.out.println("to:   " + toPath);

        try
        {
            ConfigServerUtilityLazyLoader.CSU.connect(domain, url, user, password, true);

            while (i+1 < args.length)
            {
                System.out.print("- " + args[i+1] + " => " + args[i]);
                try
                {
                    ConfigServerUtilityLazyLoader.CSU.importFile(toPath + args[i], fromDir + args[i+1], true);
                    System.out.println('.');
                }
                catch (ConfigServiceException e)
                {
                    status = 1;
                    System.out.println(" === Unable to import: " + e.getMessage());
                    e.printStackTrace();
                    if (e.getLinkedException() != null)
                    {
                        System.out.println("Caused by:");
                        e.getLinkedException().printStackTrace();
                    }
                }
                i = i + 2;
            }
        }
        finally
        {
            ConfigServerUtilityLazyLoader.CSU.disconnect();
        }
        System.out.println("Done.");

        System.exit(status);
    }

    private static void printUsage()
    {
        System.out.println();
        System.out.println("Usage: com.sonicsw.mf.framework.directory.storage.DirectoryServiceFileImporter");
        System.out.println("         -ds <domainName> -url <connectionURLs> -user <userName> -password <password>");
        System.out.println("         -to <import.path> -from <import.dir> <import.name.pairs>");
        System.out.println();
        System.out.println("Where: ");
        System.out.println("       <import.path>        The path, including the trailing slash, into which the file(s) will be imported");
        System.out.println("       <import.dir>         The directory, including the trailing slash, containing the file(s) to be imported");
        System.out.println();
        System.out.println("       <import.name.pairs>  The space separated list of space separated pairs, each of which is the name of the path and the name of the file.");
        System.out.println("In most cases, the name of the path and the name of the file will be the same.  The name of the path is concatenated to <import.path> and the name of the file is concatenated to <import.dir>.");
        System.exit(1);
    }

}
