/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.framework.directory;

public interface IDebuggingMasks
{
  static final String DS_TRACE_MASK_VALUES = "16=startup,32=updates,64=pass,128=container access,256=configuration notifications,512=validation triggers,1024=all directory service access,2048=fault detection";

  public static final int TRACE_STARTUP = 16; // Startup parameters and process
  public static final int TRACE_UPDATES = 32; // Updates by admin clients
  public static final int TRACE_EXTERNAL_AUTH = 64; // Pluggin access to external authentication sources
  public static final int TRACE_CONTAINER_ACCESS = 128; // Containers ask for configuration, subscribe for changes and reconcile
  public static final int TRACE_CONFIGURATION_NOTIFICATIONS = 256; // DS notifies configuration changes
  public static final int TRACE_VALIDATION_TRIGGERS = 512; // Validation triggers plugginn
  public static final int TRACE_ALL_DS_ACCESS = 1024; // Any DS access call
  public static final int TRACE_FAULT_DETECTION = 2048; // Fault tolerance fault detection
}
