/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.framework.directory;
import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.security.IManagementSecurityConfigurator;

/**
 * The IDirectoryService object is the central repository interface used by framework components, administration utilities
 * and framework agents. There is always a single instance of IDirectoryService in the JVM that hosts the directory
 * service component. Local clients of the directory service access IDirectoryService directly, while remote clients
 * access it through a JMX connector. The DirectoryServiceFactory class encapsulates the details of the construction
 * of the underlying storage (JNDI or file-system). The interfaces is comprised of four interfaces:
 * IDirectoryAdminService and IDirectoryFileSystemService used by admin tools,
 * IDirectoryMFService used internally by the MF, mostly for keeping the cache up-to-date and IContainerlessDS
 * used only locally -  not through a container.
 * IDirectoryAdminService methods are thread safe and optimistic concurrency control is used to coordinate between multiple utilities
 * updating the same IDirElement objects cuncurrently.
 */

public interface IDirectoryService extends IDirectoryAdminService, IDirectoryMFService, IContainerlessDS, IDirectoryFileSystemService, IManagementSecurityConfigurator
{}
