package com.sonicsw.mf.framework.directory;

import java.util.Hashtable;

import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.MFRuntimeException;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.IBlob;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementChangeHandler;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.INextVersionToken;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.ElementFactory;
import com.sonicsw.mf.common.dirconfig.IDeltaDirElement;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.IDirIdentity;
import com.sonicsw.mf.common.dirconfig.InvalidXMLException;
import com.sonicsw.mf.common.dirconfig.VersionOutofSyncException;
import com.sonicsw.mf.common.runtime.IBackupStatus;
import com.sonicsw.mf.common.view.IDeltaView;
import com.sonicsw.mf.common.view.IView;
import com.sonicsw.mf.mgmtapi.config.constants.IBackupDirectoryServiceConstants;
import com.sonicsw.mf.mgmtapi.config.constants.IDirectoryServiceConstants;

public final class LocalDirectoryServiceProxy implements IDirectoryAdminService
{
    private IDirectoryAdminService m_ds;

    public LocalDirectoryServiceProxy(String xmlData)
    throws Exception
    {
        IDirElement dsConfig = ElementFactory.importElementFromXML(xmlData, null, IDirectoryServiceConstants.DS_TYPE);
        if (dsConfig == null)
        {
            dsConfig = ElementFactory.importElementFromXML(xmlData, null, IBackupDirectoryServiceConstants.DS_TYPE);
        }

        IAttributeSet dsAttributes = dsConfig.getAttributes();

        String hostDir    = (String)dsAttributes.getAttribute(IDirectoryServiceConstants.HOST_DIRECTORY_ATTR);
        String domainName = (String)dsAttributes.getAttribute(IDirectoryServiceConstants.DOMAIN_NAME_ATTR);
        Object tmp        = dsAttributes.getAttribute(IDirectoryServiceConstants.FILE_SYSTEM_STORAGE_ATTR);

        if (domainName == null || tmp == null)
        {
            throw new MFRuntimeException("Bad Directory Service Configuration - must contain DOMAIN_NAME and FILE_SYSTEM_STORAGE.");
        }

        if (!(tmp instanceof IAttributeSet))
        {
            throw new MFRuntimeException("Bad Directory Service Configuration - FILE_SYSTEM_STORAGE must be an attribute set.");
        }

        IAttributeSet fsStorage = (IAttributeSet)tmp;

        String hostDirDepricated = (String)fsStorage.getAttribute(IDirectoryServiceConstants.HOST_DIRECTORY_ATTR);
        String password          = (String)fsStorage.getAttribute(IDirectoryServiceConstants.PASSWORD_ATTR);

        // Creates the directory service object
        Hashtable directoryEnv = new Hashtable();
        directoryEnv.put(IDirectoryService.STORAGE_TYPE_ATTRIBUTE, IDirectoryService.PSE_STORAGE);
        if (hostDirDepricated != null)
        {
            directoryEnv.put(IFSStorage.FS_HOST_DIRECTORY_ATTRIBUTE, hostDirDepricated);
        }
        if (hostDir != null)
        {
            directoryEnv.put(IFSStorage.HOST_DIRECTORY_ATTRIBUTE, hostDir);
        }
        if ((password != null) && (password.length() != 0))
        {
            directoryEnv.put(IFSStorage.PASSWORD_ATTRIBUTE, password);
        }

        m_ds = new DirectoryServiceFactory(directoryEnv).createDirectoryService(domainName);
    }

  @Override
public void registerElementChangeHandler(IElementChangeHandler handler)
  {
      if (m_ds == null)
    {
        throw  new RuntimeException("The DS is closed.");
    }

      m_ds.registerElementChangeHandler(handler);
  }
  @Override
public void registerElementChangeHandler(String elementName, IElementChangeHandler handler)
  {
      if (m_ds == null)
    {
        throw  new RuntimeException("The DS is closed.");
    }

      m_ds.registerElementChangeHandler(elementName, handler);
  }
  @Override
public void unregisterElementChangeHandler(IElementChangeHandler handler)
  {
      if (m_ds == null)
    {
        return;
    }

      m_ds.unregisterElementChangeHandler(handler);
  }
  @Override
public void unregisterElementChangeHandler(String elementName, IElementChangeHandler handler)
  {
      if (m_ds == null)
    {
        return;
    }

      m_ds.unregisterElementChangeHandler(elementName, handler);
  }

    public void close()
    {
        try
        {
            if(m_ds != null)
            {
                ((IDirectoryService)m_ds).close();
            }
        }
        catch(Exception e) { }

        m_ds = null;
    }

    @Override
    public String getDomain()
    {
        return null;
    }

    @Override
    public int getDirectoryServiceVersion()
    {
        return m_ds.getDirectoryServiceVersion();
    }

    @Override
    public String getDirectoryServiceReleaseVersion()
    {
        return m_ds.getDirectoryServiceReleaseVersion();
    }

    @Override
    public IView getView()
    throws DirectoryServiceException
    {
        return m_ds.getView();
    }

    @Override
    public IView setView(IDeltaView view)
    throws DirectoryServiceException, VersionOutofSyncException
    {
        return m_ds.setView(view);
    }

    @Override
    public INextVersionToken setViewGetToken(IDeltaView view)
    throws DirectoryServiceException, VersionOutofSyncException
    {
        return m_ds.setViewGetToken(view);
    }

    @Override
    public IDirElement[] getElementIfUpdated(long callerBackupVersion, String elementName, IElementIdentity id)
    throws DirectoryServiceException
    {
        return m_ds.getElementIfUpdated(callerBackupVersion, elementName, id);
    }

    @Override
    public IDirElement getElement(String elementName, boolean forUpdate)
    throws DirectoryServiceException
    {
        return m_ds.getElement(elementName, forUpdate);
    }

    @Override
    public IDirElement getElement(String elementName, boolean forUpdate, boolean getSubclassingDelta)
    throws DirectoryServiceException
    {
        return m_ds.getElement(elementName, forUpdate, getSubclassingDelta);
    }

    @Override
    public IDirElement[] getElements(com.sonicsw.mf.common.config.query.Query query, boolean forUpdate)
    throws DirectoryServiceException
    {
        return m_ds.getElements(query, forUpdate);
    }

    @Override
    public IDirElement[] getElements(com.sonicsw.mf.common.config.query.Query query, boolean forUpdate, boolean getSubclassingDelta)
    throws DirectoryServiceException
    {
        return m_ds.getElements(query, forUpdate, getSubclassingDelta);
    }

    @Override
    public IBlob getBlob(String elementName, boolean forUpdate)
    throws DirectoryServiceException
    {
        return m_ds.getBlob(elementName, forUpdate);
    }

    @Override
    public void detachBlob(IDeltaDirElement delta, IDeltaView view) throws DirectoryServiceException
    {
        m_ds.detachBlob(delta, view);
    }

    @Override
    public IDirElement[] getAllElements(String dirName, boolean forUpdate)
    throws DirectoryServiceException
    {
        return m_ds.getAllElements(dirName, forUpdate);
    }

    @Override
    public IDirElement[] getAllElementsCompressed(String dirName, boolean forUpdate)
    throws DirectoryServiceException 
    {
        return m_ds.getAllElementsCompressed(dirName, forUpdate);
    }

    @Override
    public void setElementReleaseVersion(String elementName, String newVersion)
    throws DirectoryServiceException
    {
        m_ds.setElementReleaseVersion(elementName, newVersion);
    }

    @Override
    public INextVersionToken setElement(IBasicElement element, IDeltaView view)
    throws DirectoryServiceException
    {
        return m_ds.setElement(element, view);
    }

    @Override
    public INextVersionToken setElements(IBasicElement[] elements, String[] deleteList, IDeltaView view)
    throws DirectoryServiceException
    {
        return m_ds.setElements(elements, deleteList, view);
    }

    @Override
    public void attachBlob(IBasicElement element, java.io.InputStream blobStream, IDeltaView view)
    throws DirectoryServiceException
    {
        /*
        if (blobStream == null)
            throw new DirectoryServiceException("The blob stream object cannot be null.");

        java.io.BufferedInputStream bufStream = new java.io.BufferedInputStream(blobStream);
        try
        {
            java.io.ByteArrayOutputStream byteOutput = new java.io.ByteArrayOutputStream(100000);
             while (true)
             {
                 int b = bufStream.read();
                 if (b == -1)
                 {
                     bufStream.close();
                     break;
                 }
                 byteOutput.write(b);
             }
             byteOutput.close();

            m_server.invoke(m_dsName, "attachBlob", new Object[] { element, byteOutput.toByteArray(), view },
                                         ATTACH_BLOB_SIGNATURE);
        }
        catch(Exception e)
        {
            Exception mappedException = mapException(e);
            if (mappedException instanceof DirectoryServiceException) throw (DirectoryServiceException)mappedException;
            throw new ProxyRuntimeException(mappedException);
        }
        */
    }

    @Override
    public void attachBlob(IBasicElement element, byte[] blob, IDeltaView view)
    throws DirectoryServiceException
    {
        if (blob == null)
        {
            throw new DirectoryServiceException("The blob object cannot be null.");
        }

        m_ds.attachBlob(element, blob, view);
    }

    @Override
    public IElementIdentity deleteElement(String elementName, IDeltaView view)
    throws DirectoryServiceException, VersionOutofSyncException
    {
        return m_ds.deleteElement(elementName, view);
    }

    @Override
    public void unSubclassElement(String elementName, IDeltaView view)
    throws DirectoryServiceException, VersionOutofSyncException
    {
        m_ds.unSubclassElement(elementName, view);
    }

    @Override
    public IDirElement cloneElement(String elementName, String newName, IDeltaView view)
    throws DirectoryServiceException
    {
        return m_ds.cloneElement(elementName, newName, view);
    }

    @Override
    public IDirElement cloneElement(IBasicElement delta, String newName, IDeltaView view)
    throws DirectoryServiceException, VersionOutofSyncException
    {
        return m_ds.cloneElement(delta, newName, view);
    }

    @Override
    public IDirElement cloneElement(String elementName, String newName, boolean createTemplate, IDeltaView view)
    throws DirectoryServiceException
    {
        return m_ds.cloneElement(elementName, newName, createTemplate, view);
    }

    @Override
    public IDirElement cloneElement(IBasicElement delta, String newName, boolean createTemplate, IDeltaView view)
    throws DirectoryServiceException, VersionOutofSyncException
    {
        return m_ds.cloneElement(delta, newName, createTemplate, view);
    }

    @Override
    public IDirElement subclassElement(IBasicElement delta, String newName, IDeltaView view)
    throws DirectoryServiceException, VersionOutofSyncException
    {
        return m_ds.subclassElement(delta, newName, view);
    }

    @Override
    public com.sonicsw.mf.common.config.IIdentity getIdentity (String name)
    throws DirectoryServiceException
    {
        return m_ds.getIdentity (name);
    }

    @Override
    public com.sonicsw.mf.common.config.IIdentity[] listAll(String dirName)
    throws DirectoryServiceException
    {
        return m_ds.listAll(dirName);
    }

    @Override
    public IDirIdentity[] listDirectories(String dirName)
    throws DirectoryServiceException
    {
        return m_ds.listDirectories(dirName);
    }

    @Override
    public IElementIdentity[] listElements(String dirName)
    throws DirectoryServiceException
    {
        return m_ds.listElements(dirName);
    }

    @Override
    public void createDirectory(String dirName)
    throws DirectoryServiceException
    {
        m_ds.createDirectory(dirName);
    }

    @Override
    public void deleteDirectory(String dirName)
    throws DirectoryServiceException
    {
        m_ds.deleteDirectory(dirName);
    }

    @Override
    public void deleteDirectory(String dirName, IDeltaView view)
    throws DirectoryServiceException
    {
        m_ds.deleteDirectory(dirName, view);
    }

    @Override
    public String exportElementToXML(String elementName)
    throws DirectoryServiceException
    {
        return m_ds.exportElementToXML(elementName);
    }
    
    @Override
    public String exportDSBootFileString(String elementName)
    throws DirectoryServiceException
    {
    	return m_ds.exportDSBootFileString(elementName);
    }

    @Override
    public String exportDirectoryToXML(String directoryName)
    throws DirectoryServiceException
    {
        return m_ds.exportDirectoryToXML(directoryName);
    }

    @Override
    public void dumpContentsToXML()
    {
        m_ds.dumpContentsToXML();
    }

    @Override
    public void importFromXML(String XMLDocument)
    throws DirectoryServiceException, InvalidXMLException
    {
        m_ds.importFromXML(XMLDocument);
    }

    /*
    private final class ElementChange
    implements IElementChange
    {
        IBasicElement m_element;
        boolean m_replacement;

        ElementChange(IBasicElement element, boolean replacement)
        {
            m_element = element;
            m_replacement = replacement;
        }

        public IBasicElement getElement() { return m_element; }

        public short getChangeType()
        {
            if (m_element instanceof IDeltaElement)
                return IElementChange.ELEMENT_UPDATED;
            if (((IElement)m_element).isDeleted())
                return IElementChange.ELEMENT_DELETED;
            if (m_replacement)
                return IElementChange.ELEMENT_REPLACED;
            return IElementChange.ELEMENT_ADDED;
        }
    }
    */

    /**
     * This method is used by PASS
     * <p>
     * @see com.sonicsw.mf.common.IDirectoryAdminService#listExternalDomainWithManagementSPI()
     */
    @Override
    public String[] listExternalDomainWithManagementSPI() throws DirectoryServiceException
    {
        return m_ds.listExternalDomainWithManagementSPI();
    }

    /**
     * This method is used by PASS
     * <p>
     * @see com.sonicsw.mf.common.IDirectoryAdminService#reloadExternalAuthenticationDomain(java.lang.String)
     * @see com.sonicsw.mf.framework.directory.impl.DirectoryService#reloadExternalAuthenticationDomain(String)
     */
    @Override
    public Boolean reloadExternalAuthenticationDomain(String mfDomainDescriptor) throws DirectoryServiceException
    {
        return m_ds.reloadExternalAuthenticationDomain(mfDomainDescriptor);
    }

  @Override
public void upgrade5to6(String configType, String configLogicalPath) throws DirectoryServiceException
  {
       m_ds.upgrade5to6(configType, configLogicalPath);
  }

    @Override
    public IElement[] getElementsByLogicalNames(String[] logicalNames) throws DirectoryServiceException
    {
        return m_ds.getElementsByLogicalNames(logicalNames);
    }

    @Override
    public IBlob getBlobByLogicalName(String logicalName) throws DirectoryServiceException
    {
        return m_ds.getBlobByLogicalName(logicalName);
    }

  @Override
public IBlob getBlobByLogicalName(String unusedSubscriber, String logicalName) throws DirectoryServiceException
    {
        return m_ds.getBlobByLogicalName(logicalName);
    }

    @Override
    public void startBackup(String backupDir, boolean overwrite) throws DirectoryServiceException
    {
    	m_ds.startBackup(backupDir, overwrite);
    }
    
    @Override
    public IBackupStatus getBackupStatus() throws DirectoryServiceException
    {
    	return m_ds.getBackupStatus();
    }

}
