package com.sonicsw.mf.framework.directory;

import java.util.ArrayList;

import com.sonicsw.mf.common.config.impl.DeltaElement;
import com.sonicsw.mf.common.config.impl.Element;
import com.sonicsw.mf.common.config.impl.EnvelopeElement;

/**
 * Used to size a set of elements, deltas or envelopes for transmission to a remote container
 */
public class SizedArrayList extends ArrayList
{
    // The estimated maximum size
    public final static int MAXIMUM_CONTENT_SIZE = 1048576; // 1Mb

    private int m_estimatedSize = 0;

    @Override
    public boolean add(Object object)
    {
        super.add(object);

        if (object instanceof Element)
        {
            m_estimatedSize += ((Element)object).estimateSize();
        }
        if (object instanceof DeltaElement)
        {
            m_estimatedSize += ((DeltaElement)object).estimateSize();
        }
        if (object instanceof EnvelopeElement)
        {
            m_estimatedSize += ((EnvelopeElement)object).estimateSize();
        }

        return true;
    }

    public int getEstimatedContentSize()
    {
         return m_estimatedSize;
    }
}