/*
 * Copyright (c) 2004 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.framework.directory.impl;

import com.sonicsw.mf.common.config.IDSHandlerContext;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.IIdentity;
import com.sonicsw.mf.common.config.query.Query;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.IDirIdentity;
import com.sonicsw.mf.common.dirconfig.VersionOutofSyncException;


final class DSHandlerContext implements IDSHandlerContext
{
    private DirectoryService m_ds;

    DSHandlerContext(DirectoryService ds)
    {
        m_ds = ds;
    }

    @Override
    public IDirElement getElement(String elementName) throws DirectoryServiceException
    {
        return m_ds.getElement(elementName, false, false);
    }

    @Override
    public IDirElement[] getElements(Query query) throws DirectoryServiceException
    {
        return m_ds.getElements(query, false, false);
    }

    @Override
    public IDirElement[] getAllElements(String dirName) throws DirectoryServiceException
    {
        return m_ds.getAllElements(dirName, false);
    }

    @Override
    public boolean directoryExists(String dirName) throws DirectoryServiceException
    {
        return m_ds.directoryExists(dirName);
    }

    @Override
    public IElementIdentity[] listElements(String dirName) throws DirectoryServiceException
    {
        return m_ds.listElements(dirName);
    }

    @Override
    public IDirIdentity[] listDirectories(String dirName) throws DirectoryServiceException
    {
        return m_ds.listDirectories(dirName);
    }

    @Override
    public IIdentity[] listAll(String dirName) throws DirectoryServiceException
    {
        return m_ds.listAll(dirName);
    }

    @Override
    public void createFSElement(IDirElement element) throws DirectoryServiceException, VersionOutofSyncException
    {
        m_ds.createFSElement(element);
    }

    @Override
    public void setElement(IDirElement element) throws DirectoryServiceException, VersionOutofSyncException
    {
        m_ds.setElement(element, null);
    }

    @Override
    public String[] getDefinedFolderMetaAttributes() throws DirectoryServiceException
    {
        return m_ds.getDefinedFolderMetaAttributes();
    }

    @Override
    public String[] getDefinedElementMetaAttributes() throws DirectoryServiceException
    {
        return m_ds.getDefinedElementMetaAttributes();
    }

    @Override
    public void deleteElement(String elName) throws DirectoryServiceException
    {
        m_ds.deleteElement(elName, null);
    }

    @Override
    public void createDirectory(String dirName) throws DirectoryServiceException
    {
        m_ds.createDirectory(dirName);
    }
}
