/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.framework.directory.impl;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;

interface IModificationManager
{
    void validate() throws DirectoryServiceException;
    void onCreate() throws DirectoryServiceException;
    void afterCreate() throws DirectoryServiceException;
    void afterUpdate() throws DirectoryServiceException;
    void onUpdate() throws DirectoryServiceException;
    void afterDelete() throws DirectoryServiceException;
    void onDelete() throws DirectoryServiceException;
    void audit() throws DirectoryServiceException;
    void doNotify() throws DirectoryServiceException;
    void reset();
}
