/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.framework.directory.impl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

import com.sonicsw.mf.common.config.INameChangeHandler;
import com.sonicsw.mf.common.config.INamingNotification;
import com.sonicsw.mf.common.view.INamingListener;


// Listen to DS naming notifications through the InamingListener interface
// and report to listeners who registered through the IDirectoryFileSystemNotifications interface.
final class LocalFSListener extends LocalListener implements INamingListener
{
    private HashSet m_handlers;

    LocalFSListener()
    {
        super();
        m_handlers = new HashSet();
    }

    void registerNamingHandler(INameChangeHandler handler)
    {
        synchronized(m_handlers)
        {
            m_handlers.add(handler);
        }
    }

    void unregisterNamingHandler(INameChangeHandler handler)
    {
        synchronized(m_handlers)
        {
            m_handlers.remove(handler);
        }
    }

    @Override
    public void onNotification(INamingNotification notification)
    {
        ArrayList notifications = new ArrayList();
        notifications.add(notification);
        onNotifications(notifications);
    }

    @Override
    public void onNotifications(ArrayList notifications)
    {
        HashSet handlers = null;
        synchronized(m_handlers)
        {
             handlers = (HashSet)m_handlers.clone();
        }

        for (int i = 0; i < notifications.size(); i++)
        {
            INamingNotification notification = (INamingNotification)notifications.get(i);

            Iterator iterator = handlers.iterator();
            while (iterator.hasNext())
            {
                INameChangeHandler handler = (INameChangeHandler)iterator.next();
                try
                {
                    handler.onNamingNotification(notification);
                }
                catch (Throwable t) // Should never happen
                {
                    t.printStackTrace();
                }
            }
        }
    }

}
