package com.sonicsw.mf.framework.directory.impl;

import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;

import com.sonicsw.mf.common.url.SonicRNStreamHandler;

public class StandaloneURLStreamHandlerFactoryImpl
implements URLStreamHandlerFactory
{
    private SonicRNStreamHandler m_sonicrnHandler;
    private DirectoryService m_ds;

    StandaloneURLStreamHandlerFactoryImpl(DirectoryService ds)
    {
        m_ds = ds;
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol)
    {
        if (protocol.equalsIgnoreCase("sonicrn"))  // the handler is defined only when we have a DS in the container
        {
            if (m_sonicrnHandler == null)
            {
                m_sonicrnHandler = new SonicRNStreamHandler(m_ds, true);
            }
            return m_sonicrnHandler;
        }            
        return null;
    }
    
    // The URL handler can only be set once in a jvm, but SDM opens and closes instances of the DS
    // several times within one JVM. Therefore, we need to refresh the DS instance of the handler without
    // being able to reset the handler. The DirectoryService uses this method when creating the factory
    // subsequent times in a JVM.
    void setDirectoryService(DirectoryService ds)
    {
        m_ds = ds;
        if (m_sonicrnHandler != null)
        {
            m_sonicrnHandler.setDirectoryService(ds);
        }
    }
}
