/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.framework.directory.impl;

import com.sonicsw.mf.common.config.IDeltaElement;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.ITriggerDSContext;
import com.sonicsw.mf.common.config.query.Query;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.IDirIdentity;


final class TriggerDSContext implements ITriggerDSContext
{
    private DirectoryService m_ds;

    TriggerDSContext(DirectoryService ds)
    {
        m_ds = ds;
    }

    @Override
    public IDirElement getElement(String elementName) throws DirectoryServiceException
    {
        return m_ds.getElement(elementName, true, true); 
    }

    @Override
    public IDirElement[] getElements(Query query, boolean forUpdate) throws DirectoryServiceException
    {
        return m_ds.getElements(query, forUpdate, true);
    }

    @Override
    public void setElement(IDeltaElement delta) throws DirectoryServiceException
    {
        setElement(delta, true);
    }

    @Override
    public void setElement(IDeltaElement delta, boolean fireTriggers) throws DirectoryServiceException
    {
        m_ds.setElement(fireTriggers, delta, null);
    }

    @Override
    public void deleteElement(String elementName) throws DirectoryServiceException
    {
        m_ds.deleteElements(new String[] { elementName });
    }

    @Override
    public boolean directoryExists(String dirName) throws DirectoryServiceException
    {
        return m_ds.directoryExists(dirName);
    }

    @Override
    public IElementIdentity[] listElements(String dirName) throws DirectoryServiceException
    {
        return m_ds.listElements(dirName);
    }

    @Override
    public IDirIdentity[] listDirectories(String dirName) throws DirectoryServiceException
    {
        return m_ds.listDirectories(dirName);
    }
    
    @Override
    public void deleteDirectory(String dirName) throws DirectoryServiceException
    {
        m_ds.deleteDirectory(dirName);
    }
    
    @Override
    public void logMessage(String message, int severityLevel)
    {
        m_ds.logMessage(message, severityLevel);
    }
    
    @Override
    public void logMessage(String message, Throwable throwable, int severityLevel)
    {
        m_ds.logMessage(message, throwable, severityLevel);
    }
}
