/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.framework.directory.impl;

import com.sonicsw.mf.common.config.IBlob;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IValidationDSContext;
import com.sonicsw.mf.common.config.query.Query;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;


final class ValidationDSContext implements IValidationDSContext
{
    private DirectoryService m_ds;
    private boolean m_isImportTransaction;

    ValidationDSContext(DirectoryService ds, boolean isImportTransaction)
    {
        m_ds = ds;
        m_isImportTransaction = isImportTransaction;
    }

    @Override
    public boolean isImportTransaction()
    {
        return m_isImportTransaction;
    }

    @Override
    public IElement getElement(String elementName) throws DirectoryServiceException
    {
        return m_ds.getElement(elementName, false); 
    }

    @Override
    public IElement[] getElements(Query query) throws DirectoryServiceException
    {
        return m_ds.getElements(query, false, true);
    }
    
    @Override
    public String getLogicalName(String storageName) throws DirectoryServiceException
    {
    	return m_ds.storageToLogical(storageName);
    }
    
    @Override
    public IBlob getFSBlob(String blobName) throws DirectoryServiceException
    {
    	return m_ds.getFSBlob(blobName, false);
    }

}
