/*
 * Copyright (c) 2005 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.framework.directory.storage;

import com.sonicsw.mf.common.config.IMFDirectories;
import com.sonicsw.mf.common.config.impl.EntityName;

public class PackedDirUtil
{
    // All elements directly under any _MFUsers, _MFGroups, _MQACLs and _MQQoPs directories are packed.
    //  Directory examples: /security/_MFUsers, /security/domain1/_MFUsers and security/domain1/_MFGroups
    // The corresponding types are MF_AUTHENTICATION_USER, MF_AUTHENTICATION_GROUP, MQ_AUTHORIZATION_ACL and MQ_AUTHORIZATION_QOP_
    private static final String[] ELEMENT_PACKING_DIRS = new String[] { IMFDirectories.MF_USERS_DIR, IMFDirectories.MF_GROUPS_DIR, "_MQACLs", "_MQQoPs"};
    public static final String[] ELEMENT_PACKING_TYPES = new String[]{"MF_AUTHENTICATION_USER", "MF_AUTHENTICATION_GROUP", "MQ_AUTHORIZATION_ACL", "MQ_AUTHORIZATION_QOP"};

    public static boolean underPackedDir(EntityName elementName)
    {
          String[] parentComponents = elementName.getParentComponents();

          if (parentComponents == null ||  parentComponents.length == 0)
        {
            return false;
        }

          for (int i = 0; i < ELEMENT_PACKING_DIRS.length; i++)
          {
              if (parentComponents[parentComponents.length - 1].equalsIgnoreCase(ELEMENT_PACKING_DIRS[i]))
            {
                return true;
            }
          }

          return false;
    }

    public static boolean isPackedDir(EntityName dirName)
    {
          String name = dirName.getBaseName();

          for (int i = 0; i < ELEMENT_PACKING_DIRS.length; i++)
          {
              if (name.equalsIgnoreCase(ELEMENT_PACKING_DIRS[i]))
            {
                return true;
            }
          }

          return false;
    }
}