package com.sonicsw.mf.framework.directory.storage.pse;

import com.odi.ClassInfo;
import com.odi.GenericObject;
import com.odi.IPersistent;
import com.odi.IPersistentHooks;
import com.odi.ObjectStore;
import com.odi.imp.ObjectReference;
import com.odi.util.HashPersistent;

public class CollectionElement
    implements IPersistent, IPersistentHooks
{

    public CollectionElement(String name)
    {
        ODITheHashCode = HashPersistent.getNextHashCode();
        m_name = name;
    }

    public String getName()
    {
        if(ODIObjectState < 0)
        {
            ObjectStore.fetch(this);
        }
        return m_name;
    }

    public void setName(String name)
    {
        if((ODIObjectState & 2) != 0)
        {
            ObjectStore.dirty(this);
        }
        m_name = name;
    }


    @Override
    public void preDestroyPersistent()
    {
        if((ODIObjectState & 2) != 0)
        {
            ObjectStore.dirty(this);
        }
        ObjectStore.destroy(m_name);
        m_name = null;
    }

    @Override
    public ObjectReference ODIgetRef()
    {
        return ODIref;
    }

    @Override
    public void ODIsetRef(ObjectReference objectreference)
    {
        ODIref = objectreference;
    }

    @Override
    public byte ODIgetState()
    {
        return ODIObjectState;
    }

    @Override
    public void ODIsetState(byte byte0)
    {
        ODIObjectState = byte0;
    }

    @Override
    protected synchronized Object clone()
        throws CloneNotSupportedException
    {
        if(ODIObjectState < 0)
        {
            ObjectStore.fetch(this);
        }
        CollectionElement collectionElement = (CollectionElement)super.clone();
        collectionElement.ODITheHashCode = collectionElement.ODIComputeHashCode();
        collectionElement.ODIref = null;
        collectionElement.ODIObjectState = 0;
        return collectionElement;
    }

    @Override
    public void postInitializeContents()
    {
    }

    @Override
    public void preFlushContents()
    {
    }

    @Override
    public void preClearContents()
    {
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }
    
    @Override
    public int hashCode()
    {
        if(ODIObjectState < 0)
        {
            ObjectStore.fetch(this);
        }
        return ODITheHashCode;
    }

    private int ODIComputeHashCode()
    {
        return HashPersistent.getNextHashCode();
    }

    @Override
    public void initializeContents(GenericObject genericobject)
    {
        ClassInfo classinfo = myOdiClassInfoInstance;
        ODITheHashCode = genericobject.getIntField(1, classinfo);
        m_name = genericobject.getStringField(2, classinfo);
    }

    @Override
    public void flushContents(GenericObject genericobject)
    {
        ClassInfo classinfo = myOdiClassInfoInstance;
        genericobject.setIntField(1, ODITheHashCode, classinfo);
        genericobject.setStringField(2, m_name, classinfo);
    }

    @Override
    public void clearContents()
    {
        ODITheHashCode = 0;
        m_name = null;
    }

    public CollectionElement(ClassInfo classinfo)
    {
        ODITheHashCode = HashPersistent.getNextHashCode();
    }

    private static final ClassInfo getClassInfoInstance()
    {
        try
        {
            return ClassInfo.get(Class.forName("com.sonicsw.mf.framework.directory.storage.pse.CollectionElement"));
        }
        catch(ClassNotFoundException classnotfoundexception)
        {
            return null;
        }
    }

    private int ODITheHashCode;
    private String m_name;
    private transient ObjectReference ODIref;
    public transient byte ODIObjectState;
    static ClassInfo myOdiClassInfoInstance = getClassInfoInstance();

}