// Decompiled by DJ v3.2.2.67 Copyright 2002 Atanas Neshkov  Date: 6/7/2006 4:28:57 PM
// Home Page : http://members.fortunecity.com/neshkov/dj.html  - Check often for new version!
// Decompiler options: packimports(3) 
// Source File Name:   DSElement.java

package com.sonicsw.mf.framework.directory.storage.pse;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import com.odi.ClassInfo;
import com.odi.GenericObject;
import com.odi.IPersistent;
import com.odi.IPersistentHooks;
import com.odi.ObjectStore;
import com.odi.imp.ObjectAccess;
import com.odi.imp.ObjectReference;
import com.odi.util.HashPersistent;

import com.sonicsw.mtstorage.IStorage;

import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.impl.EntityName;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.framework.agent.EncryptionException;
import com.sonicsw.mf.framework.agent.PBE;
import com.sonicsw.mf.framework.directory.storage.DSEncryptionException;
import com.sonicsw.mf.framework.directory.storage.PackedDirUtil;

// Referenced classes of package com.sonicsw.mf.framework.directory.storage.pse:
//            ByteArrayWrapper, DSBlob

public class DSElement
    implements IPersistent, IPersistentHooks 
{

    public DSElement(String name, IDirElement el, String password)
        throws Exception
    {
        ODITheHashCode = HashPersistent.getNextHashCode();
        m_keepBlob = false;
       	 // The element can be null when we store a blob and its element
	// hasn't been stored yet; in that case, we must make an empty one
	// to store the element
        m_elementName = name;
        if(m_elementName == null)
        {
            System.out.println("!!!!!Created an element with no name");
        }
        else
        {
            char[] chars = m_elementName.toCharArray();
            int encodedLength = ObjectAccess.UTF8Length(chars, chars.length);
            if (encodedLength >= IStorage.MAX_KEY_LENGTH)
            {
                throw new java.lang.IllegalArgumentException("Invalid storage element key name (encoded length " +
                    encodedLength + " >= " + IStorage.MAX_KEY_LENGTH + "): \"" + name + '"');
            }
        }
        
        if(el != null)
        {
            ByteArrayOutputStream elByteStream = new ByteArrayOutputStream();
            ByteArrayOutputStream idByteStream = new ByteArrayOutputStream();
            IElementIdentity id = el.getIdentity();
            ObjectOutputStream elOStream = new ObjectOutputStream(elByteStream);
            ObjectOutputStream idOStream = new ObjectOutputStream(idByteStream);
            if(password == null)
            {
                elOStream.writeObject(el);
                idOStream.writeObject(id);
            } else
            {
                elOStream.writeObject(convertObjectToBytes(el, password));
                idOStream.writeObject(convertObjectToBytes(id, password));
            }
            elOStream.flush();
            idOStream.flush();
            elOStream.close();
            idOStream.close();
            m_element = new ByteArrayWrapper(elByteStream.toByteArray());
            m_id = new ByteArrayWrapper(idByteStream.toByteArray());
        }
    }

    public String getElementName()
    {
        if(ODIObjectState < 0)
        {
            ObjectStore.fetch(this);
        }
        return m_elementName;
    }

    public void setElementName(String name)
    {
        if(ODIObjectState < 0)
        {
            ObjectStore.fetch(this);
        }
        if(m_elementName != null)
        {
            ObjectStore.destroy(m_elementName);
        }
        if((ODIObjectState & 2) != 0)
        {
            ObjectStore.dirty(this);
        }
        m_elementName = name;
    }

    public byte[] getElement()
    {
        if(ODIObjectState < 0)
        {
            ObjectStore.fetch(this);
        }
        if(m_element != null)
        {
            return m_element.getBytes();
        }
        else
        {
            return null;
        }
    }

    public DSBlob getBlob()
    {
        if(ODIObjectState < 0)
        {
            ObjectStore.fetch(this);
        }
        return m_blob;
    }

    public void setBlob(DSBlob blob)
    {
        if(ODIObjectState < 0)
        {
            ObjectStore.fetch(this);
        }
        if(m_blob != null)
        {
            ObjectStore.destroy(m_blob);
        }
        if((ODIObjectState & 2) != 0)
        {
            ObjectStore.dirty(this);
        }
        m_blob = blob;
    }

    public IDirElement getIDirElement(String password)
        throws Exception
    {
        if(ODIObjectState < 0)
        {
            ObjectStore.fetch(this);
        }
        byte abyte0[];
        if(m_element != null)
        {
            abyte0 = m_element.getBytes();
            if(abyte0 != null)
            {
                ObjectStore.fetch(abyte0);
            }
            ByteArrayInputStream elByteStream = new ByteArrayInputStream(abyte0);
            ObjectInputStream elInputStream = new ObjectInputStream(elByteStream);
            IDirElement el;
            if(password == null)
            {
                try
                {
                    el = (IDirElement)elInputStream.readObject();
                }
                catch (ClassCastException castE)
                {
                    throw new DSEncryptionException("Directory Service data is encrypted and requires a password");
                }
            }
            else
            {
                el = (IDirElement)readEncryptedData(elInputStream, password);
            }
            return el;
        } else
        {
            return null;
        }
    }

    public IElementIdentity getElementIdentity(String password)
        throws Exception
    {
        if(ODIObjectState < 0)
        {
            ObjectStore.fetch(this);
        }
        byte abyte0[];
        if(m_id != null)
        {
            abyte0 = m_id.getBytes();
            if(abyte0 != null)
            {
                ObjectStore.fetch(abyte0);
            }
            ByteArrayInputStream idByteStream = new ByteArrayInputStream(abyte0);
            ObjectInputStream idInputStream = new ObjectInputStream(idByteStream);
            IElementIdentity id;
            if (password == null)
            {
                try
                {
                    id = (IElementIdentity)idInputStream.readObject();
                }
                catch (ClassCastException castE)
                {
                    throw new DSEncryptionException("Directory Service data is encrypted and needs a password");
                }
            }
            else
            {
                id = (IElementIdentity)readEncryptedData(idInputStream, password);
            }
            
            return id;
        } else
        {
            return null;
        }
    }

    public void setElement(byte element[])
    {
        if(ODIObjectState < 0)
        {
            ObjectStore.fetch(this);
        }
        if(m_element != null)
        {
            ObjectStore.destroy(m_element);
        }
        if((ODIObjectState & 2) != 0)
        {
            ObjectStore.dirty(this);
        }
        m_element = new ByteArrayWrapper(element);
    }

    public String getParentDirectory()
    {
        if(ODIObjectState < 0)
        {
            ObjectStore.fetch(this);
        }
        String parentName = "";
        try
        {
            parentName = (new EntityName(m_elementName)).getParent();
        }
        catch(Exception exception) { }
        return parentName;
    }

    public String getGroupName()
    {
        if(ODIObjectState < 0)
        {
            ObjectStore.fetch(this);
        }
        EntityName myEName = null;
        try
        {
            myEName = new EntityName(m_elementName);
        }
        catch(ConfigException configexception) { }
        if(myEName != null && PackedDirUtil.underPackedDir(myEName))
        {
            return myEName.getParentEntity().createChild(hashFunction(myEName.getBaseName())).getName();
        }
        else
        {
            return null;
        }
    }

    private String hashFunction(String elementName)
    {
        int fileIndex = elementName.hashCode();
        if(fileIndex < 0)
        {
            fileIndex *= -1;
        }
        int a0 = fileIndex;
        int a1 = a0 / 256;
        int a2 = a1 / 256;
        int a3 = a2 / 256;
        fileIndex = (a0 & 0xff ^ a1 & 0xff ^ a2 & 0xff ^ a3 & 0xff) % 64;
        return "_MF" + (new Integer(fileIndex)).toString();
    }

    private byte[] convertObjectToBytes(Object data, String password)
        throws Exception
    {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream objectOut = new ObjectOutputStream(out);
        objectOut.writeObject(data);
        byte abyte0[] = out.toByteArray();
        if(abyte0 != null)
        {
            ObjectStore.fetch(abyte0);
        }
        byte encBytes[] = PBE.encrypt(abyte0, password);
        out.close();
        return encBytes;
    }

    //  decrypts Element's data
    private Object readEncryptedData(ObjectInputStream input, String password)
        throws Exception
    {
       
        Object inS = input.readObject();
        byte abyte0[] = null;
        try
        {
            abyte0 = (byte[])inS;
        }
        catch (ClassCastException castE)
        {
            throw new DSEncryptionException("Directory Service data is not encrypted and a password was provided.");
        }
        if(abyte0 != null)
        {
            ObjectStore.fetch(abyte0);
        }
        
        byte bytes[] = null;
        try
        {
            bytes = PBE.decrypt(abyte0, password);
        }
        catch (EncryptionException encrE)
        {
            throw new DSEncryptionException("Given password is incorrect.", (EncryptionException)encrE);
        }
        if(bytes != null)
        {
            ObjectStore.fetch(bytes);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        ObjectInputStream object = new ObjectInputStream(in);
        return object.readObject();
        
    }

    @Override
    public void preDestroyPersistent()
    {
        if((ODIObjectState & 2) != 0)
        {
            ObjectStore.dirty(this);
        }
        ObjectStore.destroy(m_elementName);
        m_elementName = null;
        ObjectStore.destroy(m_element);
        m_element = null;
        ObjectStore.destroy(m_id);
        m_id = null;
        if(m_blob != null && !m_keepBlob)
        {
            ObjectStore.destroy(m_blob);
            m_blob = null;
        }
        // keepBlob is good only for one attempt at delete
        m_keepBlob = false;
    }

    public void keepBlob(boolean keepBlob)
    {
        if((ODIObjectState & 2) != 0)
        {
            ObjectStore.dirty(this);
        }
        m_keepBlob = keepBlob;
    }

    @Override
    public ObjectReference ODIgetRef()
    {
        return ODIref;
    }

    @Override
    public void ODIsetRef(ObjectReference objectreference)
    {
        ODIref = objectreference;
    }

    @Override
    public byte ODIgetState()
    {
        return ODIObjectState;
    }

    @Override
    public void ODIsetState(byte byte0)
    {
        ODIObjectState = byte0;
    }

    @Override
    protected synchronized Object clone()
        throws CloneNotSupportedException
    {
        if(ODIObjectState < 0)
        {
            ObjectStore.fetch(this);
        }
        DSElement dselement = (DSElement)super.clone();
        dselement.ODITheHashCode = dselement.ODIComputeHashCode();
        dselement.ODIref = null;
        dselement.ODIObjectState = 0;
        return dselement;
    }

    @Override
    public void postInitializeContents()
    {
    }

    @Override
    public void preFlushContents()
    {
    }

    @Override
    public void preClearContents()
    {
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }
    
    @Override
    public int hashCode()
    {
        if(ODIObjectState < 0)
        {
            ObjectStore.fetch(this);
        }
        return ODITheHashCode;
    }

    private int ODIComputeHashCode()
    {
        return HashPersistent.getNextHashCode();
    }

    @Override
    public void initializeContents(GenericObject genericobject)
    {
        ClassInfo classinfo = myOdiClassInfoInstance;
        ODITheHashCode = genericobject.getIntField(1, classinfo);
        m_elementName = genericobject.getStringField(2, classinfo);
        m_element = (ByteArrayWrapper)genericobject.getClassField(3, classinfo);
        m_id = (ByteArrayWrapper)genericobject.getClassField(4, classinfo);
        m_blob = (DSBlob)genericobject.getClassField(5, classinfo);
    }

    @Override
    public void flushContents(GenericObject genericobject)
    {
        ClassInfo classinfo = myOdiClassInfoInstance;
        genericobject.setIntField(1, ODITheHashCode, classinfo);
        genericobject.setStringField(2, m_elementName, classinfo);
        genericobject.setClassField(3, m_element, classinfo);
        genericobject.setClassField(4, m_id, classinfo);
        genericobject.setClassField(5, m_blob, classinfo);
    }

    @Override
    public void clearContents()
    {
        ODITheHashCode = 0;
        m_elementName = null;
        m_element = null;
        m_id = null;
        m_blob = null;
    }

    public DSElement(ClassInfo classinfo)
    {
        ODITheHashCode = HashPersistent.getNextHashCode();
    }

    private static final ClassInfo getClassInfoInstance()
    {
        try
        {
            return ClassInfo.get(Class.forName("com.sonicsw.mf.framework.directory.storage.pse.DSElement"));
        }
        catch(ClassNotFoundException classnotfoundexception)
        {
            return null;
        }
    }

    private int ODITheHashCode;
    private String m_elementName;
    private ByteArrayWrapper m_element;
    private ByteArrayWrapper m_id;
    DSBlob m_blob;  // null for non-blob elements
    private transient boolean m_keepBlob;
    private transient ObjectReference ODIref;
    public transient byte ODIObjectState;
    static ClassInfo myOdiClassInfoInstance = getClassInfoInstance();

}