/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.framework.elementversion;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.dirconfig.IDirElement;

/**
 * This interface should be implemented in order to receive notifications for
 * multiple Configuration Element Modifications in the Directory Service or the Cache.
 */

public interface IArrayElementNotificationListener extends INotificationListener
{
 /**
  * Handles modifications in a list of elements.
  *
  * @param elements the list of element and delta element objects 
  *
  */
  public void elementsChanged(IBasicElement[] elements);

 /**
  * Handles new or deleted elements as a group.
  *
  * @param elements the list of element objects
  *
  */
  public void elementsChanged(IDirElement[] elements);

}
