/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.framework.elementversion;
import com.sonicsw.mf.common.config.IBasicElement;

/**
 * This interface must be implemented by an IDirectoryService client or an IConfigCacheView client
 * who wish to receive directory or cache modification notifications.
 */
public interface IElementNotificationListener extends INotificationListener
{
   /**
    * Handles an element modification notification.
    *
    * @param element the element or delta element which contains the modification information
    *
    */
    public void elementChanged(IBasicElement element);
}
