/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.framework.elementversion;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.dirconfig.IDirElement;

public class NotificationConsumer implements INotificationConsumer
{
    IArrayElementNotificationListener m_arrayListener;
    IElementNotificationListener m_listener;

    public NotificationConsumer (IArrayElementNotificationListener listener)
    {
        m_arrayListener = listener;
        m_listener = null;
    }

    public NotificationConsumer (IElementNotificationListener listener)
    {
        m_listener = listener;
        m_arrayListener = null;
    }

    public void elementsChanged(IBasicElement[] elements)
    {
        if (m_arrayListener != null)
        {
            m_arrayListener.elementsChanged(elements);
        }
    }

    public void elementsChanged(IDirElement[] elements)
    {
        if (m_arrayListener != null)
        {
            m_arrayListener.elementsChanged(elements);
        }
    }

    public void elementChanged(IBasicElement element)
    {
        if (m_listener != null)
        {
            m_listener.elementChanged(element);
        }
    }
    
    @Override
    public INotificationListener getListener()
    {
        if (m_listener != null)
        {
            return m_listener;
        }
        else
        {
            return m_arrayListener;
        }
    }

    @Override
    public void close()
    {
        m_listener = null;
        m_arrayListener = null;
    }
}

