package com.sonicsw.mf.framework.hostmanager;

import java.util.ArrayList;
import java.util.Properties;

import javax.management.MBeanAttributeInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

import com.sonicsw.mx.util.IEmptyArray;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementChange;
import com.sonicsw.mf.common.runtime.IComponentState;
import com.sonicsw.mf.common.runtime.IFileDescriptor;
import com.sonicsw.mf.common.runtime.INotification;
import com.sonicsw.mf.common.runtime.IRemoteCallResult;
import com.sonicsw.mf.common.runtime.IRemoteExecResult;
import com.sonicsw.mf.common.runtime.Level;
import com.sonicsw.mf.framework.AbstractFrameworkComponent;
import com.sonicsw.mf.framework.IHostManager;



public final class HostManager
extends AbstractFrameworkComponent
{
    private IHostManager m_hostManager;

    private static final ArrayList<MBeanAttributeInfo> ATTRIBUTE_INFOS = new ArrayList<MBeanAttributeInfo>();
    private static final ArrayList<MBeanOperationInfo> OPERATION_INFOS = new ArrayList<MBeanOperationInfo>();
    private static final ArrayList<MBeanNotificationInfo> NOTIFICATION_INFOS = new ArrayList<MBeanNotificationInfo>();

    // Notifications
    public static final String FILE_DOWNLOADED_NOTIFICATION_TYPE = "RemoteFileDownloaded";
    public static final String REMOTE_EXEC_TYPE = "RemoteExec";
    public static final String INSTALL_LAUNCHER_TYPE = "InstallLauncher";
    public static final String SETUP_CONTAINER_TYPE = "SetupContainer";
    public static final String LAUNCH_CONTAINER_TYPE = "LaunchContainer";
    public static final String REMOVE_CONTAINER_TYPE = "RemoveContainer";
    public static final String FILE_DOWNLOADED_FROM_DS_NOTIFICATION_TYPE = "DSFileDownloaded";
    public static final String DELETE_FILES_TYPE = "DeleteFiles";


    static
    {
        //
        // Notifications
        //
        String[] notifTypes = null;

        // system.state.RemoteFileDownloaded
        notifTypes = new String[]
        {
            INotification.CATEGORY_TEXT[INotification.SYSTEM_CATEGORY],
            INotification.SUBCATEGORY_TEXT[INotification.STATE_SUBCATEGORY],
            FILE_DOWNLOADED_NOTIFICATION_TYPE
        };
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, INotification.CLASSNAME, "Remote file-system file or directory downloaded."));

        notifTypes = new String[]
        {
            INotification.CATEGORY_TEXT[INotification.SYSTEM_CATEGORY],
            INotification.SUBCATEGORY_TEXT[INotification.STATE_SUBCATEGORY],
            REMOTE_EXEC_TYPE
        };
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, INotification.CLASSNAME, "Remote system command executed."));

        notifTypes = new String[]
        {
            INotification.CATEGORY_TEXT[INotification.SYSTEM_CATEGORY],
            INotification.SUBCATEGORY_TEXT[INotification.STATE_SUBCATEGORY],
            INSTALL_LAUNCHER_TYPE
        };
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, INotification.CLASSNAME, "Launcher installed."));

        notifTypes = new String[]
        {
            INotification.CATEGORY_TEXT[INotification.SYSTEM_CATEGORY],
            INotification.SUBCATEGORY_TEXT[INotification.STATE_SUBCATEGORY],
            SETUP_CONTAINER_TYPE
        };
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, INotification.CLASSNAME, "New container setup."));

        notifTypes = new String[]
        {
            INotification.CATEGORY_TEXT[INotification.SYSTEM_CATEGORY],
            INotification.SUBCATEGORY_TEXT[INotification.STATE_SUBCATEGORY],
            LAUNCH_CONTAINER_TYPE
        };
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, INotification.CLASSNAME, "Container launched."));

        notifTypes = new String[]
        {
            INotification.CATEGORY_TEXT[INotification.SYSTEM_CATEGORY],
            INotification.SUBCATEGORY_TEXT[INotification.STATE_SUBCATEGORY],
            REMOVE_CONTAINER_TYPE
        };
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, INotification.CLASSNAME, "Container working directory files removed."));

        notifTypes = new String[]
        {
            INotification.CATEGORY_TEXT[INotification.SYSTEM_CATEGORY],
            INotification.SUBCATEGORY_TEXT[INotification.STATE_SUBCATEGORY],
            FILE_DOWNLOADED_FROM_DS_NOTIFICATION_TYPE
        };
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, INotification.CLASSNAME, "File or directory downloaded from the Directory Service."));

        notifTypes = new String[]
        {
            INotification.CATEGORY_TEXT[INotification.SYSTEM_CATEGORY],
            INotification.SUBCATEGORY_TEXT[INotification.STATE_SUBCATEGORY],
            DELETE_FILES_TYPE
        };
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, INotification.CLASSNAME, "File or directory were deleted."));



        //
        // Operations
        //
        MBeanParameterInfo[] mbParamInfos = null;


        OPERATION_INFOS.add(new MBeanOperationInfo("getJVMProperties", "Returns the JVM's system properties.",
                                                   IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, Properties.class.getName(), MBeanOperationInfo.INFO));

        mbParamInfos = new MBeanParameterInfo[]
        {
            new MBeanParameterInfo("dsFilePath", String.class.getName(), "File path in the DS."),
            new MBeanParameterInfo("destinationFilePath", String.class.getName(), "destination path on the container side."),
            new MBeanParameterInfo("rewriteIfExists", Boolean.class.getName(), "fails if false and the file already exists."),
            new MBeanParameterInfo("expandZip", Boolean.class.getName(), "if 'true' expand the zip file after downloading it.")
        };
        OPERATION_INFOS.add(new MBeanOperationInfo("downloadFileFromDS", "Download a file from the Directory Service into the container's file-system.",
                                                   mbParamInfos, IRemoteCallResult.class.getName(), MBeanOperationInfo.ACTION));

        mbParamInfos = new MBeanParameterInfo[]
        {
            new MBeanParameterInfo("directoryPath", String.class.getName(), "an absolute path or a path relative to the working directory of the container.")
        };
        OPERATION_INFOS.add(new MBeanOperationInfo("listDirectory", "Return the list of files and directories under directoryPath.",
                                                   mbParamInfos, IFileDescriptor[].class.getName(), MBeanOperationInfo.INFO));

        mbParamInfos = new MBeanParameterInfo[]
        {
            new MBeanParameterInfo("cmdarray", String[].class.getName(), "a specified system command. "),
            new MBeanParameterInfo("envp", String[].class.getName(), "array of strings, each element of which has environment variable settings in the format {name = value}, or null if the subprocess should inherit the environment of the current process."),
            new MBeanParameterInfo("workDirPath", String.class.getName(), "the working directory of the subprocess, or null if the subprocess should inherit the working directory of the current process."),
            new MBeanParameterInfo("inputBytes", byte[].class.getName(), "standrd input for the process (or null if there is no input)")
        };
        OPERATION_INFOS.add(new MBeanOperationInfo("remoteExec", "executes java.lang.Runtime.exec on the target container.",
                                                   mbParamInfos, IRemoteExecResult.class.getName(), MBeanOperationInfo.ACTION));

        mbParamInfos = new MBeanParameterInfo[]
        {
            new MBeanParameterInfo("srcFilePath", String.class.getName(), "the file or directory path on the container side.")
        };
        OPERATION_INFOS.add(new MBeanOperationInfo("fileToBytes", "Retrieves file(s) from the container's file-system as bytes.",
                                                   mbParamInfos, IRemoteCallResult.class.getName(), MBeanOperationInfo.INFO));

        mbParamInfos = new MBeanParameterInfo[]
        {
            new MBeanParameterInfo("source", byte[].class.getName(), "the bytes content of the created file(s)."),
            new MBeanParameterInfo("destinationFilePath", String.class.getName(), "destination path on the container side."),
            new MBeanParameterInfo("rewriteIfExists", Boolean.class.getName(), "fails if false and the file already exists.")
        };
        OPERATION_INFOS.add(new MBeanOperationInfo("bytesToFile", "creates a file (or a directory), delivered as a byte array, in the container's file-system.",
                                                   mbParamInfos, IRemoteCallResult.class.getName(), MBeanOperationInfo.ACTION));

        mbParamInfos = new MBeanParameterInfo[]
        {
            new MBeanParameterInfo("containerName", String.class.getName(), "container name."),
            new MBeanParameterInfo("launchAsWindowsService", Boolean.class.getName(), "if true and on Windows will launch the container as Windows Service.")
        };
        OPERATION_INFOS.add(new MBeanOperationInfo("launchContainer", "launches the specified container.",
                                                   mbParamInfos, IRemoteCallResult.class.getName(), MBeanOperationInfo.ACTION));

        mbParamInfos = new MBeanParameterInfo[]
        {
            new MBeanParameterInfo("sonicHome", String.class.getName(), "the home of this container."),
            new MBeanParameterInfo("containerName", String.class.getName(), "container name."),
            new MBeanParameterInfo("launchAsWindowsService", Boolean.class.getName(), "if true and on Windows will launch the container as Windows Service.")
        };
        OPERATION_INFOS.add(new MBeanOperationInfo("launchContainer", "launches the specified container in the specified sonic home.",
                                                   mbParamInfos, IRemoteCallResult.class.getName(), MBeanOperationInfo.ACTION));

        mbParamInfos = new MBeanParameterInfo[]
        {
            new MBeanParameterInfo("targetSonicHome", String.class.getName(), "install the launcher under this directory.")
        };
        OPERATION_INFOS.add(new MBeanOperationInfo("installLauncher", "install the launcher that launched the container that hosts this HM under the specified sonic home.",
                                                   mbParamInfos, IRemoteCallResult.class.getName(), MBeanOperationInfo.ACTION));

        mbParamInfos = new MBeanParameterInfo[]
        {
            new MBeanParameterInfo("properties", Properties.class.getName(), "the container setup properties."),
            new MBeanParameterInfo("INIEncryptionPassword", String.class.getName(), "an optional password for INI file encryption.")
        };
        OPERATION_INFOS.add(new MBeanOperationInfo("setupContainer", "setup a new container by generating the launch and Windows Service scripts and the container.ini file.",
                                                   mbParamInfos, IRemoteCallResult.class.getName(), MBeanOperationInfo.ACTION));


        mbParamInfos = new MBeanParameterInfo[]
        {
            new MBeanParameterInfo("containerDSPath", String.class.getName(), "the path of the container configuration in the DS."),
            new MBeanParameterInfo("unConfiguredProps", Properties.class.getName(), "the container setup unconfigured properties such as WINDOWS_SERVICE_NAME."),
            new MBeanParameterInfo("INIEncryptionPassword", String.class.getName(), "an optional password for INI file encryption.")
        };
        OPERATION_INFOS.add(new MBeanOperationInfo("setupContainer", "setup a new container, given its DS configuration, by generating the launch and Windows Service scripts and the container.ini file.",
                                                   mbParamInfos, IRemoteCallResult.class.getName(), MBeanOperationInfo.ACTION));


        mbParamInfos = new MBeanParameterInfo[]
        {
            new MBeanParameterInfo("sonicHome", String.class.getName(), "the sonic home used by the new container."),
            new MBeanParameterInfo("launcherVersion", String.class.getName(), "the launcher version used by the new container. If 'null' will use the same launcher version used to launch the remote container."),
            new MBeanParameterInfo("properties", Properties.class.getName(), "the container setup properties."),
            new MBeanParameterInfo("INIEncryptionPassword", String.class.getName(), "an optional password for INI file encryption.")
        };
        OPERATION_INFOS.add(new MBeanOperationInfo("setupContainer", "Setup a new container under the specified soniv home.",
                                                   mbParamInfos, IRemoteCallResult.class.getName(), MBeanOperationInfo.ACTION));


        mbParamInfos = new MBeanParameterInfo[]
        {
            new MBeanParameterInfo("containerName", String.class.getName(), "container name.")
        };
        OPERATION_INFOS.add(new MBeanOperationInfo("removeContainer", "Uninstall the Windows Service (if installed) and removes the working directory files.",
                                                   mbParamInfos, IRemoteCallResult.class.getName(), MBeanOperationInfo.ACTION));


        mbParamInfos = new MBeanParameterInfo[]
        {
            new MBeanParameterInfo("pathOfdirectoryOrFile", String.class.getName(), "the path of a directory or a file."),
            new MBeanParameterInfo("deleteContent", Boolean.class.getName(), "if true and 'pathOfdirectoryOrFile' is a directory, deletes the directory's content.")
        };
        OPERATION_INFOS.add(new MBeanOperationInfo("deleteFiles", "delete the file or directory.",
                                                   mbParamInfos, IRemoteCallResult.class.getName(), MBeanOperationInfo.ACTION));

        mbParamInfos = new MBeanParameterInfo[]
        {
            new MBeanParameterInfo("includeLoopback", Boolean.class.getName(), "if true include the loopback addresses.")
        };
        OPERATION_INFOS.add(new MBeanOperationInfo("getAllHostnamesAndIPs", "gets all known hostnames and ip addresses of this machine.",
                                                   mbParamInfos, String[].class.getName(), MBeanOperationInfo.INFO));

    }

    @Override
    public MBeanAttributeInfo[] getAttributeInfos() { return (MBeanAttributeInfo[])ATTRIBUTE_INFOS.toArray(IEmptyArray.EMPTY_ATTRIBUTE_INFO_ARRAY); }

    @Override
    public MBeanOperationInfo[] getOperationInfos() { return OPERATION_INFOS.toArray(IEmptyArray.EMPTY_OPERATION_INFO_ARRAY); }

    @Override
    public MBeanNotificationInfo[] getNotificationInfos() { return NOTIFICATION_INFOS.toArray(IEmptyArray.EMPTY_NOTIFICATION_INFO_ARRAY); }

    @Override
    public void init(IComponentContext context)
    {
        super.init(context);

        IElement hmanagerConfig = context.getConfiguration(true);
    }

    @Override
    public synchronized void start()
    {

        if (super.m_state == IComponentState.STATE_ONLINE)
        {
            return;
        }

        m_hostManager = m_frameworkContext.getHostManager();

        super.start();

    }


    @Override
    public synchronized void stop()
    {
        if (super.m_state == IComponentState.STATE_OFFLINE)
        {
            return;
        }

        super.m_state = IComponentState.STATE_STOPPING;

        super.stop();
    }

    @Override
    public void destroy()
    {
        super.destroy();
    }


    public Properties getJVMProperties()
    {
        return m_hostManager.getJVMProperties();
    }

    public IRemoteCallResult bytesToFile(byte[] src, String destinationFilePath, Boolean rewriteIfExists)
    {
        IRemoteCallResult result =  m_hostManager.bytesToFile(src, destinationFilePath, rewriteIfExists);

        INotification notification =
            m_context.createNotification(INotification.SYSTEM_CATEGORY,
                                         INotification.SUBCATEGORY_TEXT[INotification.STATE_SUBCATEGORY],
                                         FILE_DOWNLOADED_NOTIFICATION_TYPE,
                                         result.isSuccessful() ?  Level.INFO : Level.WARNING);


        notification.setAttribute("CreatedFilePath", destinationFilePath);
        notification.setAttribute("isSuccessful", Boolean.valueOf(result.isSuccessful()));
        m_context.sendNotification(notification);

        return result;
    }

    public IRemoteCallResult  installLauncher(String targetSonicHome)
    {
        IRemoteCallResult result = m_hostManager.installLauncher(targetSonicHome);

        INotification notification =
            m_context.createNotification(INotification.SYSTEM_CATEGORY,
                                         INotification.SUBCATEGORY_TEXT[INotification.STATE_SUBCATEGORY],
                                         INSTALL_LAUNCHER_TYPE,
                                         result.isSuccessful() ?  Level.INFO : Level.WARNING);


        notification.setAttribute("TargetSonicHome", targetSonicHome);
        notification.setAttribute("isSuccessful", Boolean.valueOf(result.isSuccessful()));
        m_context.sendNotification(notification);

        return result;
    }

    public IRemoteCallResult setupContainer(Properties props, String INIEncryptionPassword)
    {
        IRemoteCallResult result =  m_hostManager.setupContainer(props, INIEncryptionPassword);

        INotification notification =
            m_context.createNotification(INotification.SYSTEM_CATEGORY,
                                         INotification.SUBCATEGORY_TEXT[INotification.STATE_SUBCATEGORY],
                                         SETUP_CONTAINER_TYPE,
                                         result.isSuccessful() ?  Level.INFO : Level.WARNING);


        notification.setAttribute("SetupProperties", props);
        notification.setAttribute("isSuccessful", Boolean.valueOf(result.isSuccessful()));
        m_context.sendNotification(notification);

        return result;
    }

    public IRemoteCallResult setupContainer(String containerDSPath, Properties props, String INIEncryptionPassword)
    {
        IRemoteCallResult result = m_hostManager.setupContainer(containerDSPath, props, INIEncryptionPassword);

        INotification notification =
            m_context.createNotification(INotification.SYSTEM_CATEGORY,
                                         INotification.SUBCATEGORY_TEXT[INotification.STATE_SUBCATEGORY],
                                         SETUP_CONTAINER_TYPE,
                                         result.isSuccessful() ?  Level.INFO : Level.WARNING);


        notification.setAttribute("SetupUnconfiguredProperties", props);
        notification.setAttribute("ContainerDSPath", containerDSPath);
        notification.setAttribute("isSuccessful", Boolean.valueOf(result.isSuccessful()));
        m_context.sendNotification(notification);

        return result;


    }

    public IRemoteCallResult setupContainer(String sonicHome, String launcherVersion, Properties props, String INIEncryptionPassword)
    {
        IRemoteCallResult result =  m_hostManager.setupContainer(sonicHome, launcherVersion, props, INIEncryptionPassword);

        INotification notification =
            m_context.createNotification(INotification.SYSTEM_CATEGORY,
                                         INotification.SUBCATEGORY_TEXT[INotification.STATE_SUBCATEGORY],
                                         SETUP_CONTAINER_TYPE,
                                         result.isSuccessful() ?  Level.INFO : Level.WARNING);


        notification.setAttribute("SetupProperties", props);
        notification.setAttribute("SonicHome", sonicHome);
        notification.setAttribute("isSuccessful", Boolean.valueOf(result.isSuccessful()));
        m_context.sendNotification(notification);

        return result;
    }

    public IRemoteCallResult launchContainer(String containerName, Boolean launchAsWindowsService)
    {
        IRemoteCallResult result =  m_hostManager.launchContainer(containerName, launchAsWindowsService);

        INotification notification =
            m_context.createNotification(INotification.SYSTEM_CATEGORY,
                                         INotification.SUBCATEGORY_TEXT[INotification.STATE_SUBCATEGORY],
                                         LAUNCH_CONTAINER_TYPE,
                                         result.isSuccessful() ?  Level.INFO : Level.WARNING);

        notification.setAttribute("ContainerName", containerName);
        notification.setAttribute("LaunchAsWindowsService", launchAsWindowsService);
        notification.setAttribute("isSuccessful", Boolean.valueOf(result.isSuccessful()));
        m_context.sendNotification(notification);

        return result;
    }

    public IRemoteCallResult launchContainer(String sonicHome, String containerName, Boolean launchAsWindowsService)
    {
        IRemoteCallResult result = m_hostManager.launchContainer(sonicHome, containerName, launchAsWindowsService);

        INotification notification =
            m_context.createNotification(INotification.SYSTEM_CATEGORY,
                                         INotification.SUBCATEGORY_TEXT[INotification.STATE_SUBCATEGORY],
                                         LAUNCH_CONTAINER_TYPE,
                                         result.isSuccessful() ?  Level.INFO : Level.WARNING);

        notification.setAttribute("SonicHome", sonicHome);
        notification.setAttribute("ContainerName", containerName);
        notification.setAttribute("LaunchAsWindowsService", launchAsWindowsService);
        notification.setAttribute("isSuccessful", Boolean.valueOf(result.isSuccessful()));
        m_context.sendNotification(notification);

        return result;
    }

    public IRemoteCallResult deleteFiles(String pathOfdirectoryOrFile, Boolean deleteContent)
    {
        IRemoteCallResult result =  m_hostManager.deleteFiles(pathOfdirectoryOrFile, deleteContent);

        INotification notification =
            m_context.createNotification(INotification.SYSTEM_CATEGORY,
                                         INotification.SUBCATEGORY_TEXT[INotification.STATE_SUBCATEGORY],
                                         DELETE_FILES_TYPE,
                                         result.isSuccessful() ?  Level.INFO : Level.WARNING);

        notification.setAttribute("PathOfdirectoryOrFile", pathOfdirectoryOrFile);
        notification.setAttribute("isSuccessful", Boolean.valueOf(result.isSuccessful()));
        m_context.sendNotification(notification);


        return result;
    }

    public IRemoteCallResult removeContainer(String containerName)
    {
        IRemoteCallResult result = m_hostManager.removeContainer(containerName);

        INotification notification =
            m_context.createNotification(INotification.SYSTEM_CATEGORY,
                                         INotification.SUBCATEGORY_TEXT[INotification.STATE_SUBCATEGORY],
                                         REMOVE_CONTAINER_TYPE,
                                         result.isSuccessful() ?  Level.INFO : Level.WARNING);

        notification.setAttribute("ContainerName", containerName);
        notification.setAttribute("isSuccessful", Boolean.valueOf(result.isSuccessful()));
        m_context.sendNotification(notification);

        return result;
    }

    public IRemoteCallResult fileToBytes(String srcFilePath)
     {
         IRemoteCallResult result = m_hostManager.fileToBytes(srcFilePath);

         return result;
    }

    public IRemoteCallResult downloadFileFromDS(String dsFilePath, String destinationFilePath, Boolean rewriteIfExists, Boolean expandZip)
    {
        IRemoteCallResult result = m_hostManager.downloadFileFromDS(dsFilePath, destinationFilePath, rewriteIfExists, expandZip);

        INotification notification =
            m_context.createNotification(INotification.SYSTEM_CATEGORY,
                                         INotification.SUBCATEGORY_TEXT[INotification.STATE_SUBCATEGORY],
                                         FILE_DOWNLOADED_FROM_DS_NOTIFICATION_TYPE,
                                         result.isSuccessful() ?  Level.INFO : Level.WARNING);


        notification.setAttribute("DSFilePath", dsFilePath);
        notification.setAttribute("CreatedFilePath", destinationFilePath);
        notification.setAttribute("isSuccessful", Boolean.valueOf(result.isSuccessful()));
        m_context.sendNotification(notification);

        return result;
    }

    public IFileDescriptor[] listDirectory(String directoryPath)
    {
        return m_hostManager.listDirectory(directoryPath);
    }

    public IRemoteExecResult remoteExec(String[] cmdarray, String[] envp, String workDirPath, byte[] inputBytes)
    {
        IRemoteExecResult result = m_hostManager.remoteExec(cmdarray, envp, workDirPath, inputBytes);

        INotification notification =
            m_context.createNotification(INotification.SYSTEM_CATEGORY,
                                         INotification.SUBCATEGORY_TEXT[INotification.STATE_SUBCATEGORY],
                                         REMOTE_EXEC_TYPE,
                                         result.isSuccessful() ?  Level.INFO : Level.WARNING);


        notification.setAttribute("CommandArray", cmdarray);
        notification.setAttribute("Environment", envp);
        notification.setAttribute("WorkingDirPath", workDirPath);
        notification.setAttribute("isSuccessful", Boolean.valueOf(result.isSuccessful()));
        m_context.sendNotification(notification);

        return result;
    }

    public String[] getAllHostnamesAndIPs(Boolean includeLoopback)
    {
        return m_hostManager.getAllHostnamesAndIPs(includeLoopback);
    }
    
    @Override
    public synchronized void handleElementChange(IElementChange elementChange)
    {
        super.m_context.fireAttributeChangeHandlers();
    }


}
