// Copyright (c) 2009 Progress Software Corporation. All Rights Reserved.

package com.sonicsw.mf.framework.logger;

import com.sonicsw.mf.common.metrics.IHistoricalMetric;
import com.sonicsw.mf.common.runtime.INotification;

/**
 * Interface used to format log entries.
 */
interface LogFormatter
{
    /**
     * Returns the formatted historical metric.
     * @param metric the historical metric
     * @return the formatted historical metric
     */
    Object formatHistoricalMetric(IHistoricalMetric metric);

    /**
     * Returns the formatted notification.
     * @param notification the notification
     * @return the formatted notification
     */
    Object formatNotification(INotification notification);
}

