// Copyright 2001-2016 Aurea Software, Inc. All Rights Reserved.
package com.sonicsw.mf.framework.monitor.offload;

import com.sonicsw.mf.common.metrics.IMetric;
import com.sonicsw.mf.common.runtime.ICanonicalName;
import com.sonicsw.mf.common.runtime.INotification;
import com.sonicsw.mf.common.runtime.impl.CanonicalName;
import com.sonicsw.mf.framework.monitor.IOffloadListener;
import com.sonicsw.mf.framework.monitor.offload.spi.IAnalyticsOffload;

import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public class AnalyticsOffloader {


    private static AnalyticsOffloader m_singleton;
    private ServiceLoader<IAnalyticsOffload> m_loader;
    private IOffloadListener m_listener = null;

    private AnalyticsOffloader() {
        m_loader = ServiceLoader.load(IAnalyticsOffload.class);
    }

    public static synchronized AnalyticsOffloader getInstance() {
        if (m_singleton == null) {
        	m_singleton = new AnalyticsOffloader();
        }
        return m_singleton;
    }
    
    public boolean isDeployed() {
    	return m_loader.iterator().hasNext();
    }
    
    public IOffloadListener getOffloadListener() {
		return m_listener;
	}

	public void setOffloadListener(IOffloadListener m_listener) {
		this.m_listener = m_listener;
	}

	/**
     * Open the offload stream.
     */
	public void init() throws AnalyticsOffloadException {
		try {
			for (IAnalyticsOffload d: m_loader) {
				d.init();
			}
		} catch (ServiceConfigurationError serviceError) {
			serviceError.printStackTrace();
			throw new AnalyticsOffloadException(serviceError);

		}
	}

    /**
     * Close the offload stream.
     */
	public void destroy() throws AnalyticsOffloadException {
		try {
			for (IAnalyticsOffload d: m_loader) {
				d.destroy();
			}
		} catch (ServiceConfigurationError serviceError) {
			serviceError.printStackTrace();

		}
	}

    /**
     * Open the offload stream.
     */
	public void start() throws AnalyticsOffloadException {
		try {
			for (IAnalyticsOffload d: m_loader) {
				d.start();
			}
		} catch (ServiceConfigurationError serviceError) {
			serviceError.printStackTrace();

		}
	}

    /**
     * Close the offload stream.
     */
	public void stop() throws AnalyticsOffloadException {
		try {
			for (IAnalyticsOffload d: m_loader) {
				d.stop();
			}
		} catch (ServiceConfigurationError serviceError) {
			serviceError.printStackTrace();

		}
	}

    /**
     * Offloads the given notification
     */
    public void offloadNotification(INotification notification)
    throws AnalyticsOffloadException {
		try {
			if (m_listener != null) {
				m_listener.onNotificationOffloaded(notification);
			}
			for (IAnalyticsOffload d: m_loader) {
				d.offloadNotification(notification);
			}
		} catch (ServiceConfigurationError serviceError) {
			serviceError.printStackTrace();

		}
    }

    /**
     * Offloads the given metrics
     */
    public void offloadMetrics(IMetric[] metrics, String source)
    throws AnalyticsOffloadException {
		try {
			if (m_listener != null) {
				m_listener.onMetricsOffloaded(metrics);
			}
			ICanonicalName sourceCanonicalName = new CanonicalName(source);
			for (IAnalyticsOffload d: m_loader) {
				d.offloadMetrics(metrics, sourceCanonicalName);
			}
		} catch (ServiceConfigurationError serviceError) {
			serviceError.printStackTrace();

		}
    }

}