// Copyright 2001-2016 Aurea Software, Inc. All Rights Reserved.
package com.sonicsw.mf.framework.monitor.offload.spi;

import com.sonicsw.mf.common.metrics.IMetric;
import com.sonicsw.mf.common.runtime.ICanonicalName;
import com.sonicsw.mf.common.runtime.INotification;
import com.sonicsw.mf.framework.monitor.offload.AnalyticsOffloadException;

/**
 * The Analytics Offload SPI(Service Provider Interface) provides the means by which developers can write extensions that
 * divert metric and notifications
 * collected by a Collections Monitor component directly into third party big-data/analytics engines. This data diversion
 * bypasses the normal internal storage mechanisms used by Collections Monitor, providing performance benefits and more
 * direct and easier integration with third party engines.
 * <P>
 * The Analytics Offload SPI consists primarily of the interface <i>com.sonicsw.mf.framework.monitor.offload.spi.IAnalyticsOffload</i>. 
 * <P>
 * It leverages the standard Java service provider extension mechanism for class-path introduced extensions.
 * <P>
 * To deploy an extension perform the following steps:
 * <OL type="1">
 *   <LI>Develop and compile the implementation sources. For this, mgmt_client.jar includes the SPI interfaces.
 *   <LI>Ensure the implementation jar contains the following file entry:
 *<br> 
 *       <i>META-INF/services/com.sonicsw.mf.framework.monitor.offload.spi.IAnalyticsOffload</i>
 *<br>       
 *          This file must contain a single text line that identifies the fully qualified class name of the 
 *          implementation class.
 *   <LI>Import implementation jar and dependent jars into the Sonic Directory Service
 *   <LI>Configure the Collections Monitor component resources pre-pend classpath to include the jars *1
 *   <LI>Start the MF container that hosts the Collections Monitor
 * </OL>
 *  
 * *1 Alternatively, jars may be specified in the hosting MF Container pre-pend classpath
 * 
 */
public interface IAnalyticsOffload
{
    /**
     * Open the offload provider - called on Collections Monitor initialization
     * @exception AnalyticsOffloadException
     */
    public void init()
    throws AnalyticsOffloadException;

    /**
     * Destroy the offload provider - called on Collections Monitor termination and cleanup.
     * @exception AnalyticsOffloadException
     */
    public void destroy()
    throws AnalyticsOffloadException;

    /**
     * Start the offload provider - called on Collections Monitor start.
      * @exception AnalyticsOffloadException
    */
    public void start()
    throws AnalyticsOffloadException;

    /**
     * Stop the offload provider  - called on Collections Monitor stop.
     * @exception AnalyticsOffloadException
     */
    public void stop()
    throws AnalyticsOffloadException;

    /**
     * Offload a notification
     * @param notification
     * @exception AnalyticsOffloadException
     * 
     */
    public void offloadNotification(INotification notification)
    throws AnalyticsOffloadException;

    /**
     * Offload collected metrics from a source component
     * @param metrics
     * @param source component canonical name
     * @exception AnalyticsOffloadException
     */
    public void offloadMetrics(IMetric[] metrics, ICanonicalName source)
    throws AnalyticsOffloadException;


}
