package com.sonicsw.mf.framework.monitor.storage;

import com.sonicsw.mf.framework.monitor.IEventHolder;

public class EventHolder implements IEventHolder
{
    private Object m_event;
    private long m_storageTimestamp;

    /**
     *  Create an instance of an IEventHolder.  If the input argmument for the event is an INotification object,
     *  then this will hold a notification event.  If the input argument for the event is an IHistoricalMetric object,
     *  then this will hold a metric event.
     *
     * @param event
     * @param storageTimestamp
     */
    public EventHolder(Object event, long storageTimestamp)
    {
        m_event = event;
        m_storageTimestamp = storageTimestamp;
    }

    /**
     *  Returns a reference to the actual Event object.  If the instance is created as a result of a query
     *  for notifications, then this will return a reference to an INotification object.  If the instance is
     *  created as a result of a query for metrics, then this will return a reference to an IHistoricalmMetric
     *  object.
     *
     * @return reference to either an INotification object or an IHistoricalMetric object, depending upon the context in which it is used
     */
     @Override
    public Object getEvent()
     {
         return m_event;
     }

     /**
      * Returns the time at which the event was actually stored in the underlying store.
      *
      * @return the time at which the event was actually stored in the underlying store (as a long).
      */
      @Override
    public long getStorageTimestamp()
      {
          return m_storageTimestamp;
      }
 }