package com.sonicsw.mf.framework.monitor.storage;

public class StorageException
extends RuntimeException
{
    private Throwable m_cause;
    
    public StorageException(String errorMsg)
    {
        this(errorMsg, null);
    }
    
    public StorageException(String errorMsg, Throwable cause)
    {
        super(errorMsg);
        initCause(cause);
    }
    
    @Override
    public Throwable getCause() { return m_cause; }
    
    @Override
    public final Throwable initCause(Throwable cause)
    {
        if (m_cause == this)
        {
            throw new IllegalArgumentException();
        }
            
        if (m_cause != null)
        {
            throw new IllegalStateException();
        }
        
        m_cause = cause;
        return this;
    }
}
