package com.sonicsw.mf.framework.monitor.storage.fs;

import com.odi.ClassInfo;
import com.odi.GenericObject;
import com.odi.IPersistent;
import com.odi.IPersistentHooks;
import com.odi.ObjectStore;
import com.odi.imp.ObjectReference;
import com.odi.util.HashPersistent;

import com.sonicsw.mf.common.metrics.IMetric;
import com.sonicsw.mf.common.metrics.MetricsFactory;

/**
 * Class to store a MF metric in the PSE Pro database.
 */
public class PSEMetric
implements IPersistent, IPersistentHooks, PSEObject
{
    private int ODITheHashCode;
    private transient ObjectReference ODIref;
    public transient byte ODIObjectState;
    private transient IMetric m_metric;
    static ClassInfo myOdiClassInfoInstance = getClassInfoInstance();

    private long m_timestamp;
    private long m_storageTimestamp;
    private String m_name;
    private String m_source;
    private byte[] m_bytes;

    PSEMetric(IMetric metric, String source)
    throws Exception
    {
        ODITheHashCode = HashPersistent.getNextHashCode();
        m_timestamp = 0 - metric.getCurrencyTimestamp();
        m_storageTimestamp = System.currentTimeMillis();
        m_name = new String(metric.getMetricIdentity().getName());
        m_source = new String(source);
        m_bytes = FSStorage.toBytes(MetricsFactory.createMetric(source, metric));
        m_metric = metric;
    }

    @Override
    public long getTimestamp()
    {
        if (ODIObjectState < 0)
        {
            ObjectStore.fetch(this);
        }
        return m_timestamp;
    }

    @Override
    public long getStorageTimestamp()
    {
        if (ODIObjectState < 0)
        {
            ObjectStore.fetch(this);
        }
        return m_storageTimestamp;
    }

    public String getName()
    {
        if (ODIObjectState < 0)
        {
            ObjectStore.fetch(this);
        }
        return m_name;
    }

    public String getSource()
    {
        if (ODIObjectState < 0)
        {
            ObjectStore.fetch(this);
        }
        return m_source;
    }

    @Override
    public Object getObject()
    throws Exception
    {
        if (ODIObjectState < 0)
        {
            ObjectStore.fetch(this);
        }
        if (m_bytes != null)
        {
            ObjectStore.fetch(m_bytes);
        }
        return FSStorage.fromBytes(m_bytes);
    }

    @Override
    public void postInitializeContents() { }

    @Override
    public void preDestroyPersistent()
    {
        if (ODIObjectState < 0)
        {
            ObjectStore.fetch(this);
        }
        if (m_name != null)
        {
            ObjectStore.destroy(m_name);
            if ((ODIObjectState & 2) != 0)
            {
                ObjectStore.dirty(this);
            }
            m_name = null;
        }
        if (m_source != null)
        {
            ObjectStore.destroy(m_source);
            if ((ODIObjectState & 2) != 0)
            {
                ObjectStore.dirty(this);
            }
            m_source = null;
        }
        if (m_bytes != null)
        {
            ObjectStore.destroy(m_bytes);
            if ((ODIObjectState & 2) != 0)
            {
                ObjectStore.dirty(this);
            }
            m_bytes = null;
        }
    }
    @Override
    public ObjectReference ODIgetRef()
    {
        return ODIref;
    }

    @Override
    public void ODIsetRef(ObjectReference objectreference)
    {
        ODIref = objectreference;
    }

    @Override
    public byte ODIgetState()
    {
        return ODIObjectState;
    }

    @Override
    public void ODIsetState(byte byte0)
    {
        ODIObjectState = byte0;
    }

    @Override
    protected synchronized Object clone()
        throws CloneNotSupportedException
    {
        if (ODIObjectState < 0)
        {
            ObjectStore.fetch(this);
        }
        PSEMetric psemetric = (PSEMetric)super.clone();
        psemetric.ODITheHashCode = psemetric.ODIComputeHashCode();
        psemetric.ODIref = null;
        psemetric.ODIObjectState = 0;
        return psemetric;
    }

    @Override
    public void preFlushContents() { }

    @Override
    public void preClearContents() { }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }
    
    @Override
    public int hashCode()
    {
        if (ODIObjectState < 0)
        {
            ObjectStore.fetch(this);
        }
        return ODITheHashCode;
    }

    private int ODIComputeHashCode()
    {
        return HashPersistent.getNextHashCode();
    }

    @Override
    public void initializeContents(GenericObject genericobject)
    {
        ClassInfo classinfo = myOdiClassInfoInstance;
        ODITheHashCode = genericobject.getIntField(1, classinfo);
        m_timestamp = genericobject.getLongField(2, classinfo);
        m_storageTimestamp = genericobject.getLongField(3, classinfo);
        m_name = genericobject.getStringField(4, classinfo);
        m_source = genericobject.getStringField(5, classinfo);
        m_bytes = (byte[])genericobject.getArrayField(6, classinfo);
    }

    @Override
    public void flushContents(GenericObject genericobject)
    {
        ClassInfo classinfo = myOdiClassInfoInstance;
        genericobject.setIntField(1, ODITheHashCode, classinfo);
        genericobject.setLongField(2, m_timestamp, classinfo);
        genericobject.setLongField(3, m_storageTimestamp, classinfo);
        genericobject.setStringField(4, m_name, classinfo);
        genericobject.setStringField(5, m_source, classinfo);
        genericobject.setArrayField(6, m_bytes, classinfo);
    }

    @Override
    public void clearContents()
    {
        ODITheHashCode = 0;
        m_timestamp = 0L;
        m_storageTimestamp = 0L;
        m_name = null;
        m_source = null;
        m_bytes = null;
    }

    public PSEMetric(ClassInfo classinfo)
    {
        ODITheHashCode = HashPersistent.getNextHashCode();
    }

    private static final ClassInfo getClassInfoInstance()
    {
        return ClassInfo.get(PSEMetric.class);
    }
    
    @Override
    public String toString()
    {
        if (ODIObjectState < 0)
        {
            ObjectStore.fetch(this);
        }

        return "{PSEMetric: m_timestamp=" + m_timestamp + ",m_name=" + m_name + ",m_source=" + m_source + '}';
    }
    
	public IMetric getMetric() {
		return m_metric;
	}

}
