package com.sonicsw.mf.framework.monitor.storage.fs;

import com.odi.ClassInfo;
import com.odi.GenericObject;
import com.odi.IPersistent;
import com.odi.IPersistentHooks;
import com.odi.ObjectStore;
import com.odi.imp.ObjectReference;
import com.odi.util.HashPersistent;

import com.sonicsw.mf.common.runtime.INotification;

/**
 * Class to store a MF notification in the PSE Pro database.
 */
public class PSENotification
implements IPersistent, IPersistentHooks, PSEObject
{
    private int ODITheHashCode;
    private transient ObjectReference ODIref;
    public transient byte ODIObjectState;
    static ClassInfo myOdiClassInfoInstance = getClassInfoInstance();

    private long m_timestamp;
    private long m_storageTimestamp;
    private String m_type;
    private String m_source;
    private byte[] m_bytes;
    private transient INotification m_notification;

    PSENotification(INotification notification)
    throws Exception
    {
        ODITheHashCode = HashPersistent.getNextHashCode();
        m_timestamp = 0 - notification.getTimeStamp();
        m_storageTimestamp = System.currentTimeMillis();
        m_type = new String(notification.getType());
        m_source = new String(notification.getSourceIdentity().getCanonicalName());
        m_bytes = FSStorage.toBytes(notification);
        m_notification = notification;
    }

    @Override
    public long getTimestamp()
    {
        if (ODIObjectState < 0)
        {
            ObjectStore.fetch(this);
        }
        return m_timestamp;
    }

    @Override
    public long getStorageTimestamp()
    {
        if (ODIObjectState < 0)
        {
            ObjectStore.fetch(this);
        }
        return m_storageTimestamp;
    }

    public String getType()
    {
        if (ODIObjectState < 0)
        {
            ObjectStore.fetch(this);
        }
        return m_type;
    }

    public String getSource()
    {
        if (ODIObjectState < 0)
        {
            ObjectStore.fetch(this);
        }
        return m_source;
    }

    @Override
    public Object getObject()
    throws Exception
    {
        if (ODIObjectState < 0)
        {
            ObjectStore.fetch(this);
        }
        if (m_bytes != null)
        {
            ObjectStore.fetch(m_bytes);
        }
        return FSStorage.fromBytes(m_bytes);
    }

    @Override
    public void postInitializeContents() { }

    @Override
    public void preDestroyPersistent()
    {
        if (ODIObjectState < 0)
        {
            ObjectStore.fetch(this);
        }
        if (m_type != null)
        {
            ObjectStore.destroy(m_type);
            if ((ODIObjectState & 2) != 0)
            {
                ObjectStore.dirty(this);
            }
            m_type = null;
        }
        if (m_source != null)
        {
            ObjectStore.destroy(m_source);
            if ((ODIObjectState & 2) != 0)
            {
                ObjectStore.dirty(this);
            }
            m_source = null;
        }
        if (m_bytes != null)
        {
            ObjectStore.destroy(m_bytes);
            if ((ODIObjectState & 2) != 0)
            {
                ObjectStore.dirty(this);
            }
            m_bytes = null;
        }
    }
    @Override
    public ObjectReference ODIgetRef()
    {
        return ODIref;
    }

    @Override
    public void ODIsetRef(ObjectReference objectreference)
    {
        ODIref = objectreference;
    }

    @Override
    public byte ODIgetState()
    {
        return ODIObjectState;
    }

    @Override
    public void ODIsetState(byte byte0)
    {
        ODIObjectState = byte0;
    }

    @Override
    protected synchronized Object clone()
        throws CloneNotSupportedException
    {
        if (ODIObjectState < 0)
        {
            ObjectStore.fetch(this);
        }
        PSENotification psenotification = (PSENotification)super.clone();
        psenotification.ODITheHashCode = psenotification.ODIComputeHashCode();
        psenotification.ODIref = null;
        psenotification.ODIObjectState = 0;
        return psenotification;
    }

    @Override
    public void preFlushContents() { }

    @Override
    public void preClearContents() { }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }
    
    @Override
    public int hashCode()
    {
        if (ODIObjectState < 0)
        {
            ObjectStore.fetch(this);
        }
        return ODITheHashCode;
    }

    private int ODIComputeHashCode()
    {
        return HashPersistent.getNextHashCode();
    }

    @Override
    public void initializeContents(GenericObject genericobject)
    {
        ClassInfo classinfo = myOdiClassInfoInstance;
        ODITheHashCode = genericobject.getIntField(1, classinfo);
        m_timestamp = genericobject.getLongField(2, classinfo);
        m_storageTimestamp = genericobject.getLongField(3, classinfo);
        m_type = genericobject.getStringField(4, classinfo);
        m_source = genericobject.getStringField(5, classinfo);
        m_bytes = (byte[])genericobject.getArrayField(6, classinfo);
    }

    @Override
    public void flushContents(GenericObject genericobject)
    {
        ClassInfo classinfo = myOdiClassInfoInstance;
        genericobject.setIntField(1, ODITheHashCode, classinfo);
        genericobject.setLongField(2, m_timestamp, classinfo);
        genericobject.setLongField(3, m_storageTimestamp, classinfo);
        genericobject.setStringField(4, m_type, classinfo);
        genericobject.setStringField(5, m_source, classinfo);
        genericobject.setArrayField(6, m_bytes, classinfo);
    }

    @Override
    public void clearContents()
    {
        ODITheHashCode = 0;
        m_timestamp = 0L;
        m_storageTimestamp = 0L;
        m_type = null;
        m_source = null;
        m_bytes = null;
    }

    public PSENotification(ClassInfo classinfo)
    {
        ODITheHashCode = HashPersistent.getNextHashCode();
    }

    private static final ClassInfo getClassInfoInstance()
    {
        return ClassInfo.get(PSENotification.class);
    }
    
    @Override
    public String toString()
    {
        if (ODIObjectState < 0)
        {
            ObjectStore.fetch(this);
        }

        return "{PSENotification: m_timestamp=" + m_timestamp + ",m_type" + m_type + ",m_source=" + m_source + '}';
    }

	public INotification getNotification() {
		return m_notification;
	}
}
