package com.sonicsw.mf.framework.security;

import java.util.StringTokenizer;

import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;

import com.sonicsw.mf.framework.IContainer;

public class AuditXMLLayout
extends Layout
{
    private static final boolean DEBUG = false;
    
    private boolean m_prettyXML = false;

    @Override
    public String format(LoggingEvent loggingEvent)
    {
        return m_prettyXML ? prettyXML((String)loggingEvent.getMessage()) : (String)loggingEvent.getMessage();
    }

    @Override
    public boolean ignoresThrowable()
    {
        return true;
    }

    @Override
    public void activateOptions()
    {
    }
    
    public void setPrettyXML(boolean prettyXML)
    {
        m_prettyXML = prettyXML;
    }
    
    public boolean getPrettyXML()
    {
        return m_prettyXML ;
    }

    private String prettyXML(String xml)
    {
        StringTokenizer st = new StringTokenizer(xml, "</", true);
        StringBuffer sb = new StringBuffer();
        int depth = -1;
        boolean elementEnded = false;
        boolean elementStarted = true;
        
        while (st.hasMoreTokens())
        {
            String token = st.nextToken();
            if (token.equals("<"))
            {
                String nextToken = st.nextToken();
                if (nextToken.equals("/"))
                {
                    if (!elementStarted)
                    {
                        for (int i = 0; i < depth; i++)
                        {
                            sb.append("  ");
                        }
                    }
                    sb.append(token).append(nextToken).append(st.nextToken());
                    sb.append(IContainer.NEWLINE);
                    depth--;
                    elementEnded = true;
                    elementStarted = false;
                    continue;
                }
                elementStarted = true;
                depth++;
                if (depth > 0)
                {
                    if (!elementEnded)
                    {
                        sb.append(IContainer.NEWLINE);
                    }
                    for (int i = 0; i < depth; i++)
                    {
                        sb.append("  ");
                    }
                }
                sb.append(token);
                token = nextToken;
                elementEnded = false;
            }
            else
            {
                elementEnded = false;
            }
            sb.append(token);
        }
        
        if (DEBUG)
        {
            System.out.println();
            System.out.println(xml);
            System.out.println();
            System.out.println(sb.toString());
            System.out.println();
        }
        
        return sb.toString();
    }
}
