package com.sonicsw.mf.framework.security;

import com.sonicsw.mf.common.security.IConfigureScopeBits;
import com.sonicsw.mf.framework.IFrameworkComponentContext;

public class ConfigurePermissionsMap
extends AbstractPermissionsMap
{
    private static final String CONFIGURE_PERMISSIONS_CONFIG_ID = "/permissions/configure";

    public ConfigurePermissionsMap(IFrameworkComponentContext context, AuthenticationPrincipalMap authenticationPrincipalMap)
    {
        super(context, authenticationPrincipalMap, CONFIGURE_PERMISSIONS_CONFIG_ID);
    }

    boolean hasPermission(String principal, String path, int requiredPermission, boolean isLogical)
    {
        // get the list of groups a user belongs to
        String[] groups = super.m_authenticationPrincipalMap.getGroups(principal);
        
        boolean isFolder = path.endsWith("/");
        
        int scope;
        // special case when using the root directory to check permissions for DS storage API
        if (path.equals("/") && !isLogical)
        {
            scope = IConfigureScopeBits.ALL_CONFIGURATIONS_AND_FILES_SCOPE;
        }
        else
        {
            scope = isFolder ? IConfigureScopeBits.THIS_FOLDER_SCOPE : IConfigureScopeBits.THIS_CONFIGURATION_OR_FILE_SCOPE;
        }
        int result = checkPermission(principal, path, groups, requiredPermission, scope);
        if (result == ALLOW)
        {
            return true;
        }
        if (result == DENY)
        {
            return false;
        }
        
        if (path.equals("/"))
        {
            return false;
        } 
        
        // try the parent directory and increase the scope
        String parentPath = getParentPath(path);
        scope = isFolder ? IConfigureScopeBits.ALL_FOLDERS_SCOPE : IConfigureScopeBits.ALL_CONFIGURATIONS_AND_FILES_SCOPE;
        result = checkPermission(principal, parentPath, groups, requiredPermission, scope);
        if (result == ALLOW)
        {
            return true;
        }
        if (result == DENY)
        {
            return false;
        }
        
        if (parentPath.equals("/"))
         {
            return false; // since the root folder's permissions have already been checked
        }
        
        // try the parent's parents
        scope = scope | IConfigureScopeBits.ALL_FOLDERS_SCOPE;
        parentPath = getParentPath(parentPath);
        
        return super.hasPermission(principal, parentPath, groups, requiredPermission, scope);
    }
}
