package com.sonicsw.mf.framework.util;

import java.util.Hashtable;

/**
 * The ContainerCompatibility is used by framework components to register and query
 * container versions for the purpose of determining specific feature compatibility.
 */
public class ContainerCompatibility
{
    private static final Hashtable m_containerVersionMap = new Hashtable();

    public static void addContainer(String runtimeID, short majorVersion, short minorVersion, short pointVersion, short build)
    {
        m_containerVersionMap.put(runtimeID, new short[] { majorVersion, minorVersion, pointVersion,  });
    }

    public static void removeContainer(String runtimeID)
    {
        m_containerVersionMap.remove(runtimeID);
    }

    // with the removal of supportsV2_1_1BatchedConfigChanges() and
    // isNonChunkingContainer() (see MQ-34639) the ContainerCompatibility
    // infrastructure does not currently serve any useful purpose.
    // It's been left in place for the time being in case we want to
    // make use of it in the future.

}
