package com.sonicsw.mf.jmx.client;

import javax.management.JMRuntimeException;

/**
 * This exception is used to wrap undefined exceptions trapped by the JMS/JMX connector client.
 *
 * @see JMSConnectorClient
 */
public final class CommunicationException
extends JMRuntimeException
{

    private CommunicationException(String s) { super(s); }
    
    /**
     * Creates a CommunicationException that has the
     * given with a detailed message.
     */
    public static CommunicationException create(String s) {
        return create(null, s);
    }

    /**
     * Creates a CommunicationException that wraps the actual java.lang.Throwable and has the
     * given with a detailed message.
     */
    public static CommunicationException create(Throwable throwable, String s) {
        CommunicationException exception = new CommunicationException(s);
        if (throwable != null)
        {
            exception.initCause(throwable);
        }
        return exception;
    }
    
    /**
     * Returns the actual java.lang.Throwable thrown.
     */
    public Throwable getTargetException()
    {
        return super.getCause();
    }
}
