package com.sonicsw.mf.jmx.client;


/**
 * Implementors are expected to handle connection changes reported by the connector.
 * <p>
 * A single implementation of this interface may be registered with a JMSConnectorClient
 * using JMSConnectorClient.setConnectionListener(IConnectionListener).
 * <p>
 * Transient connection conditions are reported using the onDisconnect() and onReconnect(String)
 * methods. Permanent failures are reported using the onFailure(Exception) method.
 * <p>
 * Note: This interface superseeds IExceptionListener.
 *
 * @see JMSConnectorClient#setConnectionListener(IConnectionListener)
 */
public interface IConnectionListener
extends com.sonicsw.mf.comm.IConnectionListener
{
    /**
     * Called when the connector automatically reconnects to the underlying transport.
     *
     * @see JMSConnectorClient#setConnectionListener(IConnectionListener)
     */
    @Override
    public void onReconnect(String localRoutingNode);

    /**
     * Called when the connector is disconnected from the underlying transport.
     * <p>
     * After this method has been called, further requests may be made on the
     * connector, however the behavior will depend on whether setFailWhenDisconnected(true)
     * was called on the connector. If set subsequent requests will immediately fail, if not
     * set requests will attempt to complete within the confines of the connectors timeouts.
     *
     * @see JMSConnectorClient#setConnectionListener(IConnectionListener)
     * @see JMSConnectorClient#setFailWhenDisconnected(boolean)
     */
    @Override
    public void onDisconnect();

    /**
     * Called when the connector detects some permanent failure in the underlying transport.
     * <p>
     * All subsequent requests on the connector will fail until a subsequent connect() is successfully
     * called on the connector.
     *
     * @see JMSConnectorClient#setConnectionListener(IConnectionListener)
     */
    @Override
    public void onFailure(Exception e);

    /**
     * Called when a connector is unable to renew a notification listener's subscription.
     * <p>
     * When notification listeners are added (and until they are removed), the connector will
     * attempt to periodically renew the listener's subscription as part of a feature that
     * avoids stale listeners on the server side, yet allows for temporary loss of target (e.g.
     * due to a component's container being shutdown and restarted) without having to re-add
     * the listener to the connector when the target again becomes available.
     * <p>
     * This method will not be called if the JMSConnectorClient is configured to use oneway
     * notification subscription requests.
     * 
     * @see com.sonicsw.mf.jmx.client.JMSConnectorClient#setUseOnewaySubscriptionRequests(boolean)
     */
    public void onNotificationListenerRenewalFailure(Exception e);
}
