package com.sonicsw.mf.jmx.client;

import java.util.Set;

import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;

/**
 * Since the original JMX spec, JMX now supports a remote API for the MBeanServer, thus this legacy interface
 * now extends that remote API.
 *
 * @see javax.management.MBeanServerConnection
 */
public interface IRemoteMBeanServer extends MBeanServerConnection
{
    public String connect(JMSConnectorAddress address);

    public void disconnect();

    @Override
    public ObjectInstance createMBean(String className, ObjectName objectName)
    throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException,
           MBeanException, NotCompliantMBeanException;

    @Override
    public ObjectInstance createMBean(String className, ObjectName objectName, ObjectName loaderName)
    throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException,
           MBeanException, NotCompliantMBeanException, InstanceNotFoundException;

    @Override
    public ObjectInstance createMBean(String className, ObjectName objectName, ObjectName loaderName, Object[] params, String[] signature)
    throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException,
           MBeanException, NotCompliantMBeanException, InstanceNotFoundException;

    @Override
    public ObjectInstance createMBean(String className, ObjectName objectName, Object[] params, String[]signature)
    throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException,
           MBeanException, NotCompliantMBeanException;

    @Override
    public Object getAttribute(ObjectName objectName, String attribute)
    throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException;

    @Override
    public AttributeList getAttributes(ObjectName objectName, String[] attributes)
    throws InstanceNotFoundException, ReflectionException;

    @Override
    public String getDefaultDomain();

    @Override
    public Integer getMBeanCount();

    @Override
    public MBeanInfo getMBeanInfo(ObjectName objectName)
    throws InstanceNotFoundException, IntrospectionException, ReflectionException;

    @Override
    public ObjectInstance getObjectInstance(ObjectName objectName)
    throws InstanceNotFoundException;

    @Override
    public Object invoke(ObjectName objectName, String operationName, Object[] params, String[] signature)
    throws InstanceNotFoundException, MBeanException, ReflectionException;

    public boolean isConnected();

    @Override
    public boolean isInstanceOf(ObjectName objectName, String className)
    throws InstanceNotFoundException;

    @Override
    public boolean isRegistered(ObjectName objectName);

    @Override
    public Set queryMBeans(ObjectName objectName, QueryExp query);

    @Override
    public Set queryNames(ObjectName objectName, QueryExp query);

    @Override
    public void setAttribute(ObjectName objectName, Attribute attribute)
    throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException,
           MBeanException, ReflectionException;

    @Override
    public AttributeList setAttributes(ObjectName objectName, AttributeList attributes)
    throws InstanceNotFoundException, ReflectionException;

    @Override
    public void unregisterMBean(ObjectName objectName)
    throws InstanceNotFoundException, MBeanRegistrationException;

    @Override
    public void addNotificationListener(ObjectName objectName, NotificationListener listener, NotificationFilter filter, Object handback)
    throws InstanceNotFoundException;

    @Override
    public void addNotificationListener(ObjectName objectName, ObjectName listener, NotificationFilter filter, Object handback)
    throws InstanceNotFoundException;

    @Override
    public void removeNotificationListener(ObjectName objectName, NotificationListener listener)
    throws InstanceNotFoundException, ListenerNotFoundException;

    @Override
    public void removeNotificationListener(ObjectName objectName, NotificationListener listener, NotificationFilter filter, Object handback)
    throws InstanceNotFoundException, ListenerNotFoundException;

    @Override
    public void removeNotificationListener(ObjectName objectName, ObjectName listener)
    throws InstanceNotFoundException, ListenerNotFoundException;

    @Override
    public void removeNotificationListener(ObjectName objectName, ObjectName listener, NotificationFilter filter, Object handback)
    throws InstanceNotFoundException, ListenerNotFoundException;
}
