package com.sonicsw.mf.jmx.util;

import java.util.Hashtable;

import javax.management.ObjectName;

import com.sonicsw.mf.jmx.client.JMSConnectorAddress;
import com.sonicsw.mf.jmx.client.JMSConnectorClient;
import com.sonicsw.mf.mgmtapi.runtime.IAgentProxy;
import com.sonicsw.mf.mgmtapi.runtime.MFProxyFactory;
import com.sonicsw.mf.mgmtapi.runtime.ProxyRuntimeException;

public class ShutdownContainer
{
    // arguments to this class are: url, user, password, domain, containername
    public static void main(String[] args)
    {
        String m_url = "localhost:2506";
        String m_username = "Administrator";
        String m_password = "Administrator";        //NOSONAR field change is not required.
        String m_domain = "Domain1";
        String m_container = "DomainManager";

        JMSConnectorClient connector = null;

        try
        {
            for (int i=0; i<args.length; i++)
            {
                if (args[i].startsWith("-"))
                {
                    if (args[i].equalsIgnoreCase("-url"))
                    {
                        m_url = args[++i];
                    }
                    else if (args[i].equalsIgnoreCase("-username"))
                    {
                        m_username = args[++i];
                    }
                    else if (args[i].equalsIgnoreCase("-password"))
                    {
                        m_password = args[++i];
                    }
                    else if (args[i].equalsIgnoreCase("-domain"))
                    {
                        m_domain = args[++i];
                    }
                    else if (args[i].equalsIgnoreCase("-container"))
                    {
                        m_container = args[++i];
                    }
                    else
                    {
                        throw new Exception("Mismatched argument: " + args[i]);
                    }
                }
            }
            // get a JMX connector
            connector = getConnector(m_url, m_username, m_password);
            // create a proxy to the broker component
            IAgentProxy agent = getAgentProxy(connector, m_domain, m_container);
            // shutdown the container
            agent.shutdown();
        }
        catch(Throwable t)
        {
            t.printStackTrace();
            if (t instanceof ProxyRuntimeException)
            {
                System.err.println("Caused by:");
                ((ProxyRuntimeException)t).getTargetException().printStackTrace();
            }
        }
        finally
        {
            if (connector != null)
            {
                connector.disconnect();
            }
        }
    }

    public static JMSConnectorClient getConnector(String urls, String user, String pwd)
    throws Exception
    {
        Hashtable env = new Hashtable();
        env.put("ConnectionURLs", urls);
        env.put("DefaultUser", user);
        env.put("DefaultPassword", pwd);

        JMSConnectorAddress address = new JMSConnectorAddress(env);
        JMSConnectorClient connector = new JMSConnectorClient();
        connector.connect(address, 30000);

        return connector;
    }

    /**
     * Gets a management proxy for an AGENT component; the AGENT component is used to
     * manage a container.
     */
    public static IAgentProxy getAgentProxy(JMSConnectorClient connector, String domain, String container)
    throws Exception
    {
        ObjectName jmxName = new ObjectName(domain + "." + container + ":ID=AGENT");
        return MFProxyFactory.createAgentProxy(connector, jmxName);
    }

}