/**
 * Copyright (c) 2003 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.mf.mgmtapi.config;

import java.util.List;

import com.sonicsw.ma.mgmtapi.config.MgmtException;

import com.sonicsw.mf.mgmtapi.config.gen.IAbstractAuthenticationDomainBean;

/**
 * Configuration Bean representing a AuthenticationDomain
 */
public interface IAuthenticationDomainBean extends IAbstractAuthenticationDomainBean
{

    /**
     * Return a list of user beans defined in this domain.
     * @return List of IAuthenticationUserBean objects
     * @throws MgmtException Thrown if there is some problem retrieving the beans
     */

    public List getUserBeans() throws MgmtException;

    /**
     * Return the user bean in this domain where the USER_NAME attribute is equal to name
     * @param name The desired USER_NAME
     * @throws MgmtException Thrown if there is some problem retrieving the bean or the bean does not exist.
     */

    public IAuthenticationUserBean getUserBean(String name) throws MgmtException;

    /**
     * Return a List of the group beans defined in this authentication domain
     * @return A List of IAuthenticationGroupBean objects
     * @throws MgmtException Thrown if there is some problem retrieving this data
     */

    public List getGroupBeans() throws MgmtException;

    /**
     * Return the group bean in this domain where the GROUP_NAME attribute is equal to name
     * @param name The desired GROUP_NAME
     * @throws MgmtException Thrown if there is some problem retrieving the bean or the bean does not exist.
     */

    public IAuthenticationGroupBean getGroupBean(String name) throws MgmtException;

    /**
     * Return a new user bean, with no attribute settings.
     * @return A new IAuthenticationUserBean
     * @throws MgmtException Thrown if there is some problem creating the user bean
     */

    public IAuthenticationUserBean createUserBean() throws MgmtException;
    public IAuthenticationUserBean createUserBean(String userName, String password) throws MgmtException;
    public IAuthenticationUserBean createUserBean(String userName, byte[] password) throws MgmtException;

    /**
     * Delete the user bean. The user will be deleted from the groups it belonged to.
     * @param bean The bean to be deleted.
     * @throws MgmtException Thrown if there is some problem deleting the bean.
     */

    public void deleteUserBean(IAuthenticationUserBean bean) throws MgmtException;

    /**
     * Return a new group bean, with no attribute settings.
     * @return A new IAuthenticationGroupBean
     * @throws MgmtException Thrown if there is some problem creating the group bean
     */

    public IAuthenticationGroupBean createGroupBean() throws MgmtException;

    /**
     * Delete the group bean.
     * @param bean The bean to be deleted.
     * @throws MgmtException Thrown if there is some problem deleting the bean.
     */

    public void deleteGroupBean(IAuthenticationGroupBean bean) throws MgmtException;

    /**
     * Returns true if this domain has been defined as external.
     * @return true if the domain is external, false otherwise
     */

    public boolean isExternal();

    /**
     * Inner class representing ConnectionParamMap
     * This inner class contains inner data items that are keyed off
     * a name. This class extends IAbstractConnectionParamMap
     */
    public interface IConnectionParamMap extends IAbstractConnectionParamMap
    {
    }

    /**
     * Inner class representing GroupMapType
     * This inner class contains inner data items that are keyed off
     * a name. This class extends IAbstractGroupMapType
     */
    public interface IGroupMapType extends IAbstractGroupMapType
    {
    }
}
