/**
 * Copyright (c) 2003 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mf.mgmtapi.config;

import com.sonicsw.mf.mgmtapi.config.gen.IAbstractCollectionsMonitorBean;

/**
 * Configuration Bean representing a CollectionsMonitor
 */
public interface ICollectionsMonitorBean extends IAbstractCollectionsMonitorBean
{

    /**
     * Inner class representing CollectionList
     * This inner class contains inner data items that have a zero based
     * index. This class extends IAbstractCollectionList
     */
    public interface ICollectionList extends IAbstractCollectionList
    {
    }

    /**
     * Inner class representing JdbcStorageType
     * This class extends IAbstractJdbcStorageType
     */
    public interface IJdbcStorageType extends IAbstractJdbcStorageType
    {
    }

    /**
     * Inner class representing FsStorageType
     * This class extends IAbstractFsStorageType
     */
    public interface IFsStorageType extends IAbstractFsStorageType
    {
    }


    /**
     * Inner class representing MetricsCollectionType
     * This class extends IAbstractMetricsCollectionType
     */
    public interface IMetricsCollectionType extends IAbstractCollectionsMonitorBean.IAbstractMetricsCollectionType
    {
    }

}
