/**
 * Copyright (c) 2003 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.mf.mgmtapi.config;

import com.sonicsw.mf.mgmtapi.config.gen.IAbstractComponentCollectionBean;

/**
 * Configuration Bean representing a 'ComponentCollection'
 */
public interface IComponentCollectionBean extends IAbstractComponentCollectionBean
{

    /**
     * Inner class representing NotifListType
     * This inner class contains inner data items that have a zero based
     * index. This class extends IAbstractNotifListType
     */
    public interface INotifListType extends IAbstractNotifListType
    {
    }

    /**
     * Inner class representing ComponentsSet
     * This inner class contains inner data items that are keyed off
     * a name. This class extends IAbstractComponentsSet
     */
    public interface IComponentsSet extends IAbstractComponentsSet
    {
    }

    /**
     * Inner class representing MonitorsSet
     * This inner class contains inner data items that are keyed off
     * a name. This class extends IAbstractMonitorsSet
     */
    public interface IMonitorsSet extends IAbstractMonitorsSet
    {
    }

    /**
     * Inner class representing MetricListType
     * This inner class contains inner data items that have a zero based
     * index. This class extends IAbstractMetricListType
     */
    public interface IMetricListType extends IAbstractMetricListType
    {
    }

    /**
     * Inner class representing Component
     * This class extends IAbstractComponent
     */
    public interface IComponent extends IAbstractComponent
    {
    }

    /**
     * Inner class representing MonitorType
     * This class extends IAbstractMonitorType
     */
    public interface IMonitorType extends IAbstractMonitorType
    {
    }

    /**
     * Inner class representing NotifList
     * This inner class contains inner data items that have a zero based
     * index. This class extends IAbstractNotifList
     */
    public interface INotifList extends IAbstractNotifList
    {
    }
}
